/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.data.itemdata;

import aiefu.eso.TagsUtils;
import aiefu.eso.data.itemdata.ItemData;
import aiefu.eso.exception.ItemDoesNotExistException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ItemDataPrepared {
    protected boolean isEmpty;
    public class_1792 item;
    public int amount;
    public List<class_1792> applicableItems;
    public List<ItemDataPrepared> itemList;
    public int pos;
    @Nullable
    public class_6862<class_1792> tagKey;
    public class_2487 compoundTag;
    public class_1792 remainderItem;
    public boolean remainderEmpty;
    public class_2487 remainderCompoundTag;
    public int remainderAmount;
    public boolean arrayOverride;
    public ItemData data;

    public ItemDataPrepared() {
        this.isEmpty = false;
        this.item = class_1802.field_8162;
        this.applicableItems = new ArrayList<class_1792>();
        this.pos = 0;
        this.remainderItem = class_1802.field_8162;
        this.remainderEmpty = false;
        this.arrayOverride = false;
    }

    public ItemDataPrepared(Void v) {
        this.isEmpty = false;
        this.item = class_1802.field_8162;
        this.applicableItems = new ArrayList<class_1792>();
        this.pos = 0;
        this.remainderItem = class_1802.field_8162;
        this.remainderEmpty = false;
        this.arrayOverride = false;
        this.isEmpty = true;
    }

    public ItemDataPrepared(ItemData data, class_2960 location, String eid, boolean shouldProcessArrays) throws ItemDoesNotExistException {
        block16: {
            block15: {
                this.isEmpty = false;
                this.item = class_1802.field_8162;
                this.applicableItems = new ArrayList<class_1792>();
                this.pos = 0;
                this.remainderItem = class_1802.field_8162;
                this.remainderEmpty = false;
                this.arrayOverride = false;
                this.data = data;
                if (data.itemArray == null || !shouldProcessArrays) break block15;
                this.itemList = new ArrayList<ItemDataPrepared>();
                for (ItemData d : data.itemArray) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(d.id));
                    if (item == class_1802.field_8162) {
                        throw new ItemDoesNotExistException("Item id " + String.valueOf(d) + " in id array not found in game registry for enchantment recipe " + eid);
                    }
                    this.applicableItems.add(item);
                    this.itemList.add(new ItemDataPrepared(d, location, eid, false));
                    this.arrayOverride = true;
                }
                break block16;
            }
            if (data.id == null) {
                this.isEmpty = true;
                return;
            }
            if (data.id.startsWith("tags#")) {
                this.tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(data.id.substring(5)));
            } else {
                this.item = (class_1792)class_7923.field_41178.method_10223(new class_2960(data.id));
                if (this.item == class_1802.field_8162) {
                    throw new ItemDoesNotExistException("Item id " + data.id + " not found in game registry for enchantment recipe " + eid);
                }
            }
            this.amount = data.amount;
            if (data.tag != null) {
                try {
                    this.compoundTag = new class_2522(new StringReader(data.tag)).method_10727();
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (data.remainderId == null) break block16;
            if (!(data.remainderId.isEmpty() || data.remainderId.isBlank() || data.remainderId.equalsIgnoreCase("empty"))) {
                this.remainderItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(data.remainderId));
                if (this.remainderItem == class_1802.field_8162) {
                    throw new ItemDoesNotExistException("Remainder item id " + data.remainderId + " not found in game registry for enchantment recipe " + eid);
                }
            } else {
                this.remainderEmpty = true;
            }
            this.remainderAmount = data.remainderAmount;
            if (data.remainderTag != null) {
                try {
                    this.remainderCompoundTag = new class_2522(new StringReader(data.remainderTag)).method_10727();
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Nullable
    public class_1799 getRemainderForStack(class_1799 stack) {
        if (this.remainderEmpty) {
            return stack.getRecipeRemainder();
        }
        if (this.remainderItem != class_1802.field_8162) {
            class_1799 s = new class_1799((class_1935)this.remainderItem, this.remainderAmount);
            s.method_7980(this.remainderCompoundTag);
            return s;
        }
        return stack.getRecipeRemainder();
    }

    public boolean testTag(class_1799 stack) {
        if (this.compoundTag == null) {
            return true;
        }
        if (!stack.method_7985()) {
            return false;
        }
        return TagsUtils.havePartialMatch(this.compoundTag, stack.method_7948());
    }

    public boolean testTag(class_1799 stack, class_2487 ref) {
        if (this.compoundTag == null) {
            return true;
        }
        if (!stack.method_7985()) {
            return false;
        }
        return TagsUtils.havePartialMatch(ref, stack.method_7948());
    }

    public boolean testItemStackMatch(class_1799 stack) {
        if (this.arrayOverride) {
            for (ItemDataPrepared ids : this.itemList) {
                if (ids.item != stack.method_7909() || stack.method_7947() < ids.amount || !this.testTag(stack, ids.compoundTag)) continue;
                this.amount = ids.amount;
                this.remainderItem = ids.remainderItem;
                this.remainderCompoundTag = ids.remainderCompoundTag;
                this.remainderAmount = ids.remainderAmount;
                return true;
            }
        } else if ((this.tagKey != null && stack.method_31573(this.tagKey) || stack.method_31574(this.item)) && stack.method_7947() >= this.amount) {
            return this.testTag(stack);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void processTags() {
        if (this.tagKey != null) {
            for (class_1792 i : class_7923.field_41178) {
                if (!i.method_40131().method_40220(this.tagKey)) continue;
                this.applicableItems.add(i);
            }
        }
    }

    public void resetPos() {
        this.pos = 0;
    }

    public void next() {
        if (++this.pos >= this.applicableItems.size()) {
            this.pos = 0;
        }
    }

    public ItemDataPrepared getNotNestedData() {
        return this.itemList.get(this.pos);
    }

    public class_1792 getApplicableItem() {
        return this.applicableItems.get(this.pos);
    }
}

