/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.data.client;

import aiefu.eso.data.client.BackgroundColorData;
import aiefu.eso.data.client.SliderColorData;
import aiefu.eso.data.client.TextSettings;
import net.minecraft.class_5251;
import net.minecraft.class_5253;

public class ColorDataHolder {
    protected int backgroundColor;
    protected float backgroundAlpha;
    protected int sliderOuterColor;
    protected int sliderInnerColor;
    protected float sliderAlpha;
    protected int textActiveColor;
    protected int textInactiveColor;
    protected boolean dropShadow;
    protected int searchBarHintColor;
    protected boolean searchBarHintDropShadow;

    public ColorDataHolder(BackgroundColorData bcd, SliderColorData scd, TextSettings tx) {
        this.backgroundColor = ColorDataHolder.getPackedColorFromHex(ColorDataHolder.checkHEXColor(bcd.hexColor), bcd.alpha);
        this.backgroundAlpha = bcd.alpha;
        this.sliderOuterColor = ColorDataHolder.getPackedColorFromHex(ColorDataHolder.checkHEXColor(scd.outerColor), scd.alpha);
        this.sliderInnerColor = ColorDataHolder.getPackedColorFromHex(ColorDataHolder.checkHEXColor(scd.innerColor), scd.alpha);
        this.sliderAlpha = scd.alpha;
        this.textActiveColor = class_5251.method_27719((String)tx.activeColor).method_27716();
        this.textInactiveColor = class_5251.method_27719((String)tx.inactiveColor).method_27716();
        this.dropShadow = tx.dropShadow;
        this.searchBarHintColor = class_5251.method_27719((String)tx.searchBarHintColor).method_27716();
        this.searchBarHintDropShadow = tx.isSearchBarDropShadow();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public int getSliderOuterColor() {
        return this.sliderOuterColor;
    }

    public int getSliderInnerColor() {
        return this.sliderInnerColor;
    }

    public float getSliderAlpha() {
        return this.sliderAlpha;
    }

    public int getTextActiveColor() {
        return this.textActiveColor;
    }

    public int getTextInactiveColor() {
        return this.textInactiveColor;
    }

    public boolean isDropShadow() {
        return this.dropShadow;
    }

    public int getSearchBarHintColor() {
        return this.searchBarHintColor;
    }

    public boolean isSearchBarHintDropShadow() {
        return this.searchBarHintDropShadow;
    }

    public static int getPackedColorFromHex(String hexCode, float alpha) {
        int resultRed = Integer.valueOf(hexCode.substring(0, 2), 16);
        int resultGreen = Integer.valueOf(hexCode.substring(2, 4), 16);
        int resultBlue = Integer.valueOf(hexCode.substring(4, 6), 16);
        return class_5253.class_5254.method_27764((int)((int)(alpha * 255.0f)), (int)resultRed, (int)resultGreen, (int)resultBlue);
    }

    public static String checkHEXColor(String s) {
        return s.startsWith("#") ? s.substring(1) : s;
    }
}

