/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.data;

import aiefu.eso.ESOCommon;
import aiefu.eso.Utils;
import aiefu.eso.data.itemdata.ItemData;
import aiefu.eso.data.itemdata.ItemDataPrepared;
import aiefu.eso.exception.ItemDoesNotExistException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class RecipeHolder {
    public static final ItemDataPrepared EMPTY = new ItemDataPrepared(null);
    public transient class_2960 ench_location;
    public transient boolean mode;
    public String enchantment_id;
    public int maxLevel;
    public Int2ObjectOpenHashMap<ItemDataPrepared[]> levels;
    public Int2IntOpenHashMap xpMap;

    public RecipeHolder(class_2960 ench_location, boolean mode, String enchantment_id, int maxLevel, Int2ObjectOpenHashMap<ItemDataPrepared[]> levels, Int2IntOpenHashMap xpMap) {
        this.ench_location = ench_location;
        this.mode = mode;
        this.enchantment_id = enchantment_id;
        this.maxLevel = maxLevel;
        this.levels = levels;
        this.xpMap = xpMap;
    }

    public void register() {
        List<RecipeHolder> list = ESOCommon.recipeMap.get(this.ench_location);
        if (list != null) {
            list.add(this);
        } else {
            list = new ArrayList<RecipeHolder>();
            list.add(this);
            ESOCommon.recipeMap.put(this.ench_location, list);
        }
    }

    public boolean check(class_1277 container, int targetLevel, class_1657 player) {
        int x = 0;
        ItemDataPrepared[] arr = (ItemDataPrepared[])this.levels.get(targetLevel);
        if (arr != null) {
            ArrayList<ItemDataPrepared> list = new ArrayList<ItemDataPrepared>();
            for (ItemDataPrepared prep : arr) {
                if (prep == null || prep.isEmpty()) continue;
                list.add(prep);
            }
            block1: for (ItemDataPrepared prep : list) {
                for (int i = 1; i < 5; ++i) {
                    class_1799 stack = container.method_5438(i);
                    if (!prep.testItemStackMatch(stack)) continue;
                    ++x;
                    continue block1;
                }
            }
            return x >= list.size() && this.checkXPRequirements(player, this.xpMap.get(targetLevel));
        }
        int xp = this.xpMap.get(targetLevel);
        if (xp > 0) {
            return this.checkXPRequirements(player, this.xpMap.get(targetLevel));
        }
        return false;
    }

    public boolean checkAndConsume(class_1277 container, int targetLevel, class_1657 player) {
        int x = 0;
        ItemDataPrepared[] arr = (ItemDataPrepared[])this.levels.get(targetLevel);
        if (arr != null) {
            Int2ObjectOpenHashMap stacksToConsume = new Int2ObjectOpenHashMap();
            ArrayList<ItemDataPrepared> list = new ArrayList<ItemDataPrepared>();
            for (ItemDataPrepared prep : arr) {
                if (prep == null || prep.isEmpty()) continue;
                list.add(prep);
            }
            block1: for (ItemDataPrepared prep : list) {
                for (int i = 1; i < 5; ++i) {
                    class_1799 stack = container.method_5438(i);
                    if (!prep.testItemStackMatch(stack)) continue;
                    stacksToConsume.put(i, (Object)prep);
                    ++x;
                    continue block1;
                }
            }
            if (x >= list.size() && this.checkXPRequirementsAndConsume(player, this.xpMap.get(targetLevel))) {
                for (Int2ObjectMap.Entry e : stacksToConsume.int2ObjectEntrySet()) {
                    class_1799 stack = container.method_5438(e.getIntKey());
                    ItemDataPrepared data = (ItemDataPrepared)e.getValue();
                    class_1799 remainder = data.getRemainderForStack(stack);
                    if (stack.method_7947() == 1 && remainder != null) {
                        container.method_5447(e.getIntKey(), remainder);
                        continue;
                    }
                    stack.method_7934(data.amount);
                }
                return true;
            }
        } else {
            int xp = this.xpMap.get(targetLevel);
            if (xp > 0) {
                return this.checkXPRequirementsAndConsume(player, xp);
            }
        }
        return false;
    }

    public boolean checkXPRequirements(class_1657 player, int cost) {
        if (cost < 1) {
            return true;
        }
        if (this.mode) {
            return cost <= Utils.getTotalAvailableXPPoints(player);
        }
        return player.field_7520 >= cost;
    }

    public boolean checkXPRequirementsAndConsume(class_1657 player, int cost) {
        if (cost < 1) {
            return true;
        }
        if (this.mode) {
            if (cost <= Utils.getTotalAvailableXPPoints(player)) {
                player.method_7255(-cost);
                return true;
            }
        } else if (player.field_7520 >= cost) {
            player.method_7316(-cost);
            return true;
        }
        return false;
    }

    public void processTags() {
        for (Int2ObjectMap.Entry e : this.levels.int2ObjectEntrySet()) {
            for (ItemDataPrepared data : (ItemDataPrepared[])e.getValue()) {
                data.processTags();
            }
        }
    }

    public int getMaxLevel(class_1887 enchantment) {
        return this.maxLevel < 1 ? enchantment.method_8183() : this.maxLevel;
    }

    public static class_5250 getFullName(class_1887 e, int level, int maxLevel) {
        class_5250 mutableComponent = class_2561.method_43471((String)e.method_8184());
        if (level != 1 || maxLevel != 1) {
            mutableComponent.method_10852(class_5244.field_41874).method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + level)));
        }
        return mutableComponent;
    }

    public static RecipeHolder deserialize(JsonObject jsonTree, class_2960 location, Map<class_2960, class_3298> fallbacks) throws IOException {
        String id = jsonTree.get("enchantment_id").getAsString();
        class_2960 fallback = jsonTree.has("fallback") ? new class_2960(jsonTree.get("fallback").getAsString()) : null;
        ArrayList dependsOn = new ArrayList();
        if (jsonTree.has("dependsOn")) {
            jsonTree.get("dependsOn").getAsJsonArray().forEach(jsonElement -> dependsOn.add(jsonElement.getAsString()));
        }
        if (!dependsOn.isEmpty()) {
            int i = 0;
            for (String s : dependsOn) {
                if (!FabricLoaderImpl.INSTANCE.isModLoaded(s)) continue;
                ++i;
            }
            if (i < dependsOn.size()) {
                return RecipeHolder.deserializeFallback(fallback, fallbacks);
            }
        }
        int maxLevel = jsonTree.has("maxLevel") ? jsonTree.get("maxLevel").getAsInt() : 0;
        boolean useXPPoints = jsonTree.has("useExpPoints") && jsonTree.get("useExpPoints").getAsBoolean();
        JsonElement map = jsonTree.get("levels");
        JsonElement map2 = jsonTree.has("xp") ? jsonTree.get("xp") : null;
        Int2ObjectOpenHashMap levels = (Int2ObjectOpenHashMap)ESOCommon.getGson().fromJson(map, new TypeToken<Int2ObjectOpenHashMap<ItemData[]>>(){}.getType());
        Int2IntOpenHashMap xpMap = map2 == null ? new Int2IntOpenHashMap() : (Int2IntOpenHashMap)ESOCommon.getGson().fromJson(map2, new TypeToken<Int2IntOpenHashMap>(){}.getType());
        Int2ObjectOpenHashMap levelsProcessed = new Int2ObjectOpenHashMap();
        try {
            for (Int2ObjectMap.Entry e : levels.int2ObjectEntrySet()) {
                if (e.getValue() == null) continue;
                ItemDataPrepared[] prepArr = new ItemDataPrepared[((ItemData[])e.getValue()).length];
                for (int i = 0; i < ((ItemData[])e.getValue()).length; ++i) {
                    ItemData data = ((ItemData[])e.getValue())[i];
                    prepArr[i] = new ItemDataPrepared(data, location, id, true);
                }
                levelsProcessed.put(e.getIntKey(), (Object)prepArr);
            }
        }
        catch (ItemDoesNotExistException exception) {
            exception.printStackTrace();
            ESOCommon.LOGGER.warn("Failed to deserialize recipe " + location.toString() + " trying to load fallback...");
            return RecipeHolder.deserializeFallback(fallback, fallbacks);
        }
        return new RecipeHolder(new class_2960(id), useXPPoints, id, maxLevel, (Int2ObjectOpenHashMap<ItemDataPrepared[]>)levelsProcessed, xpMap);
    }

    private static RecipeHolder deserializeFallback(class_2960 fallback, Map<class_2960, class_3298> fallbacks) throws IOException {
        class_3298 resource;
        if (fallback != null && (resource = fallbacks.get(fallback)) != null) {
            return RecipeHolder.deserialize(JsonParser.parseReader((Reader)resource.method_43039()).getAsJsonObject(), fallback, fallbacks);
        }
        return null;
    }

    public static RecipeHolder deserializeDefaultRecipe(class_2960 location) throws FileNotFoundException {
        String id = "default";
        Int2ObjectOpenHashMap levels = (Int2ObjectOpenHashMap)ESOCommon.getGson().fromJson((Reader)new FileReader("./config/eso/default-recipe.json"), new TypeToken<Int2ObjectOpenHashMap<ItemData[]>>(){}.getType());
        JsonObject jsonTree = JsonParser.parseReader((Reader)new FileReader("./config/eso/default-xp-map.json")).getAsJsonObject();
        boolean useXPPoints = jsonTree.has("useExpPoints") && jsonTree.get("useExpPoints").getAsBoolean();
        JsonElement xp = jsonTree.get("xp");
        Int2IntOpenHashMap xpMap = (Int2IntOpenHashMap)ESOCommon.getGson().fromJson(xp, new TypeToken<Int2IntOpenHashMap>(){}.getType());
        Int2ObjectOpenHashMap levelsProcessed = new Int2ObjectOpenHashMap();
        levels.forEach((k, v) -> {
            ItemDataPrepared[] prepArr = new ItemDataPrepared[((ItemData[])v).length];
            for (int i = 0; i < ((ItemData[])v).length; ++i) {
                ItemData data = v[i];
                try {
                    prepArr[i] = new ItemDataPrepared(data, location, id, true);
                    continue;
                }
                catch (ItemDoesNotExistException e) {
                    throw new RuntimeException(e);
                }
            }
            levelsProcessed.put(k.intValue(), (Object)prepArr);
        });
        return new RecipeHolder(new class_2960(id), useXPPoints, id, 0, (Int2ObjectOpenHashMap<ItemDataPrepared[]>)levelsProcessed, xpMap);
    }
}

