/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.data;

import aiefu.eso.ESOCommon;
import aiefu.eso.data.materialoverrides.MaterialData;
import aiefu.eso.data.materialoverrides.MaterialOverrides;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class MaterialDataLoader {
    public static final class_2960 mat_data_loader = new class_2960("enchanting-system-overhaul", "mat_data_loader");

    public static void registerReloadListener(final Gson gson) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleResourceReloadListener<MaterialOverrides>(){

            public class_2960 getFabricId() {
                return mat_data_loader;
            }

            public CompletableFuture<MaterialOverrides> load(class_3300 manager, class_3695 profiler, Executor executor) {
                return CompletableFuture.supplyAsync(() -> {
                    Map data = manager.method_14488("mat-overrides", resourceLocation -> resourceLocation.method_12832().endsWith(".json"));
                    HashMap<String, MaterialData> armor = new HashMap<String, MaterialData>();
                    HashMap<String, MaterialData> tools = new HashMap<String, MaterialData>();
                    HashMap<String, MaterialData> items = new HashMap<String, MaterialData>();
                    data.forEach((l, r) -> {
                        try {
                            JsonElement jsonTree = JsonParser.parseReader((Reader)r.method_43039());
                            JsonObject obj = jsonTree.getAsJsonObject();
                            String id = obj.get("material_id").getAsString();
                            String type = obj.get("type").getAsString();
                            MaterialData md = (MaterialData)gson.fromJson(jsonTree, MaterialData.class);
                            if (type.equalsIgnoreCase("armor")) {
                                armor.put(id, md);
                            } else if (type.equalsIgnoreCase("tool")) {
                                tools.put(id, md);
                            } else if (type.equalsIgnoreCase("item")) {
                                items.put(id, md);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    try {
                        return MaterialOverrides.readWithAttachments(tools, armor, items);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }, executor);
            }

            public CompletableFuture<Void> apply(MaterialOverrides data, class_3300 manager, class_3695 profiler, Executor executor) {
                return CompletableFuture.runAsync(() -> {
                    ESOCommon.mat_config = data;
                }, executor);
            }
        });
    }
}

