/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.data;

import aiefu.eso.client.ESOClient;
import aiefu.eso.data.client.BackgroundColorData;
import aiefu.eso.data.client.ColorDataHolder;
import aiefu.eso.data.client.SliderColorData;
import aiefu.eso.data.client.TextSettings;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class ColorsDataReloadListener {
    private static final class_2960 color_data_reload_listener = new class_2960("enchanting-system-overhaul", "color_data_reload_listener");

    public static void registerListener(final Gson gson) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleResourceReloadListener<ColorDataHolder>(){

            public class_2960 getFabricId() {
                return color_data_reload_listener;
            }

            public CompletableFuture<ColorDataHolder> load(class_3300 manager, class_3695 profiler, Executor executor) {
                return CompletableFuture.supplyAsync(() -> {
                    Optional background = manager.method_14486(new class_2960("enchanting-system-overhaul", "color-settings/background-color.json"));
                    Optional slider = manager.method_14486(new class_2960("enchanting-system-overhaul", "color-settings/slider-colors.json"));
                    Optional textColor = manager.method_14486(new class_2960("enchanting-system-overhaul", "color-settings/text-colors.json"));
                    try {
                        BackgroundColorData bcd = background.isPresent() ? (BackgroundColorData)gson.fromJson((Reader)((class_3298)background.get()).method_43039(), BackgroundColorData.class) : BackgroundColorData.getDefault();
                        SliderColorData scd = slider.isPresent() ? (SliderColorData)gson.fromJson((Reader)((class_3298)slider.get()).method_43039(), SliderColorData.class) : SliderColorData.getDefault();
                        TextSettings ts = textColor.isPresent() ? (TextSettings)gson.fromJson((Reader)((class_3298)textColor.get()).method_43039(), TextSettings.class) : TextSettings.getDefault();
                        return new ColorDataHolder(bcd, scd, ts);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return new ColorDataHolder(BackgroundColorData.getDefault(), SliderColorData.getDefault(), TextSettings.getDefault());
                    }
                }, executor);
            }

            public CompletableFuture<Void> apply(ColorDataHolder data, class_3300 manager, class_3695 profiler, Executor executor) {
                return CompletableFuture.runAsync(() -> {
                    ESOClient.colorData = data;
                }, executor);
            }
        });
    }
}

