/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.client.gui;

import aiefu.eso.client.gui.EnchantingTableScreen;
import aiefu.eso.data.RecipeHolder;
import aiefu.eso.data.itemdata.ItemDataPrepared;
import aiefu.eso.data.itemdata.RecipeViewerData;
import aiefu.eso.data.itemdata.RecipeViewerItemData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7528;

public class RecipeListWidget
extends class_7528 {
    protected RecipeHolder recipe;
    protected List<RecipeViewerData> data;
    protected int innerHeight = 0;
    protected EnchantingTableScreen screen;
    protected int tickCount = 0;

    public RecipeListWidget(int x, int y, int width, int height, class_2561 message, EnchantingTableScreen screen) {
        super(x, y, width, height, message);
        this.screen = screen;
    }

    protected int method_44391() {
        return this.innerHeight;
    }

    protected double method_44393() {
        return 20.0;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void method_44389(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int yOffset = this.method_46427() + 12;
        List<RecipeViewerData> list = this.data;
        for (RecipeViewerData d : list) {
            ItemDataPrepared[] itd = d.getItemData();
            if (itd.length < 1 && d.getXp() < 1) continue;
            int wOffset = this.method_46426() + 2;
            class_327 font = this.screen.getFont();
            guiGraphics.method_51439(font, d.getDesc(), wOffset + 2, yOffset - 9, 0x404040, false);
            if (itd.length > 0) {
                for (RecipeViewerItemData i : d.getCachedStacks()) {
                    class_1799 stack;
                    class_1799 class_17992 = stack = i.isAnimated() ? i.getNextStack() : i.getStack();
                    if (this.method_44388(mouseX, mouseY) && this.currentItemIsHovered(yOffset, wOffset, mouseX, mouseY)) {
                        this.setTooltipForNextPass(stack, font);
                    }
                    guiGraphics.method_51445(stack, wOffset, yOffset);
                    guiGraphics.method_51431(font, stack, wOffset, yOffset);
                    wOffset += 20;
                }
                guiGraphics.method_25302(EnchantingTableScreen.ENCHANTING_BACKGROUND_TEXTURE, wOffset, yOffset + 2, 210, 197, 16, 14);
                class_1799 resultStack = d.getResultStack();
                if (this.method_44388(mouseX, mouseY) && this.currentItemIsHovered(yOffset, wOffset += 20, mouseX, mouseY)) {
                    this.setTooltipForNextPass(resultStack, font);
                }
                guiGraphics.method_51445(resultStack, wOffset, yOffset);
                guiGraphics.method_51431(font, resultStack, wOffset, yOffset);
                yOffset += 20;
            }
            yOffset += 12;
        }
    }

    public void setTooltipForNextPass(class_1799 stack, class_327 font) {
        ArrayList fcsl = new ArrayList();
        for (class_2561 c : class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack)) {
            fcsl.addAll(font.method_1728((class_5348)c, 200));
        }
        this.screen.method_47414(fcsl);
    }

    protected void method_44386(class_332 guiGraphics) {
    }

    protected void method_44384(class_332 guiGraphics) {
        if (this.method_44392()) {
            this.renderScrollBar(guiGraphics);
        }
    }

    protected void renderScrollBar(class_332 guiGraphics) {
        int i = this.getScrollBarHeight();
        int minX = this.method_46426() + this.field_22758;
        int maxX = this.method_46426() + this.field_22758 + 8;
        int minY = Math.max(this.method_46427(), (int)this.method_44387() * (this.field_22759 - i) / this.method_44390() + this.method_46427());
        int maxY = minY + i;
        guiGraphics.method_25294(minX, minY, maxX, maxY, -345617);
        guiGraphics.method_25294(minX + 1, minY + 1, maxX - 1, maxY - 1, -4814674);
    }

    private int getScrollBarHeight() {
        return class_3532.method_15340((int)((int)((float)(this.field_22759 * this.field_22759) / (float)this.getContentHeight())), (int)32, (int)this.field_22759);
    }

    private int getContentHeight() {
        return this.method_44391() + 4;
    }

    public void tick() {
        if (this.tickCount % 60 == 0) {
            for (RecipeViewerData recipeViewerData : this.data) {
                for (RecipeViewerItemData d : recipeViewerData.getCachedStacks()) {
                    d.next();
                }
            }
        }
        ++this.tickCount;
    }

    protected boolean currentItemIsHovered(int yOffset, int wOffset, int mouseX, int mouseY) {
        int k = (int)((double)mouseY + this.method_44387());
        return mouseX > wOffset && mouseX < wOffset + 17 && k > yOffset && k < yOffset + 17;
    }

    public void updateRecipes(RecipeHolder holder, class_1887 enchantment) {
        Objects.requireNonNull(holder);
        this.recipe = holder;
        this.prepareData(enchantment);
        this.innerHeight = this.data.size() * 32;
        this.method_44382(0.0);
    }

    protected void prepareData(class_1887 enchantment) {
        int lvl;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (Int2ObjectMap.Entry set : this.recipe.levels.int2ObjectEntrySet()) {
            lvl = set.getIntKey();
            if (set.getValue() == null) continue;
            map.put(lvl, (Object)new RecipeViewerData((ItemDataPrepared[])set.getValue(), lvl, enchantment, this.recipe.mode));
        }
        for (Int2ObjectMap.Entry set : this.recipe.xpMap.int2IntEntrySet()) {
            lvl = set.getIntKey();
            RecipeViewerData data = (RecipeViewerData)map.get(lvl);
            if (data != null) {
                data.setXp(set.getIntValue());
                continue;
            }
            map.put(lvl, (Object)new RecipeViewerData(set.getIntValue(), lvl, enchantment, this.recipe.mode));
        }
        ArrayList keyset = new ArrayList(map.keySet());
        ArrayList<RecipeViewerData> sortedData = new ArrayList<RecipeViewerData>();
        Collections.sort(keyset);
        Iterator iterator = keyset.iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            sortedData.add((RecipeViewerData)map.get(k));
        }
        this.data = sortedData;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

