/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso.client.gui;

import aiefu.eso.ConfigurationFile;
import aiefu.eso.ESOCommon;
import aiefu.eso.Utils;
import aiefu.eso.client.ESOClient;
import aiefu.eso.client.gui.CustomEnchantingButton;
import aiefu.eso.client.gui.EnchButtonWithData;
import aiefu.eso.client.gui.EnchantmentListWidget;
import aiefu.eso.client.gui.RecipeListWidget;
import aiefu.eso.data.RecipeHolder;
import aiefu.eso.data.itemdata.ItemDataPrepared;
import aiefu.eso.data.materialoverrides.MaterialData;
import aiefu.eso.data.materialoverrides.MaterialOverrides;
import aiefu.eso.menu.OverhauledEnchantmentMenu;
import aiefu.eso.network.PacketIdentifiers;
import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import net.minecraft.class_7923;

public class EnchantingTableScreen
extends class_465<OverhauledEnchantmentMenu> {
    public static final class_2960 ENCHANTING_BACKGROUND_TEXTURE = new class_2960("enchanting-system-overhaul", "textures/gui/ench_screen.png");
    public static final class_2583 STYLE = class_2583.field_24360.method_27703(class_5251.method_27717((int)0x55FFFF));
    public static final List<class_5481> emptyMsg = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)"eso.enchantmentsempty"), 110);
    private static final Map<class_1887, Integer> EMPTY_MAP = Maps.newLinkedHashMap();
    protected static final DecimalFormat decimal_formatter = new DecimalFormat("#.##");
    protected EnchantmentListWidget enchantmentsScrollList;
    protected RecipeListWidget recipeViewer;
    protected class_342 searchFilter;
    protected CustomEnchantingButton confirmButton;
    protected CustomEnchantingButton cancelButton;
    protected class_1887 selectedEnchantment;
    protected int ordinal = -1;
    protected List<class_5481> confirmMsg = new ArrayList<class_5481>();
    protected class_5250 displayMsg;
    protected class_5250 searchHint;
    protected boolean overlayActive = false;
    protected boolean viewingRecipes = false;
    protected boolean seekRecipe = false;
    protected HashSet<EnchButtonWithData> tickingButtons = new HashSet();
    protected int ticks = 0;

    public EnchantingTableScreen(OverhauledEnchantmentMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.field_2779 = 181;
        this.field_2792 = 218;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_25426() {
        super.method_25426();
        this.confirmButton = (CustomEnchantingButton)this.method_25429((class_364)new CustomEnchantingButton(this.field_2776 + 60, this.field_2800 + 92, 30, 12, class_5244.field_24336, button -> {
            this.switchOverlayState(true);
            this.switchButtonsState(false);
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10814(Objects.requireNonNull(class_7923.field_41176.method_10221((Object)this.selectedEnchantment)).toString());
            buf.method_10804(this.ordinal);
            ClientPlayNetworking.send((class_2960)PacketIdentifiers.c2s_enchant_item, (class_2540)buf);
        }));
        this.cancelButton = (CustomEnchantingButton)this.method_25429((class_364)new CustomEnchantingButton(this.field_2776 + 130, this.field_2800 + 92, 30, 12, class_5244.field_24337, button -> {
            this.switchOverlayState(true);
            this.recalculateAvailability(((OverhauledEnchantmentMenu)this.field_2797).getTableInv());
        }));
        this.confirmButton.field_22763 = this.overlayActive;
        this.confirmButton.field_22764 = this.overlayActive;
        this.cancelButton.field_22763 = this.overlayActive;
        this.cancelButton.field_22764 = this.overlayActive;
        this.searchHint = class_2561.method_43471((String)"eso.search");
        this.searchFilter = (class_342)this.method_25429((class_364)new class_342(this.field_22793, this.field_2776 + 81, this.field_2800 + 9, 123, 10, (class_2561)this.searchHint));
        this.searchFilter.method_1858(false);
        List<EnchButtonWithData> list = this.craftEnchantmentsButtons(this.searchFilter.method_1882());
        this.enchantmentsScrollList = Objects.requireNonNull((EnchantmentListWidget)this.method_25429((class_364)new EnchantmentListWidget(this.field_2776 + 79, this.field_2800 + 24, 125, 48, (class_2561)class_2561.method_43470((String)""), list)));
        this.viewingRecipes = false;
        this.seekRecipe = false;
        this.recipeViewer = new RecipeListWidget(this.field_2776 + 79, this.field_2800 + 24, 125, 48, (class_2561)class_2561.method_43470((String)""), this);
        this.method_48265((class_364)this.enchantmentsScrollList);
        this.recalculateAvailability(((OverhauledEnchantmentMenu)this.field_2797).getTableInv());
        ((OverhauledEnchantmentMenu)this.field_2797).method_7596(new class_1712(){

            public void method_7635(class_1703 containerToSend, int dataSlotIndex, class_1799 stack) {
                if (dataSlotIndex == 41) {
                    EnchantingTableScreen.this.updateButtons();
                }
                if (dataSlotIndex > 40 && dataSlotIndex < 46) {
                    EnchantingTableScreen.this.recalculateAvailability(((OverhauledEnchantmentMenu)EnchantingTableScreen.this.field_2797).getTableInv());
                }
            }

            public void method_7633(class_1703 containerMenu, int dataSlotIndex, int value) {
            }
        });
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.switchOverlayState(!this.overlayActive);
    }

    public void switchOverlayState(boolean bl) {
        if (this.selectedEnchantment != null && !bl) {
            class_5250 msg = class_2561.method_43469((String)"eso.applyench.1", (Object[])new Object[]{class_2561.method_43471((String)this.selectedEnchantment.method_8184()).method_27696(STYLE), ((class_5250)((OverhauledEnchantmentMenu)this.field_2797).getTableInv().method_5438(0).method_7954()).method_27696(STYLE)});
            this.confirmMsg = this.field_22793.method_1728((class_5348)msg, 190);
        }
        this.searchFilter.field_22763 = bl;
        this.enchantmentsScrollList.field_22763 = bl;
        this.overlayActive = !bl;
        this.confirmButton.field_22763 = !bl;
        this.confirmButton.field_22764 = !bl;
        this.cancelButton.field_22763 = !bl;
        this.cancelButton.field_22764 = !bl;
    }

    public void switchButtonsState(boolean bl) {
        this.enchantmentsScrollList.switchOverlayState(bl);
    }

    protected void method_2383(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
        if (!this.overlayActive) {
            super.method_2383(slot, slotId, mouseButton, type);
        }
    }

    protected void method_37432() {
        super.method_37432();
        this.searchFilter.method_1865();
        if (this.ticks % 60 == 0) {
            Map enchs = class_1890.method_8222((class_1799)((OverhauledEnchantmentMenu)this.field_2797).getTableInv().method_5438(0));
            for (EnchButtonWithData b : this.tickingButtons) {
                if (!b.method_49606()) continue;
                class_1887 enchantment = b.getEnchantment();
                RecipeHolder holder = b.getRecipe();
                Integer l = (Integer)enchs.get(enchantment);
                int maxLevel = holder.getMaxLevel(enchantment);
                int targetLevel = l != null ? Math.min(maxLevel, l + 1) : 1;
                class_5250 translatable = RecipeHolder.getFullName(enchantment, targetLevel, maxLevel);
                this.composeTooltipAndApply(translatable, enchantment, holder, targetLevel, b, false);
            }
        }
        if (this.viewingRecipes) {
            this.recipeViewer.tick();
        }
        ++this.ticks;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        if (this.viewingRecipes) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            this.recipeViewer.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            guiGraphics.method_51448().method_22909();
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.searchFilter.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.overlayActive) {
            this.method_2380(guiGraphics, mouseX, mouseY);
        }
        if (!this.viewingRecipes) {
            this.enchantmentsScrollList.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.displayMsg != null) {
            int x = this.field_2776 + 79;
            this.drawCenteredString(guiGraphics, this.field_22793, (class_2561)this.displayMsg, x + 62, this.field_2800 + 75, ESOClient.colorData.getTextActiveColor(), ESOClient.colorData.isDropShadow());
        }
        if (this.searchFilter.method_1882().isEmpty() && !this.searchFilter.method_25370()) {
            guiGraphics.method_51439(this.field_22793, (class_2561)this.searchHint, this.field_2776 + 81, this.field_2800 + 9, ESOClient.colorData.getSearchBarHintColor(), ESOClient.colorData.isSearchBarHintDropShadow());
        }
        if (!class_310.method_1551().field_1724.method_31549().field_7477 && ((OverhauledEnchantmentMenu)this.field_2797).allEnchantments.isEmpty()) {
            int i = 0;
            int h = (48 - (8 * emptyMsg.size() + (emptyMsg.size() - 1) * 6)) / 2;
            for (class_5481 cs : emptyMsg) {
                this.drawCenteredString(guiGraphics, this.field_22793, cs, this.field_2776 + 79 + 62, this.field_2800 + 25 + h + 14 * i, ESOClient.colorData.getTextActiveColor(), ESOClient.colorData.isDropShadow());
                ++i;
            }
        }
        if (this.seekRecipe && !this.viewingRecipes) {
            this.seekRecipe = false;
            for (EnchButtonWithData e : this.enchantmentsScrollList.enchantments) {
                if (!e.method_49606()) continue;
                RecipeHolder holder = e.getRecipe();
                if (holder == null || holder.levels.isEmpty() && holder.xpMap.isEmpty()) break;
                this.recipeViewer.updateRecipes(holder, e.getEnchantment());
                this.recipeViewer.method_25365(true);
                this.viewingRecipes = true;
                break;
            }
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
        this.renderConfirmOverlay(guiGraphics, mouseX, mouseY, partialTick);
        this.confirmButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.cancelButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22909();
    }

    public void renderConfirmOverlay(class_332 graphics, int mx, int my, float pt) {
        if (this.overlayActive) {
            graphics.method_25302(ENCHANTING_BACKGROUND_TEXTURE, this.field_2776 + 10, this.field_2800 + 48, 0, 196, 200, 60);
            int h = (42 - (8 * this.confirmMsg.size() + (this.confirmMsg.size() - 1) * 6)) / 2;
            for (int i = 0; i < this.confirmMsg.size(); ++i) {
                this.drawCenteredString(graphics, this.field_22793, this.confirmMsg.get(i), this.field_2776 + 109, this.field_2800 + 50 + h + 14 * i, ESOClient.colorData.getTextActiveColor(), ESOClient.colorData.isDropShadow());
            }
        }
    }

    protected void drawCenteredString(class_332 graphics, class_327 font, class_2561 text, int x, int y, int color, boolean dropShadow) {
        graphics.method_51439(font, text, x - font.method_27525((class_5348)text) / 2, y, color, dropShadow);
    }

    protected void drawCenteredString(class_332 graphics, class_327 font, class_5481 text, int x, int y, int color, boolean dropShadow) {
        graphics.method_51430(font, text, x - font.method_30880(text) / 2, y, color, dropShadow);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_304 key = ESOClient.recipeKey;
        if (this.searchFilter.method_25370()) {
            if (keyCode == 256) {
                this.searchFilter.method_25365(false);
            } else if (keyCode == 257) {
                this.enchantmentsScrollList.setEnchantments(this.craftEnchantmentsButtons(this.searchFilter.method_1882()));
                this.recalculateAvailability(((OverhauledEnchantmentMenu)this.field_2797).getTableInv());
            }
            return this.searchFilter.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.viewingRecipes && (key.method_1417(keyCode, scanCode) || keyCode == 256)) {
            this.viewingRecipes = false;
            this.recipeViewer.method_25365(false);
            return true;
        }
        if (!this.overlayActive && !this.viewingRecipes && key.method_1417(keyCode, scanCode)) {
            this.seekRecipe = true;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.overlayActive) {
            return false;
        }
        if (this.viewingRecipes) {
            this.recipeViewer.method_25403(mouseX, mouseY, button, dragX, dragY);
        } else {
            this.enchantmentsScrollList.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.viewingRecipes) {
            this.recipeViewer.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.viewingRecipes) {
            this.recipeViewer.method_25401(mouseX, mouseY, delta);
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.viewingRecipes) {
            this.recipeViewer.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_25302(ENCHANTING_BACKGROUND_TEXTURE, i, j, 0, 0, this.field_2792, this.field_2779);
    }

    public List<EnchButtonWithData> craftEnchantmentsButtons(String filter) {
        Object2IntOpenHashMap<class_1887> applicableCurses;
        this.tickingButtons.clear();
        ArrayList<EnchButtonWithData> list = new ArrayList<EnchButtonWithData>();
        class_1799 stack = ((OverhauledEnchantmentMenu)this.field_2797).getTableInv().method_5438(0);
        boolean stackIsEmpty = stack.method_7960();
        boolean bl = stack.method_31574(class_1802.field_8529) || stack.method_31574(class_1802.field_8598);
        Map enchs = stackIsEmpty ? EMPTY_MAP : class_1890.method_8222((class_1799)stack);
        Object2IntOpenHashMap availableEnchantments = stackIsEmpty || bl ? ((OverhauledEnchantmentMenu)this.field_2797).enchantments : this.filterToNewSet(((OverhauledEnchantmentMenu)this.field_2797).enchantments, (class_1887 enchantment, Integer level) -> enchantment.method_8192(stack));
        Object2IntOpenHashMap<class_1887> curses = this.filterToNewSet(enchs, (class_1887 enchantment, Integer integer) -> enchantment.method_8195());
        MaterialData matData = this.getMatData(stack.method_7909());
        int currentEnchantmentsCount = this.getCurrentEnchantmentsCount(enchs.size(), curses.size());
        int enchantmentsLimit = this.getEnchantmentsLimit(curses.size(), matData);
        if (stackIsEmpty) {
            this.displayMsg = null;
        } else {
            int i = Math.max(enchantmentsLimit - currentEnchantmentsCount, 0);
            this.displayMsg = class_2561.method_43469((String)"eso.enchantmentsleft", (Object[])new Object[]{i});
        }
        ConfigurationFile cfg = ESOCommon.config;
        Object2IntOpenHashMap<class_1887> object2IntOpenHashMap = applicableCurses = bl ? ((OverhauledEnchantmentMenu)this.field_2797).curses : this.filterToNewSet(((OverhauledEnchantmentMenu)this.field_2797).curses, (class_1887 e, Integer l) -> e.method_8192(stack));
        if (currentEnchantmentsCount >= enchantmentsLimit) {
            availableEnchantments = new Object2IntOpenHashMap(enchs);
            if (cfg.enableCursesAmplifier) {
                if (curses.size() < matData.getMaxCurses()) {
                    availableEnchantments.putAll(applicableCurses);
                } else {
                    for (Object2IntMap.Entry c : curses.object2IntEntrySet()) {
                        availableEnchantments.put((Object)((class_1887)c.getKey()), c.getIntValue());
                    }
                }
            }
        } else if (cfg.enableCursesAmplifier && curses.size() < matData.getMaxCurses()) {
            availableEnchantments.putAll(applicableCurses);
        }
        TreeMap sortedMap = new TreeMap(Comparator.comparing(e -> class_1074.method_4662((String)e.method_8184(), (Object[])new Object[0])));
        sortedMap.putAll(availableEnchantments);
        int offset = 0;
        class_746 player = class_310.method_1551().field_1724;
        for (Map.Entry entry : sortedMap.entrySet()) {
            class_1887 enchantment2 = (class_1887)entry.getKey();
            int level2 = (Integer)entry.getValue();
            String name = class_1074.method_4662((String)enchantment2.method_8184(), (Object[])new Object[0]);
            if (!filter.isEmpty() && !filter.isBlank() && !name.toLowerCase().contains(filter.toLowerCase())) continue;
            List<RecipeHolder> holders = ESOCommon.getRecipeHolders(class_7923.field_41176.method_10221((Object)enchantment2));
            boolean hide = ESOCommon.config.hideEnchantmentsWithoutRecipe;
            if (holders != null) {
                int ordinal = 0;
                for (RecipeHolder holder : holders) {
                    int targetLevel;
                    Integer l2 = (Integer)enchs.get(enchantment2);
                    int maxLevel = holder.getMaxLevel(enchantment2);
                    int n = targetLevel = l2 != null ? Math.min(maxLevel, l2 + 1) : 1;
                    if (hide && !player.method_31549().field_7477 && !holder.levels.containsKey(targetLevel) && holder.xpMap.get(targetLevel) < 1) continue;
                    class_5250 translatable = RecipeHolder.getFullName(enchantment2, targetLevel, maxLevel);
                    EnchButtonWithData b = new EnchButtonWithData(this.field_2776 + 80, this.field_2800 + 25 + 16 * offset, 123, 14, (class_2561)translatable, button -> {
                        this.selectedEnchantment = enchantment2;
                        this.ordinal = ((EnchButtonWithData)button).getOrdinal();
                        this.switchOverlayState(false);
                        this.switchButtonsState(false);
                    }, holder, enchantment2, level2, ordinal);
                    this.composeTooltipAndApply(translatable, enchantment2, holder, targetLevel, b, true);
                    list.add(b);
                    ++offset;
                    ++ordinal;
                }
                continue;
            }
            if (!player.method_31549().field_7477 && hide) continue;
            Integer l3 = (Integer)enchs.get(enchantment2);
            int maxLevel = enchantment2.method_8183();
            int targetLevel = l3 != null ? Math.min(maxLevel, l3 + 1) : 1;
            class_5250 translatable = RecipeHolder.getFullName(enchantment2, targetLevel, maxLevel);
            EnchButtonWithData b = new EnchButtonWithData(this.field_2776 + 80, this.field_2800 + 25 + 16 * offset, 123, 14, (class_2561)translatable, button -> {
                this.selectedEnchantment = enchantment2;
                this.ordinal = -1;
                this.switchOverlayState(false);
                this.switchButtonsState(false);
            }, null, enchantment2, level2, -1);
            this.composeTooltipAndApply(translatable, enchantment2, null, targetLevel, b, true);
            list.add(b);
            ++offset;
        }
        return list;
    }

    public void composeTooltipAndApply(class_5250 translatable, class_1887 enchantment, RecipeHolder holder, int targetLevel, EnchButtonWithData button, boolean bl) {
        class_5250 c = translatable.method_27661();
        c.method_27692(class_124.field_1075);
        c.method_10852(class_5244.field_33849);
        c.method_10852((class_2561)ESOClient.getEnchantmentDescription(enchantment));
        if (ESOCommon.config.enableEnchantmentsLeveling && !class_310.method_1551().field_1724.method_31549().field_7477 && targetLevel > ((OverhauledEnchantmentMenu)this.field_2797).allEnchantments.getInt((Object)enchantment)) {
            c.method_10852(class_5244.field_33849);
            c.method_10852((class_2561)class_2561.method_43469((String)"eso.knowledgerequired", (Object[])new Object[]{enchantment.method_8179(targetLevel)}).method_27692(class_124.field_1079));
        }
        if (holder != null) {
            int cost;
            ItemDataPrepared[] d = (ItemDataPrepared[])holder.levels.get(targetLevel);
            if (d != null) {
                c.method_10852(class_5244.field_33849);
                c.method_10852((class_2561)class_2561.method_43471((String)"eso.requires").method_27692(class_124.field_1080));
                for (ItemDataPrepared data : (ItemDataPrepared[])holder.levels.get(targetLevel)) {
                    class_5250 itemName;
                    if (data.isEmpty()) {
                        itemName = class_2561.method_43471((String)"eso.emptyitem").method_27692(class_124.field_1063);
                    } else {
                        int amount;
                        class_1792 item;
                        class_2487 tag = null;
                        if (data.itemList != null) {
                            if (data.applicableItems.isEmpty()) continue;
                            if (bl) {
                                this.tickingButtons.add(button);
                                data.resetPos();
                            }
                            ItemDataPrepared ids = data.getNotNestedData();
                            item = ids.item;
                            tag = ids.compoundTag;
                            amount = ids.amount;
                            data.next();
                        } else if (data.tagKey != null) {
                            if (data.applicableItems.isEmpty()) continue;
                            if (bl) {
                                this.tickingButtons.add(button);
                                data.resetPos();
                            }
                            item = data.getApplicableItem();
                            amount = data.amount;
                            data.next();
                        } else {
                            item = data.item;
                            tag = data.compoundTag;
                            amount = data.amount;
                        }
                        if (tag != null) {
                            class_1799 refStack = new class_1799((class_1935)item, 1);
                            refStack.method_7980(tag);
                            itemName = class_2561.method_43471((String)refStack.method_7922());
                            if (item instanceof class_1812) {
                                String potion_id = tag.method_10558("Potion");
                                if (potion_id.contains("strong")) {
                                    itemName.method_10852((class_2561)class_2561.method_43471((String)"eso.potionstrong"));
                                } else if (potion_id.contains("long")) {
                                    itemName.method_10852((class_2561)class_2561.method_43471((String)"eso.potionlong"));
                                }
                            }
                        } else {
                            itemName = class_2561.method_43471((String)item.method_7876());
                        }
                        itemName.method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(amount)).method_27692(class_124.field_1075)).method_27692(class_124.field_1065);
                    }
                    c.method_10852(class_5244.field_33849);
                    c.method_10852((class_2561)itemName);
                }
            }
            if ((cost = holder.xpMap.get(targetLevel)) > 0) {
                class_5250 costMsg;
                class_746 player = class_310.method_1551().field_1724;
                if (holder.mode) {
                    int totalXP = Utils.getTotalAvailableXPPoints((class_1657)player);
                    costMsg = class_2561.method_43469((String)"eso.xprequirementpoints", (Object[])new Object[]{cost, decimal_formatter.format(Utils.getXPCostInLevels((class_1657)player, cost, totalXP))});
                    if (cost > totalXP) {
                        costMsg.method_27692(class_124.field_1079);
                    } else {
                        costMsg.method_27692(class_124.field_1077);
                    }
                } else {
                    costMsg = class_2561.method_43469((String)"eso.xprequirementlevels", (Object[])new Object[]{cost});
                    if (cost > player.field_7520) {
                        costMsg.method_27692(class_124.field_1079);
                    } else {
                        costMsg.method_27692(class_124.field_1077);
                    }
                }
                c.method_10852(class_5244.field_33849);
                c.method_10852((class_2561)costMsg);
            }
            if (!holder.levels.isEmpty() || !holder.xpMap.isEmpty()) {
                c.method_10852(class_5244.field_33849);
                c.method_10852((class_2561)class_2561.method_43469((String)"eso.tooltip.recipekey", (Object[])new Object[]{ESOClient.recipeKey.method_16007()}).method_27692(class_124.field_1063));
            }
        }
        button.method_47400(class_7919.method_47407((class_2561)c));
    }

    public Object2IntOpenHashMap<class_1887> filterToNewSet(Object2IntOpenHashMap<class_1887> map, BiPredicate<class_1887, Integer> predicate) {
        Object2IntOpenHashMap enchs = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry e : map.object2IntEntrySet()) {
            if (!predicate.test((class_1887)e.getKey(), e.getIntValue())) continue;
            enchs.put((Object)((class_1887)e.getKey()), e.getIntValue());
        }
        return enchs;
    }

    public Object2IntOpenHashMap<class_1887> filterToNewSet(Map<class_1887, Integer> map, BiPredicate<class_1887, Integer> predicate) {
        Object2IntOpenHashMap enchs = new Object2IntOpenHashMap();
        for (Map.Entry<class_1887, Integer> e : map.entrySet()) {
            if (!predicate.test(e.getKey(), e.getValue())) continue;
            enchs.put((Object)e.getKey(), e.getValue().intValue());
        }
        return enchs;
    }

    public class_342 getSearchFilter() {
        return this.searchFilter;
    }

    public int getEnchantmentsLimit(int curses, MaterialData data) {
        ConfigurationFile cfg = ESOCommon.config;
        return cfg.enableCursesAmplifier ? data.getMaxEnchantments() + Math.min(curses, data.getMaxCurses()) * data.getCurseMultiplier() : data.getMaxEnchantments();
    }

    public MaterialData getMatData(class_1792 item) {
        return ESOCommon.config.enableEnchantability ? ESOCommon.mat_config.getMaterialData(item) : MaterialOverrides.defaultMatData;
    }

    public int getCurrentEnchantmentsCount(int appliedEnchantments, int curses) {
        ConfigurationFile cfg = ESOCommon.config;
        return cfg.enableCursesAmplifier ? appliedEnchantments - curses : appliedEnchantments;
    }

    public void updateButtons() {
        this.enchantmentsScrollList.resetScrollAmount();
        this.enchantmentsScrollList.setEnchantments(this.craftEnchantmentsButtons(this.searchFilter.method_1882()));
    }

    public void recalculateAvailability(class_1277 container) {
        class_1799 stack = container.method_5438(0);
        class_746 player = class_310.method_1551().field_1724;
        if (!stack.method_7960() && (stack.method_31574(class_1802.field_8598) || stack.method_7909().method_7870(stack))) {
            Map enchs = class_1890.method_8222((class_1799)stack);
            block0: for (EnchButtonWithData b2 : this.enchantmentsScrollList.getEnchantments()) {
                RecipeHolder holder;
                Integer targetLevel = (Integer)enchs.get(b2.getEnchantment());
                targetLevel = targetLevel == null ? 1 : targetLevel + 1;
                if (ESOCommon.config.enableEnchantmentsLeveling && targetLevel > ((OverhauledEnchantmentMenu)this.field_2797).allEnchantments.getInt((Object)b2.getEnchantment())) {
                    b2.field_22763 = false;
                    continue;
                }
                if (!stack.method_31574(class_1802.field_8529) || !stack.method_31574(class_1802.field_8598)) {
                    for (class_1887 e : enchs.keySet()) {
                        if (e == b2.getEnchantment() || e.method_8188(b2.getEnchantment())) continue;
                        b2.field_22763 = false;
                        continue block0;
                    }
                }
                if ((holder = b2.getRecipe()) != null) {
                    b2.field_22763 = targetLevel <= holder.getMaxLevel(b2.getEnchantment()) && (player.method_31549().field_7477 || holder.check(container, targetLevel, (class_1657)player));
                    continue;
                }
                b2.field_22763 = player.method_31549().field_7477 && targetLevel <= b2.getEnchantment().method_8183();
            }
        } else {
            this.enchantmentsScrollList.enchantments.forEach(b -> {
                b.field_22763 = false;
            });
        }
    }

    public EnchantmentListWidget getEnchantmentsScrollList() {
        return this.enchantmentsScrollList;
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public static DecimalFormat getFormatter() {
        return decimal_formatter;
    }
}

