/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso;

import aiefu.eso.ConfigurationFile;
import aiefu.eso.ESOCommon;
import aiefu.eso.data.materialoverrides.MaterialData;
import aiefu.eso.data.materialoverrides.MaterialOverrides;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2487;

public class Utils {
    public static int getTotalAvailableXPPoints(class_1657 player) {
        int i = player.field_7520;
        int totalXP = 0;
        for (int j = 0; j < i; ++j) {
            totalXP += Utils.getXpNeededForLevel(j);
        }
        return (int)((float)totalXP + player.field_7510 * (float)player.method_7349());
    }

    public static float getXPCostInLevels(class_1657 player, int points) {
        return Utils.getXPCostInLevels(player, points, Utils.getTotalAvailableXPPoints(player));
    }

    public static float getXPCostInLevels(class_1657 player, int points, int totalXP) {
        int remainingPoints = points;
        int level = player.field_7520;
        float result = 0.0f;
        if (totalXP == points) {
            return (float)player.field_7520 + player.field_7510;
        }
        if (totalXP > points) {
            while (remainingPoints > 0) {
                int xp = Utils.getXpNeededForLevel(level);
                result = remainingPoints >= xp ? (result += 1.0f) : (result += (float)remainingPoints / (float)xp);
                remainingPoints -= xp;
                --level;
            }
        } else {
            level = 0;
            while (remainingPoints > 0) {
                int xp = Utils.getXpNeededForLevel(level);
                result = remainingPoints >= xp ? (result += 1.0f) : (result += (float)remainingPoints / (float)xp);
                remainingPoints -= xp;
                ++level;
            }
        }
        return result;
    }

    public static int getXpNeededForLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getEnchantmentsLimit(int curses, MaterialData data) {
        ConfigurationFile cfg = ESOCommon.config;
        return cfg.enableCursesAmplifier ? data.getMaxEnchantments() + Math.min(curses, data.getMaxCurses()) * data.getCurseMultiplier() : data.getMaxEnchantments();
    }

    public static MaterialData getMatData(class_1792 item) {
        return ESOCommon.config.enableEnchantability ? ESOCommon.mat_config.getMaterialData(item) : MaterialOverrides.defaultMatData;
    }

    public static int getCurrentLimit(int appliedEnchantments, int curses) {
        ConfigurationFile cfg = ESOCommon.config;
        return cfg.enableCursesAmplifier ? appliedEnchantments - curses : appliedEnchantments;
    }

    public static boolean containsEnchantments(class_1799 stack) {
        if (stack.method_7985()) {
            class_2487 tag = stack.method_7969();
            if (tag.method_10573("Enchantments", 9)) {
                return !tag.method_10554("Enchantments", 10).isEmpty();
            }
            if (tag.method_10573("StoredEnchantments", 9)) {
                return !tag.method_10554("StoredEnchantments", 10).isEmpty();
            }
            return false;
        }
        return false;
    }

    public static boolean containsSameEnchantments(Map<class_1887, Integer> m1, Map<class_1887, Integer> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        int matches = 0;
        for (class_1887 e : m1.keySet()) {
            if (!m2.containsKey(e)) continue;
            ++matches;
        }
        return matches == m2.size();
    }

    public static boolean containsSameEnchantmentsOfSameLevel(Map<class_1887, Integer> m1, Map<class_1887, Integer> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        int matches = 0;
        for (Map.Entry<class_1887, Integer> e : m1.entrySet()) {
            Integer lvl = m2.get(e.getKey());
            if (lvl == null || lvl.intValue() != e.getValue().intValue()) continue;
            ++matches;
        }
        return matches == m2.size();
    }

    public static LinkedHashMap<class_1887, Integer> filterToNewMap(Map<class_1887, Integer> map, BiPredicate<class_1887, Integer> predicate) {
        LinkedHashMap<class_1887, Integer> enchs = new LinkedHashMap<class_1887, Integer>();
        for (Map.Entry<class_1887, Integer> e : map.entrySet()) {
            if (!predicate.test(e.getKey(), e.getValue())) continue;
            enchs.put(e.getKey(), e.getValue());
        }
        return enchs;
    }
}

