/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso;

import aiefu.eso.ConfigurationFile;
import aiefu.eso.ESOCommands;
import aiefu.eso.IServerPlayerAcc;
import aiefu.eso.data.EnchantmentRecipesLoader;
import aiefu.eso.data.MaterialDataLoader;
import aiefu.eso.data.RecipeHolder;
import aiefu.eso.data.itemdata.ItemData;
import aiefu.eso.data.materialoverrides.MaterialOverrides;
import aiefu.eso.menu.OverhauledEnchantmentMenu;
import aiefu.eso.network.ServersideNetworkManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1887;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESOCommon
implements ModInitializer {
    public static final String MOD_ID = "enchanting-system-overhaul";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"enchanting-system-overhaul");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static ConfigurationFile config;
    public static MaterialOverrides mat_config;
    public static final class_2960 defaultRecipe;
    public static ConcurrentHashMap<class_2960, List<RecipeHolder>> recipeMap;
    public static final ExtendedScreenHandlerType<OverhauledEnchantmentMenu> enchantment_menu_ovr;

    public void onInitialize() {
        EnchantmentRecipesLoader.registerReloadListener();
        MaterialDataLoader.registerReloadListener(ESOCommon.getGson());
        ServersideNetworkManager.registerReceivers();
        try {
            this.genConfig();
            ESOCommon.readConfig();
            this.genDefaultRecipe();
            MaterialOverrides.generateDefault();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> server.execute(() -> {
            recipeMap.values().forEach(l -> l.forEach(RecipeHolder::processTags));
            server.method_3760().method_14571().forEach(player -> {
                if (!server.method_19466(player.method_7334())) {
                    ServersideNetworkManager.syncData(player);
                    ServersideNetworkManager.syncMatConfig(player);
                }
            });
        }));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> server.execute(() -> recipeMap.values().forEach(l -> l.forEach(RecipeHolder::processTags))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ESOCommands.register((CommandDispatcher<class_2168>)dispatcher));
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            IServerPlayerAcc old = (IServerPlayerAcc)oldPlayer;
            IServerPlayerAcc np = (IServerPlayerAcc)newPlayer;
            np.enchantment_overhaul$setUnlockedEnchantments(old.enchantment_overhaul$getUnlockedEnchantments());
        });
        LOGGER.info("ESO Initialized");
    }

    public void genConfig() throws IOException {
        String p2;
        Path p = Paths.get("./config/eso", new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        if (!Files.exists(Paths.get(p2 = "./config/eso/config.json", new String[0]), new LinkOption[0])) {
            try (FileWriter writer = new FileWriter(p2);){
                gson.toJson((Object)ConfigurationFile.getDefault(), (Appendable)writer);
            }
        }
    }

    public static void readConfig() throws IOException {
        JsonObject jsonObject = JsonParser.parseReader((Reader)new FileReader("./config/eso/config.json")).getAsJsonObject();
        boolean shouldSave = false;
        if (!jsonObject.has("enableEnchantability")) {
            jsonObject.addProperty("enableEnchantability", Boolean.valueOf(true));
            shouldSave = true;
        }
        if (!jsonObject.has("enableDefaultRecipe")) {
            jsonObject.addProperty("enableDefaultRecipe", Boolean.valueOf(true));
            shouldSave = true;
        }
        if (!jsonObject.has("disableDiscoverySystem")) {
            jsonObject.addProperty("disableDiscoverySystem", Boolean.valueOf(false));
            shouldSave = true;
        }
        if (!jsonObject.has("enableEnchantmentsLeveling")) {
            jsonObject.addProperty("enableEnchantmentsLeveling", Boolean.valueOf(false));
            shouldSave = true;
        }
        if (!jsonObject.has("hideEnchantmentsWithoutRecipe")) {
            jsonObject.addProperty("hideEnchantmentsWithoutRecipe", Boolean.valueOf(false));
            shouldSave = true;
        }
        if (!jsonObject.has("disableAnvilEnchanting")) {
            jsonObject.addProperty("disableAnvilEnchanting", Boolean.valueOf(false));
            shouldSave = true;
        }
        if (!jsonObject.has("disableBookCombining")) {
            jsonObject.addProperty("disableBookCombining", Boolean.valueOf(false));
            shouldSave = true;
        }
        config = (ConfigurationFile)gson.fromJson((JsonElement)jsonObject, ConfigurationFile.class);
        if (shouldSave) {
            try (FileWriter writer = new FileWriter("./config/eso/config.json");){
                gson.toJson((Object)config, (Appendable)writer);
            }
        }
    }

    public void genDefaultRecipe() throws IOException {
        String p2;
        FileWriter writer;
        String p = "./config/eso/default-recipe.json";
        if (!Files.exists(Paths.get(p, new String[0]), new LinkOption[0])) {
            ItemData[] dataArr;
            int i;
            LinkedHashMap<Integer, ItemData[]> levels = new LinkedHashMap<Integer, ItemData[]>();
            int level = 1;
            for (i = 0; i < 3; ++i) {
                dataArr = new ItemData[]{new ItemData("minecraft:lapis_lazuli", 12), new ItemData("minecraft:amethyst_shard", 3), new ItemData("minecraft:gold_ingot", 6), new ItemData("minecraft:diamond", 3)};
                levels.put(level, dataArr);
                ++level;
            }
            for (i = 0; i < 4; ++i) {
                dataArr = new ItemData[]{new ItemData("minecraft:lapis_lazuli", 32), new ItemData("minecraft:amethyst_shard", 7), new ItemData("minecraft:gold_ingot", 24), new ItemData("minecraft:diamond", 7)};
                levels.put(level, dataArr);
                ++level;
            }
            for (i = 0; i < 3; ++i) {
                dataArr = new ItemData[]{new ItemData("minecraft:lapis_lazuli", 48), new ItemData("minecraft:amethyst_shard", 16), new ItemData("minecraft:gold_ingot", 32), new ItemData("minecraft:diamond", 16)};
                levels.put(level, dataArr);
                ++level;
            }
            writer = new FileWriter(p);
            try {
                gson.toJson(levels, (Appendable)writer);
            }
            finally {
                writer.close();
            }
        }
        if (!Files.exists(Paths.get(p2 = "./config/eso/default-xp-map.json", new String[0]), new LinkOption[0])) {
            JsonObject tree = new JsonObject();
            tree.addProperty("useExpPoints", Boolean.valueOf(false));
            tree.add("xp", gson.toJsonTree((Object)new Int2IntOpenHashMap()));
            writer = new FileWriter(p2);
            try {
                gson.toJson((JsonElement)tree, (Appendable)writer);
            }
            finally {
                writer.close();
            }
        }
    }

    @Nullable
    public static List<RecipeHolder> getRecipeHolders(class_2960 location) {
        List<RecipeHolder> holders = recipeMap.get(location);
        return holders != null ? holders : (ESOCommon.config.enableDefaultRecipe ? recipeMap.get(defaultRecipe) : null);
    }

    public static int getMaximumPossibleEnchantmentLevel(class_1887 enchantment) {
        class_2960 location = class_7923.field_41176.method_10221((Object)enchantment);
        List<RecipeHolder> holders = recipeMap.get(location);
        int maxLevel = 0;
        if (holders != null && !holders.isEmpty()) {
            for (RecipeHolder holder : holders) {
                int l = holder.getMaxLevel(enchantment);
                if (l <= maxLevel) continue;
                maxLevel = l;
            }
        } else {
            maxLevel = enchantment.method_8183();
        }
        return maxLevel;
    }

    public static Gson getGson() {
        return gson;
    }

    static {
        defaultRecipe = new class_2960("default");
        recipeMap = new ConcurrentHashMap();
        enchantment_menu_ovr = (ExtendedScreenHandlerType)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new class_2960(MOD_ID, "enchs_menu_ovr"), (Object)new ExtendedScreenHandlerType(OverhauledEnchantmentMenu::new));
    }
}

