/*
 * Decompiled with CFR 0.152.
 */
package aiefu.eso;

import aiefu.eso.ESOCommon;
import aiefu.eso.IServerPlayerAcc;
import aiefu.eso.network.PacketIdentifiers;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class ESOCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eso").requires(stack -> stack.method_9259(4))).then(class_2170.method_9247((String)"learn").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"enchantment-id", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ESOCommands.learnEnchantmentById((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"enchantment-id")))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eso").requires(stack -> stack.method_9259(4))).then(class_2170.method_9247((String)"forget").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"enchantment-id", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ESOCommands.forgetEnchantment((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"enchantment-id")))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eso").requires(stack -> stack.method_9259(4))).then(class_2170.method_9247((String)"get-mat-id-in-hand").executes(ESOCommands::getMaterialId)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eso").requires(stack -> stack.method_9259(4))).then(class_2170.method_9247((String)"get-item-id-in-hand").executes(ESOCommands::getItemId)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eso").requires(stack -> stack.method_9259(4))).then(class_2170.method_9247((String)"get-enchantment-id-in-hand").executes(ESOCommands::getEnchantmentId)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"eso").requires(stack -> stack.method_9259(4))).then(class_2170.method_9247((String)"learn-leveled").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"enchantment-id", (ArgumentType)StringArgumentType.greedyString()).then(class_2170.method_9244((String)"operation", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> ESOCommands.setLeveledEnchantment((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"enchantment-id"), StringArgumentType.getString((CommandContext)context, (String)"operation"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))))));
    }

    public static int setLeveledEnchantment(CommandContext<class_2168> ctx, class_3222 targetPlayer, String enchantmentId, String operation, int level) {
        class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(new class_2960(enchantmentId));
        if (enchantment != null) {
            class_5250 c = class_2561.method_43471((String)enchantment.method_8184());
            Object2IntOpenHashMap<class_1887> learnedEnchantments = ((IServerPlayerAcc)targetPlayer).enchantment_overhaul$getUnlockedEnchantments();
            int maxLevel = ESOCommon.getMaximumPossibleEnchantmentLevel(enchantment);
            int i = learnedEnchantments.getInt((Object)enchantment);
            switch (operation) {
                case "add": {
                    int r = Math.min(maxLevel, i + level);
                    learnedEnchantments.put((Object)enchantment, r);
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.successfullyadded", (Object[])new Object[]{c, r, targetPlayer.method_5476()}), true);
                    targetPlayer.method_43502((class_2561)class_2561.method_43469((String)"eso.youlearned", (Object[])new Object[]{ESOCommands.getFormattedNameLeveled(enchantment, r)}).method_27692(class_124.field_1065), true);
                    break;
                }
                case "set": {
                    int r = Math.min(level, maxLevel);
                    if (r == i) {
                        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"eso.command.feedback.playerknows", (Object[])new Object[]{targetPlayer.method_5476(), c}));
                        break;
                    }
                    learnedEnchantments.put((Object)enchantment, Math.min(level, maxLevel));
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.successfullyadded", (Object[])new Object[]{c, r, targetPlayer.method_5476()}), true);
                    targetPlayer.method_43502((class_2561)class_2561.method_43469((String)"eso.youlearned", (Object[])new Object[]{ESOCommands.getFormattedNameLeveled(enchantment, r)}).method_27692(class_124.field_1065), true);
                    break;
                }
                case "sub": 
                case "subtract": {
                    int r = i - level;
                    if (r < 1) {
                        learnedEnchantments.removeInt((Object)enchantment);
                        targetPlayer.method_43502((class_2561)class_2561.method_43469((String)"eso.youforgot", (Object[])new Object[]{c}), true);
                        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.removedEnchantment", (Object[])new Object[]{c, targetPlayer.method_5476()}), true);
                        break;
                    }
                    learnedEnchantments.put((Object)enchantment, r);
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.successfullyadded", (Object[])new Object[]{c, r, targetPlayer.method_5476()}), true);
                    targetPlayer.method_43502((class_2561)class_2561.method_43469((String)"eso.youlearned", (Object[])new Object[]{ESOCommands.getFormattedNameLeveled(enchantment, r)}).method_27692(class_124.field_1065), true);
                    break;
                }
                default: {
                    ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"eso.command.feedback.invalidoperation"));
                }
            }
        } else {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"eso.command.encantmentnotfound", (Object[])new Object[]{enchantmentId}));
        }
        return 0;
    }

    public static class_5250 getFormattedNameLeveled(class_1887 e, int l) {
        class_5250 msg = class_2561.method_43470((String)"[").method_27692(class_124.field_1064);
        msg.method_10852(e.method_8179(l));
        msg.method_10852((class_2561)class_2561.method_43470((String)"]"));
        return msg;
    }

    public static int getMaterialId(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String mat;
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_1792 item = player.method_5998(class_1268.field_5808).method_7909();
        if (item instanceof class_1831) {
            class_1831 ti = (class_1831)item;
            class_1832 t = ti.method_8022();
            if (t instanceof Enum) {
                Enum e = (Enum)t;
                mat = e.name();
            } else {
                mat = t.getClass().getSimpleName();
            }
        } else if (item instanceof class_1738) {
            class_1738 ai = (class_1738)item;
            mat = ai.method_7686().method_7694();
        } else {
            mat = "null";
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)mat), true);
        ESOCommands.copyToClipboard(player, mat);
        return 0;
    }

    public static int getItemId(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_1792 item = player.method_5998(class_1268.field_5808).method_7909();
        class_2960 loc = class_7923.field_41178.method_10221((Object)item);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)loc.toString()), true);
        ESOCommands.copyToClipboard(player, loc.toString());
        return 0;
    }

    public static int getEnchantmentId(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        class_1799 stack = player.method_5998(class_1268.field_5808);
        if (stack.method_7942() || ESOCommands.containsStoredEnchantments(stack)) {
            Map enchs = class_1890.method_8222((class_1799)stack);
            StringBuilder enchantments = new StringBuilder();
            for (Map.Entry e : enchs.entrySet()) {
                class_2960 loc = class_7923.field_41176.method_10221((Object)((class_1887)e.getKey()));
                if (loc == null) continue;
                String s = loc.toString();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)s), true);
                enchantments.append(s).append(" ");
            }
            String s = enchantments.toString();
            ESOCommands.copyToClipboard(player, s.substring(0, s.length() - 1));
        }
        return 0;
    }

    public static boolean containsStoredEnchantments(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        return tag.method_10573("StoredEnchantments", 9);
    }

    public static void copyToClipboard(class_3222 player, String s) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(s);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PacketIdentifiers.s2c_string_to_clipboard, (class_2540)buf);
    }

    public static int forgetEnchantment(CommandContext<class_2168> ctx, class_3222 player, String id) {
        if (id.equalsIgnoreCase("all")) {
            ESOCommands.revokeAll(ctx, player);
        } else {
            class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(new class_2960(id));
            if (enchantment != null && player instanceof IServerPlayerAcc) {
                IServerPlayerAcc acc = (IServerPlayerAcc)player;
                class_5250 discId = class_2561.method_43471((String)enchantment.method_8184());
                class_5250 c = class_2561.method_43470((String)"[").method_27692(class_124.field_1064);
                c.method_10852((class_2561)discId);
                c.method_10852((class_2561)class_2561.method_43470((String)"]"));
                if (acc.enchantment_overhaul$getUnlockedEnchantments().removeInt((Object)enchantment) != 0) {
                    player.method_43502((class_2561)class_2561.method_43469((String)"eso.youforgot", (Object[])new Object[]{c}), true);
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.removedEnchantment", (Object[])new Object[]{discId, player.method_5476()}), true);
                } else {
                    ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"eso.command.feedback.doesnotknow", (Object[])new Object[]{player.method_5476(), discId}));
                }
            } else {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"eso.command.encantmentnotfound", (Object[])new Object[]{id}));
            }
        }
        return 0;
    }

    public static int learnEnchantmentById(CommandContext<class_2168> ctx, class_3222 player, String id) {
        if (id.equalsIgnoreCase("all")) {
            ESOCommands.grantAll(ctx, player);
        } else {
            class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(new class_2960(id));
            if (enchantment != null && player instanceof IServerPlayerAcc) {
                IServerPlayerAcc acc = (IServerPlayerAcc)player;
                class_5250 discId = class_2561.method_43471((String)enchantment.method_8184());
                class_5250 c = class_2561.method_43470((String)"[").method_27692(class_124.field_1064);
                c.method_10852((class_2561)discId);
                c.method_10852((class_2561)class_2561.method_43470((String)"]"));
                if (acc.enchantment_overhaul$getUnlockedEnchantments().put((Object)enchantment, ESOCommon.getMaximumPossibleEnchantmentLevel(enchantment)) < 1) {
                    player.method_43502((class_2561)class_2561.method_43469((String)"eso.youlearned", (Object[])new Object[]{c}).method_27692(class_124.field_1065), true);
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.addedEnchantment", (Object[])new Object[]{discId, player.method_5476()}).method_27692(class_124.field_1065), true);
                } else {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.playerknows", (Object[])new Object[]{player.method_5476(), discId}).method_27692(class_124.field_1077), true);
                }
            } else {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"eso.command.encantmentnotfound", (Object[])new Object[]{id}));
            }
        }
        return 0;
    }

    public static void grantAll(CommandContext<class_2168> ctx, class_3222 player) {
        if (player instanceof IServerPlayerAcc) {
            IServerPlayerAcc acc = (IServerPlayerAcc)player;
            Object2IntOpenHashMap<class_1887> enchantments = acc.enchantment_overhaul$getUnlockedEnchantments();
            for (class_1887 e : class_7923.field_41176) {
                enchantments.put((Object)e, ESOCommon.getMaximumPossibleEnchantmentLevel(e));
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.grantall", (Object[])new Object[]{player.method_5476()}), true);
            player.method_43496((class_2561)class_2561.method_43471((String)"eso.command.allknowledge").method_27692(class_124.field_1065));
        }
    }

    public static void revokeAll(CommandContext<class_2168> ctx, class_3222 player) {
        if (player instanceof IServerPlayerAcc) {
            IServerPlayerAcc acc = (IServerPlayerAcc)player;
            acc.enchantment_overhaul$getUnlockedEnchantments().clear();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"eso.command.feedback.revokeall", (Object[])new Object[]{player.method_5476()}), true);
            player.method_43496((class_2561)class_2561.method_43471((String)"eso.command.lostallknowledge").method_27692(class_124.field_1065));
        }
    }
}

