/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1271;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.MissingHandlerCallback;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.misc.LocationManager;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.modintegration.handlers.TypeFluid;

public class EnderContainer
implements IEnderTankInfo {
    private final HashMap<String, ITankHandler<?>> handlers = new HashMap();
    private final HashMap<String, class_2487> missing_handlers = new HashMap();
    private final String owner;
    private final String code;
    private int capacity;

    public EnderContainer(String owner, String code) {
        this.capacity = EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.tank_size_min;
        this.owner = owner;
        this.code = code;
    }

    public EnderContainer load(class_2487 nbtTank) {
        if (nbtTank.method_10573("Capacity", 2)) {
            this.capacity = class_3532.method_15340((int)nbtTank.method_10568("Capacity"), (int)EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.tank_size_min, (int)EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.tank_size_max);
        }
        block4: for (String key : nbtTank.method_10541()) {
            if (nbtTank.method_10540(key) != 10) continue;
            class_2487 nbtData = nbtTank.method_10562(key);
            ITankHandler<?> handler = HandlerRegistry.createHandlerFor(key, (IEnderTankInfo)this);
            if (handler != null) {
                handler.setCapacity(this.capacity);
                handler.load(nbtData);
                this.handlers.put(key, handler);
                continue;
            }
            class_1271<String> result = ((MissingHandlerCallback)MissingHandlerCallback.EVENT.invoker()).getProviderKey(key, nbtData, HandlerRegistry.getProviders());
            switch (result.method_5467()) {
                case field_5814: {
                    continue block4;
                }
                case field_5812: {
                    handler = HandlerRegistry.createHandlerFor((String)result.method_5466(), (IEnderTankInfo)this);
                    if (handler == null) break;
                    handler.setCapacity(this.capacity);
                    handler.load(nbtData);
                    this.handlers.put(key, handler);
                    continue block4;
                }
            }
            this.missing_handlers.put(key, nbtData);
        }
        return this;
    }

    public class_2487 save() {
        class_2487 nbtHandler;
        class_2487 nbtTank = new class_2487();
        if (this.capacity > EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.tank_size_min) {
            nbtTank.method_10575("Capacity", (short)this.capacity);
        }
        for (Map.Entry<String, ITankHandler<?>> entry : this.handlers.entrySet()) {
            nbtHandler = entry.getValue().save();
            if (nbtHandler == null || nbtHandler.method_33133()) continue;
            nbtTank.method_10566(entry.getKey(), (class_2520)nbtHandler);
        }
        for (Map.Entry<String, ITankHandler<?>> entry : this.missing_handlers.entrySet()) {
            nbtHandler = (class_2487)entry.getValue();
            if (nbtHandler == null || nbtHandler.method_33133()) continue;
            nbtTank.method_10566(entry.getKey(), (class_2520)nbtHandler);
        }
        return nbtTank;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        for (ITankHandler<?> handler : this.handlers.values()) {
            handler.setCapacity(capacity);
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void notifyContentsChange() {
        TankHelper.needsSaving = true;
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    public ITankHandler<?> getOrCreateHandler(String key) {
        if (this.handlers.containsKey(key)) {
            return this.handlers.get(key);
        }
        ITankHandler<?> handler = HandlerRegistry.createHandlerFor(key, (IEnderTankInfo)this);
        if (handler != null) {
            this.handlers.put(key, handler);
        }
        return handler;
    }

    public <T extends TransferVariant<?>> Optional<Storage<T>> getTankFor(Class<T> type, StorageAccessMode access) {
        ITankHandler<?> handler = this.getOrCreateHandler(HandlerRegistry.getKey(type));
        if (handler != null) {
            return Optional.of(handler.getTank(access));
        }
        return Optional.empty();
    }

    public <T extends TransferVariant<?>> Optional<Storage<T>> getTankFor(Class<T> type) {
        return this.getTankFor(type, StorageAccessMode.FULL);
    }

    @Override
    public List<class_5250> getContentsInfo(boolean bucket) {
        ArrayList<class_5250> info = new ArrayList<class_5250>();
        for (ITankHandler<?> handler : this.handlers.values()) {
            class_5250 entry;
            if (bucket && !(handler instanceof TypeFluid.FluidTankHandler) || (entry = handler.getContentsInfo()) == null) continue;
            info.add(entry);
        }
        if (info.isEmpty()) {
            info.add(class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"info.endertanks.tank.empty")).method_27693(String.format(" [0/%dK mB]", this.capacity)));
        }
        return info;
    }

    public int getComparatorOutput(String key) {
        ITankHandler<?> handler = this.handlers.get(key);
        if (handler != null) {
            return handler.getComparatorOutput();
        }
        return 0;
    }

    public class_2561 getDisplayName(String key) {
        ITankHandler<?> handler = this.getOrCreateHandler(key);
        if (handler != null) {
            return handler.getDisplayName();
        }
        return class_2561.method_43470((String)"nil");
    }
}

