/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.EnderChestsClient;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ItemEnderBag
extends class_1792
implements ITabFiller,
IColored {
    public ItemEnderBag(class_1792.class_1793 settings) {
        super(settings);
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            EnderChestsClient.colorize(this);
            EnderChestsClient.addItemPredicate(this, "type", (stack, world, entity, number) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f));
            EnderChestsClient.addItemPredicate(this, "open", (stack, world, entity, number) -> ItemEnderBag.isOpen(stack) ? 1.0f : 0.0f);
        });
    }

    public void fillCreativeTab(class_1761.class_7704 entries, class_1761.class_8128 context) {
        for (String code : StackHelper.BASE_CODES) {
            entries.method_45420(StackHelper.create(this, code, null));
        }
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        if (!EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.public_bags && StackHelper.isPublic(stack)) {
            if (!EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.personal_bags) {
                String teamID = Function.getPlayerTeamID((class_1657)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                StackHelper.setOwner(stack, player.method_5667().toString());
            }
        }
        ItemEnderBag.setOpenState(stack, false);
    }

    public static boolean isOpen(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545("open")) {
            return tag.method_10577("open");
        }
        ItemEnderBag.setOpenState(stack, false);
        return false;
    }

    private static void setOpenState(class_1799 stack, boolean isOpen) {
        class_2487 tag = stack.method_7948();
        tag.method_10556("open", isOpen);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.method_8608()) {
            class_2586 tile;
            class_2338 pos;
            boolean isSneaking = player.method_5715();
            class_3965 mop = ItemEnderBag.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348);
            class_2338 class_23382 = pos = mop != null ? mop.method_17777() : null;
            if (isSneaking && pos != null && world.method_8320(pos).method_26204() == Roster.Blocks.ENDERCHEST && (tile = world.method_8321(pos)) instanceof TileEntityEnderChest) {
                TileEntityEnderChest chestTile = (TileEntityEnderChest)tile;
                if (chestTile.hasError()) {
                    ChestInfoHelper.sendLinkError(player, 2);
                } else {
                    if (chestTile.canLink(player)) {
                        if (EnderChests.CONFIG.COMMON.full_stack_linking) {
                            StackHelper.setLink(stack, chestTile.getCode(), chestTile.getOwnerID());
                        } else {
                            Function.giveItem((class_1657)player, (class_1799)StackHelper.setLink(stack.method_7971(1), chestTile.getCode(), chestTile.getOwnerID()));
                        }
                        return class_1271.method_22427((Object)stack);
                    }
                    ChestInfoHelper.sendLinkError(player, chestTile.isTeam() ? 3 : 1);
                }
            }
            if (!StackHelper.isPublic(stack) || EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.public_bags) {
                String ownerID = StackHelper.getOwnerID(stack);
                String code = StackHelper.getCode(stack);
                if (Strings.isNullOrEmpty((String)ownerID) || Strings.isNullOrEmpty((String)code)) {
                    ChestInfoHelper.sendError(player, "enderchests.bag.corrupted");
                } else {
                    player.method_17355((class_3908)new ContainerProviders.EnderBag(ownerID, code, StackHelper.getOwnerName(stack)));
                    ItemEnderBag.setOpenState(stack, true);
                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14883, player.method_5634(), 1.0f, 1.0f);
                }
            } else {
                ChestInfoHelper.sendError(player, "enderchests.bag.public.disabled");
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int itemSlot, boolean isSelected) {
        super.method_7888(stack, world, entity, itemSlot, isSelected);
        if (ItemEnderBag.isOpen(stack)) {
            if (isSelected && entity instanceof class_1657 && ((class_1657)entity).field_7512 instanceof ContainerEnderChest) {
                return;
            }
            ItemEnderBag.setOpenState(stack, false);
        }
    }

    public String method_7866(class_1799 stack) {
        return "item.enderchests.bag." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"info.enderchests.chest.code")).method_10852((class_2561)class_2561.method_43470((String)(" " + StackHelper.getCode(stack)))));
        class_2561 owner = ChestInfoHelper.formatChestOwner(StackHelper.getOwnerName(stack));
        if (owner != null) {
            tooltip.add(owner);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.method_7960()) {
            int value = class_3532.method_15340((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }
}

