/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.inventory;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3915;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.common.inventory.Slots;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ContainerEnderChest
extends class_1703 {
    private TileEntityEnderChest chestTile;
    private InventoryInternal chest;
    private class_2561 owner;
    private final class_3915 size = class_3915.method_17403();
    private Runnable callbackInventoryChange;

    public ContainerEnderChest(int id, class_1661 invPlayer, TileEntityEnderChest tile) {
        super(Roster.Containers.ENDER_CHEST, id);
        this.callbackInventoryChange = () -> {};
        this.common_setup(invPlayer, tile.getChest(), tile.getOwnerName());
        this.chestTile = tile;
        this.chestTile.onContainerOpen((class_2586)this.chestTile, (class_1263)this.chest, invPlayer.field_7546);
    }

    public ContainerEnderChest(int id, class_1661 invPlayer, InventoryInternal chest, String owner) {
        super(Roster.Containers.ENDER_BAG, id);
        this.callbackInventoryChange = () -> {};
        this.common_setup(invPlayer, chest, owner);
    }

    private void common_setup(class_1661 invPlayer, InventoryInternal chest, String owner) {
        int slotId;
        this.chest = chest;
        this.owner = ChestInfoHelper.infoChestOwner(owner, true);
        for (slotId = 0; slotId < 54; ++slotId) {
            this.method_7621(new Slots.Hideable((class_1263)chest, slotId, 0, 0));
        }
        for (slotId = 0; slotId < 27; ++slotId) {
            this.method_7621(new class_1735((class_1263)invPlayer, slotId + 9, 0, 0));
        }
        for (slotId = 0; slotId < 9; ++slotId) {
            this.method_7621(new class_1735((class_1263)invPlayer, slotId, 0, 0));
        }
        this.size.method_17404(this.chest.method_5439());
        this.method_17362(this.size);
    }

    public void method_7623() {
        this.size.method_17404(this.chest.method_5439());
        super.method_7623();
    }

    public boolean isParentTile(TileEntityEnderChest tile) {
        return this.chestTile == tile;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7606(int id, int value) {
        super.method_7606(id, value);
        if (this.size.method_17407() != this.chest.method_5439()) {
            String name = this.chest.getNameKey();
            String[] parts = name.split("\\.");
            if (parts.length == 2) {
                ChestHelper.setCapacity((class_1937)class_310.method_1551().field_1687, parts[0], parts[1], (byte)value);
                this.callbackInventoryChange.run();
            } else if (parts.length == 4) {
                ChestHelper.setCapacity((class_1937)class_310.method_1551().field_1687, parts[2], parts[3], (byte)value);
                this.callbackInventoryChange.run();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void setInventoryChangeCallback(Runnable runnable) {
        this.callbackInventoryChange = runnable;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7593(int slotId, int dragType, class_1713 actionType, class_1657 player) {
        class_1799 stack;
        if (actionType == class_1713.field_7791 && dragType >= 0 && dragType < 9 && !(stack = player.method_31548().method_5438(dragType)).method_7960() && stack.method_7909() instanceof ItemEnderBag && ItemEnderBag.isOpen(stack)) {
            return;
        }
        super.method_7593(slotId, dragType, actionType, player);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.chestTile != null) {
            this.chestTile.onContainerClosed((class_2586)this.chestTile, (class_1263)this.chest, player);
        }
    }

    public class_1799 method_7601(class_1657 player, int slotNumber) {
        class_1735 clickedSlot = (class_1735)this.field_7761.get(slotNumber);
        if (clickedSlot == null || !clickedSlot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 itemInSlot = clickedSlot.method_7677();
        if (itemInSlot.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 returnStack = itemInSlot.method_7972();
        if (slotNumber < 54 ? !this.method_7616(itemInSlot, 54, this.field_7761.size(), true) : !this.method_7616(itemInSlot, 0, this.chest.method_5439(), false)) {
            return class_1799.field_8037;
        }
        if (itemInSlot.method_7947() == 0) {
            clickedSlot.method_48931(class_1799.field_8037);
        } else {
            clickedSlot.method_7668();
        }
        if (itemInSlot.method_7947() == returnStack.method_7947()) {
            return class_1799.field_8037;
        }
        return returnStack;
    }

    public int getChestSize() {
        return this.chest.method_5439();
    }

    public class_2561 getOwner() {
        return this.owner;
    }
}

