/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.block;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_8567;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ToolHelper;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.EnderChestsClient;
import shetiphian.enderchests.common.block.HitBoxHelper;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class BlockEnderChest
extends class_2237
implements IColored {
    public static final class_2746 STATIC = class_2746.method_11825((String)"static");
    public static final class_2753 FACING = class_2753.method_11845((String)"facing", (class_2350[])class_2350.values());
    private static final class_2754<EnumType> VARIANT = class_2754.method_11850((String)"variant", EnumType.class);
    public static final HashMap<class_2350, class_265[]> SHAPES = new HashMap();
    public static final HashMap<class_2350, class_265[]> SHAPES2 = new HashMap();

    public BlockEnderChest() {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10443).method_31710(class_3620.field_16009).method_36557(5.0f));
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)STATIC, (Comparable)Boolean.valueOf(true)));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            EnderChestsClient.colorize(this);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23581());
        });
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, VARIANT, STATIC});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityEnderChest(pos, state);
    }

    private TileEntityEnderChest getTile(class_1922 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        return tile instanceof TileEntityEnderChest ? (TileEntityEnderChest)tile : null;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (SHAPES.isEmpty()) {
            Map<class_2350, class_265> chest_body = HitBoxHelper.getBody();
            Map<class_2350, class_265> chest_lid = HitBoxHelper.getLid();
            Map<class_2350, class_265> top_ring = HitBoxHelper.getRing_Top();
            Map<class_2350, class_265> middle_ring = HitBoxHelper.getRing_Middle();
            Map<class_2350, class_265> bottom_ring = HitBoxHelper.getRing_Bottom();
            for (class_2350 direction : class_2350.values()) {
                class_265[] shapes = new class_265[]{chest_body.getOrDefault(direction, class_259.method_1073()), top_ring.getOrDefault(direction, class_259.method_1073()), middle_ring.getOrDefault(direction, class_259.method_1073()), bottom_ring.getOrDefault(direction, class_259.method_1073()), chest_lid.getOrDefault(direction, class_259.method_1073())};
                SHAPES.put(direction, shapes);
            }
        }
        if (!SHAPES.isEmpty()) {
            class_2350 direction = BlockEnderChest.getFacing(state);
            TileEntityEnderChest tile = this.getTile(world, pos);
            if (tile != null) {
                if (!SHAPES2.containsKey(direction)) {
                    class_265 base = SHAPES.get(direction)[0];
                    class_265 lid = SHAPES.get(direction)[4];
                    class_2382 vec = direction.method_10153().method_10163();
                    class_265[] shapes = new class_265[11];
                    shapes[0] = class_259.method_1084((class_265)base, (class_265)lid);
                    for (int index = 1; index <= 10; ++index) {
                        double var = (double)index / 10.0 * (double)0.7f;
                        shapes[index] = class_259.method_1084((class_265)base, (class_265)lid.method_1096((double)vec.method_10263() * var, (double)vec.method_10264() * var, (double)vec.method_10260() * var));
                    }
                    SHAPES2.put(direction, shapes);
                }
                return SHAPES2.get(direction)[tile.getLidOffsetIndex()];
            }
            return SHAPES.get(direction)[0];
        }
        return class_259.method_1077();
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return this.onBlockActivated(state, world, pos, player, player.method_5998(hand));
    }

    public class_1269 onBlockActivated(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1799 heldItem) {
        TileEntityEnderChest chestTile = this.getTile((class_1922)world, pos);
        if (chestTile == null) {
            return class_1269.field_5811;
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        if (!player.method_5715()) {
            if (heldItem.method_7960() || !ToolHelper.isWrench((class_1799)heldItem)) {
                class_2338 blockpos = pos.method_10093(BlockEnderChest.getFacing(state).method_10153());
                if (player instanceof class_3222 && chestTile.canUse(player) && !world.method_8320(blockpos).method_26212((class_1922)world, blockpos)) {
                    player.method_17355((class_3908)new ContainerProviders.EnderChest(chestTile));
                }
            }
            return class_1269.field_5812;
        }
        if (!heldItem.method_7960()) {
            class_1767 color;
            int subHit;
            if (chestTile.isPublic()) {
                boolean changed = false;
                if (Values.listPersonal.contains(heldItem.method_7909())) {
                    if (EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.personal_chests) {
                        changed = true;
                        chestTile.setOwner(player, heldItem.method_7972().method_7971(1));
                        Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.PRIVATE))), (boolean)true);
                    } else {
                        ChestInfoHelper.sendError(player, "enderchests.chest.private.disabled");
                    }
                }
                if (!changed && Values.listTeam.contains(heldItem.method_7909())) {
                    if (EnderChests.CONFIG.COMMON.ACCESS_SETTINGS.team_chests) {
                        String teamID = Function.getPlayerTeamID((class_1657)player);
                        if (!Strings.isNullOrEmpty((String)teamID)) {
                            changed = true;
                            chestTile.setOwner(Function.getTeamDisplayName((String)teamID), "#" + teamID, heldItem.method_7972().method_7971(1));
                            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.TEAM))), (boolean)true);
                        } else {
                            ChestInfoHelper.sendError(player, "shetiphian.team.noteam");
                        }
                    } else {
                        ChestInfoHelper.sendError(player, "enderchests.chest.team.disabled");
                    }
                }
                if (changed) {
                    if (!player.method_31549().field_7477) {
                        heldItem.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
            }
            if (!chestTile.canEdit(player)) {
                return class_1269.field_5812;
            }
            short capacity = ChestHelper.getCapacity(world, chestTile.getOwnerID(), chestTile.getCode());
            if (capacity < EnderChests.CONFIG.COMMON.UPGRADE_SETTINGS.chest_size_max) {
                int newValue = 0;
                if (Values.listSmallCap_Single.contains(heldItem.method_7909())) {
                    newValue = -1;
                    if (chestTile.applyItem(heldItem)) {
                        newValue = 3;
                    } else {
                        ChestInfoHelper.sendError(player, "enderchests.chest.upgrade_used");
                    }
                }
                if (newValue == 0 && Values.listSmallCap_Multi.contains(heldItem.method_7909())) {
                    newValue = 3;
                }
                if (newValue == 0 && capacity + 9 <= EnderChests.CONFIG.COMMON.UPGRADE_SETTINGS.chest_size_max) {
                    if (Values.listLargeCap_Single.contains(heldItem.method_7909())) {
                        newValue = -1;
                        if (chestTile.applyItem(heldItem)) {
                            newValue = 9;
                        } else {
                            ChestInfoHelper.sendError(player, "enderchests.chest.upgrade_used");
                        }
                    }
                    if (newValue == 0 && Values.listLargeCap_Multi.contains(heldItem.method_7909())) {
                        newValue = 9;
                    }
                }
                if (newValue > 0) {
                    ChestHelper.setCapacity(world, chestTile.getOwnerID(), chestTile.getCode(), (byte)(capacity + newValue));
                    if (!player.method_31549().field_7477) {
                        heldItem.method_7934(1);
                    }
                    ChestInfoHelper.sendCapacityInfo(player, chestTile);
                    return class_1269.field_5812;
                }
            }
            if (EnderChests.CONFIG.COMMON.enable_in_world_coloring && (subHit = Function.getSubShapeHit((class_1297)player, (class_2338)pos, (class_265[])SHAPES.get(state.method_11654((class_2769)FACING)))) > 0 && subHit < 4 && (color = DyeHelper.getDyeColor((class_1792)heldItem.method_7909())) != null && chestTile.doColorRing(color, player)) {
                if (!player.method_31549().field_7477) {
                    heldItem.method_7934(1);
                }
                world.method_8408(pos, (class_2248)this);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5812;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.method_8608() ? BlockEnderChest.method_31618(type, Roster.Tiles.ENDERCHEST, TileEntityEnderChest::tick) : null;
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        if (tile != null && tile.canEdit(player, false)) {
            return super.method_9594(state, player, world, pos);
        }
        return -1.0f;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8038().method_10153());
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        TileEntityEnderChest tile = this.getTile((class_1922)world, pos);
        if (tile != null) {
            Object code = StackHelper.getCode(stack);
            while (((String)code).length() < 3) {
                code = "0" + (String)code;
            }
            class_1799 personalItem = StackHelper.getPersonalItem(stack);
            tile.setCode((String)code);
            if (!personalItem.method_7960()) {
                tile.setOwner(StackHelper.getOwnerName(stack), StackHelper.getOwnerID(stack), personalItem);
                Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : EnumType.PRIVATE)))), (boolean)true);
            }
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List drops = super.method_9560(state, builder);
        class_2586 builderTile = (class_2586)builder.method_51876(class_181.field_1228);
        if (builderTile instanceof TileEntityEnderChest) {
            class_1799 personal;
            TileEntityEnderChest tile = (TileEntityEnderChest)builderTile;
            class_1297 builderEntity = (class_1297)builder.method_51876(class_181.field_1226);
            if (builderEntity != null && builderEntity.method_5715() && !(personal = tile.getPersonalItem()).method_7960()) {
                drops.add(personal);
            }
        }
        return drops;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        if (tile != null) {
            return StackHelper.create(class_1792.method_7867((class_2248)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
        }
        return new class_1799((class_1935)this);
    }

    public String method_9539() {
        return "block.enderchests.chest.public";
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (rotation != class_2470.field_11467) {
            class_2350 facing = BlockEnderChest.getFacing(state);
            if (rotation == class_2470.field_11464) {
                return (class_2680)state.method_11657((class_2769)FACING, (Comparable)facing.method_10153());
            }
            int value = facing.ordinal() + (rotation == class_2470.field_11463 ? 1 : -1);
            value = value < 0 ? 5 : (value > 5 ? 0 : value);
            return (class_2680)state.method_11657((class_2769)FACING, (Comparable)class_2350.method_10143((int)value));
        }
        return state;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        TileEntityEnderChest tile = this.getTile((class_1922)world, pos);
        return tile != null ? class_1703.method_7618((class_1263)tile.getChest()) : 0;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderChest tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile((class_1922)data.world, data.pos)) != null) {
            int value = class_3532.method_15340((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public static class_2350 getFacing(class_2680 state) {
        class_2350 facing;
        try {
            facing = (class_2350)state.method_11654((class_2769)FACING);
        }
        catch (Exception e) {
            facing = class_2350.field_11033;
            EnderChests.LOGGER.error("PropertyEnum 'BlockEnderChest.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + state);
        }
        return facing;
    }

    public static enum EnumType implements class_3542
    {
        PUBLIC("public"),
        PRIVATE("private"),
        TEAM("team");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

