/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import com.mojang.logging.LogUtils;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import shetiphian.core.common.events.ServerWorldSaveCallback;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.EventHandler;

public class EnderChests
implements ModInitializer {
    public static final String MOD_ID = "enderchests";
    public static EnderChests INSTANCE;
    public static Logger LOGGER;
    public static Configuration CONFIG;

    public EnderChests() {
        INSTANCE = this;
        LOGGER = LogUtils.getLogger();
    }

    public void onInitialize() {
        Roster.process();
        AutoConfig.register(Configuration.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        CONFIG = (Configuration)AutoConfig.getConfigHolder(Configuration.class).getConfig();
        Values.minecraftDir = FabricLoader.getInstance().getGameDir().toString();
        ServerLifecycleEvents.SERVER_STARTING.register(EnderChests::serverStarted);
        ServerLifecycleEvents.SERVER_STOPPED.register(EnderChests::serverStopped);
        CommonLifecycleEvents.TAGS_LOADED.register(EventHandler::tagsUpdated);
        ServerWorldSaveCallback.EVENT.register(EventHandler::worldSave);
        UseBlockCallback.EVENT.register(EventHandler::playerRightClickBlock);
    }

    private static void serverStarted(MinecraftServer server) {
        ChestHelper.INSTANCE.loadChestData(server);
    }

    private static void serverStopped(MinecraftServer server) {
        ChestHelper.INSTANCE.unloadChestData();
        Values.canProcessTags = false;
    }

    static {
        CONFIG = new Configuration();
    }
}

