/*
 * Decompiled with CFR 0.152.
 */
package com.github.shiftjis.enchantanything.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1890.class})
public class MixinEnchantmentHelper {
    @Inject(method={"getEnchantmentCost"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEnchantmentCost(class_5819 random, int enchantNum, int power, class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        int minCost = random.method_43048(8) + 1 + (power >> 1) + random.method_43048(power + 1);
        minCost = enchantNum == 0 ? Math.max(minCost / 3, 1) : (enchantNum == 1 ? minCost * 2 / 3 + 1 : Math.max(minCost, power * 2));
        cir.setReturnValue((Object)(minCost + stack.method_7921().size() * 3));
    }

    @Inject(method={"getAvailableEnchantmentResults"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getAvailableEnchantmentResults(int level, class_1799 stack, boolean allowTreasure, CallbackInfoReturnable<List<class_1889>> cir) {
        ArrayList enchantmentInstances = Lists.newArrayList();
        for (class_1887 enchantment : class_7923.field_41176) {
            for (int i = enchantment.method_8183(); i > enchantment.method_8187() - 1; --i) {
                enchantmentInstances.add(new class_1889(enchantment, i));
            }
        }
        cir.setReturnValue((Object)enchantmentInstances);
    }

    @Inject(method={"getItemEnchantmentLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getItemEnchantmentLevel(class_1887 enchantment, class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        if (stack.method_7960()) {
            cir.setReturnValue((Object)0);
            return;
        }
        class_2960 enchantmentId = class_1890.method_37423((class_1887)enchantment);
        class_2499 enchantmentTags = stack.method_7921();
        int totalLevel = 0;
        for (int i = 0; i < enchantmentTags.size(); ++i) {
            class_2487 compoundtag = enchantmentTags.method_10602(i);
            class_2960 tagEnchantmentId = class_1890.method_37427((class_2487)compoundtag);
            if (tagEnchantmentId == null || !tagEnchantmentId.equals((Object)enchantmentId)) continue;
            totalLevel += class_1890.method_37424((class_2487)compoundtag);
        }
        cir.setReturnValue((Object)totalLevel);
    }
}

