/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.network;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.UUID;
import net.dungeonz.DungeonzMain;
import net.dungeonz.block.entity.DungeonGateEntity;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.init.ItemInit;
import net.dungeonz.item.DungeonCompassItem;
import net.dungeonz.util.DungeonHelper;
import net.dungeonz.util.InventoryHelper;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DungeonServerPacket {
    public static final class_2960 DUNGEON_INFO_PACKET = new class_2960("dungeonz", "dungeon_info");
    public static final class_2960 DUNGEON_TELEPORT_PACKET = new class_2960("dungeonz", "dungeon_teleport");
    public static final class_2960 DUNGEON_TELEPORT_COUNTDOWN_PACKET = new class_2960("dungeonz", "dungeon_teleport_countdown");
    public static final class_2960 CHANGE_DUNGEON_DIFFICULTY_PACKET = new class_2960("dungeonz", "change_dungeon_difficulty");
    public static final class_2960 CHANGE_DUNGEON_EFFECTS_PACKET = new class_2960("dungeonz", "change_dungeon_effects");
    public static final class_2960 CHANGE_DUNGEON_PRIVATE_GROUP_PACKET = new class_2960("dungeonz", "change_dungeon_private_group");
    public static final class_2960 SET_DUNGEON_TYPE_PACKET = new class_2960("dungeonz", "set_dungeon_type");
    public static final class_2960 SET_DUNGEON_COMPASS_PACKET = new class_2960("dungeonz", "set_dungeon_compass");
    public static final class_2960 SET_GATE_BLOCK_PACKET = new class_2960("dungeonz", "set_gate_block");
    public static final class_2960 SYNC_GATE_BLOCK_PACKET = new class_2960("dungeonz", "sync_gate_block");
    public static final class_2960 SYNC_SCREEN_PACKET = new class_2960("dungeonz", "sync_screen");
    public static final class_2960 OP_SCREEN_PACKET = new class_2960("dungeonz", "op_screen");
    public static final class_2960 COMPASS_SCREEN_PACKET = new class_2960("dungeonz", "compass_screen");

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANGE_DUNGEON_DIFFICULTY_PACKET, (server, player, handler, buffer, sender) -> {
            class_2338 dungeonPortalPos = buffer.method_10811();
            server.execute(() -> {
                DungeonPortalEntity dungeonPortalEntity;
                if (player.method_37908().method_8321(dungeonPortalPos) != null && player.method_37908().method_8321(dungeonPortalPos) instanceof DungeonPortalEntity && (dungeonPortalEntity = (DungeonPortalEntity)player.method_37908().method_8321(dungeonPortalPos)).getDungeonPlayerCount() == 0) {
                    List<String> difficulties = dungeonPortalEntity.getDungeon().getDifficultyList();
                    if (dungeonPortalEntity.getDifficulty().equals("")) {
                        dungeonPortalEntity.setDifficulty(difficulties.get(0));
                    } else {
                        int index = difficulties.indexOf(dungeonPortalEntity.getDifficulty()) + 1;
                        if (index >= difficulties.size()) {
                            index = 0;
                        }
                        dungeonPortalEntity.setDifficulty(difficulties.get(index));
                    }
                    dungeonPortalEntity.method_5431();
                    DungeonServerPacket.writeS2CSyncScreenPacket(player, dungeonPortalEntity);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)DUNGEON_TELEPORT_PACKET, (server, player, handler, buffer, sender) -> {
            class_2338 dungeonPortalPos = buffer.method_10811();
            Boolean isMinGroupRequired = buffer.readBoolean();
            UUID uuid = isMinGroupRequired != false ? buffer.method_10790() : null;
            server.execute(() -> DungeonHelper.teleportDungeon(player, dungeonPortalPos, uuid));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANGE_DUNGEON_EFFECTS_PACKET, (server, player, handler, buffer, sender) -> {
            class_2338 dungeonPortalPos = buffer.method_10811();
            boolean disableEffects = buffer.readBoolean();
            server.execute(() -> {
                DungeonPortalEntity dungeonPortalEntity;
                if (player.method_37908().method_8321(dungeonPortalPos) != null && player.method_37908().method_8321(dungeonPortalPos) instanceof DungeonPortalEntity && (dungeonPortalEntity = (DungeonPortalEntity)player.method_37908().method_8321(dungeonPortalPos)).getDungeonPlayerCount() == 0) {
                    dungeonPortalEntity.setDisableEffects(disableEffects);
                    dungeonPortalEntity.method_5431();
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANGE_DUNGEON_PRIVATE_GROUP_PACKET, (server, player, handler, buffer, sender) -> {
            class_2338 dungeonPortalPos = buffer.method_10811();
            boolean privateGroup = buffer.readBoolean();
            server.execute(() -> {
                DungeonPortalEntity dungeonPortalEntity;
                if (player.method_37908().method_8321(dungeonPortalPos) != null && player.method_37908().method_8321(dungeonPortalPos) instanceof DungeonPortalEntity && (dungeonPortalEntity = (DungeonPortalEntity)player.method_37908().method_8321(dungeonPortalPos)).getDungeonPlayerCount() == 0) {
                    dungeonPortalEntity.setPrivateGroup(privateGroup);
                    dungeonPortalEntity.method_5431();
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SET_DUNGEON_TYPE_PACKET, (server, player, handler, buffer, sender) -> {
            class_2338 dungeonPortalPos = buffer.method_10811();
            String dungeonType = buffer.method_19772();
            String defaultDifficulty = buffer.method_19772();
            server.execute(() -> {
                if (player.method_7338()) {
                    if (Dungeon.getDungeon(dungeonType) != null) {
                        Dungeon dungeon = Dungeon.getDungeon(dungeonType);
                        if (dungeon.getDifficultyList().contains(defaultDifficulty)) {
                            if (player.method_37908().method_8321(dungeonPortalPos) != null && player.method_37908().method_8321(dungeonPortalPos) instanceof DungeonPortalEntity) {
                                DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)player.method_37908().method_8321(dungeonPortalPos);
                                dungeonPortalEntity.setDungeonType(dungeonType);
                                dungeonPortalEntity.setDifficulty(defaultDifficulty);
                                dungeonPortalEntity.setMaxGroupSize(dungeon.getMaxGroupSize());
                                dungeonPortalEntity.setMinGroupSize(dungeon.getMinGroupSize());
                                dungeonPortalEntity.method_5431();
                                player.method_7353(class_2561.method_30163((String)"Set dungeon type successfully!"), false);
                                return;
                            }
                        } else {
                            player.method_7353(class_2561.method_30163((String)("Failed to set dungeon type cause difficulty " + defaultDifficulty + " does not exist in type " + dungeonType + "!")), false);
                        }
                    } else {
                        player.method_7353(class_2561.method_30163((String)("Failed to set dungeon type cause " + dungeonType + " does not exist!")), false);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SET_GATE_BLOCK_PACKET, (server, player, handler, buffer, sender) -> {
            class_2338 gatePos = buffer.method_10811();
            String blockId = buffer.method_19772();
            String particleId = buffer.method_19772();
            String unlockItemId = buffer.method_19772();
            server.execute(() -> {
                if (player.method_7338() && player.method_37908().method_8321(gatePos) != null && player.method_37908().method_8321(gatePos) instanceof DungeonGateEntity) {
                    List<class_2338> otherDungeonGatesPosList = DungeonGateEntity.getConnectedDungeonGatePosList(player.method_37908(), gatePos);
                    for (int i = 0; i < otherDungeonGatesPosList.size(); ++i) {
                        if (player.method_37908().method_8321(otherDungeonGatesPosList.get(i)) == null || !(player.method_37908().method_8321(otherDungeonGatesPosList.get(i)) instanceof DungeonGateEntity)) continue;
                        DungeonGateEntity otherDungeonGateEntity = (DungeonGateEntity)player.method_37908().method_8321(otherDungeonGatesPosList.get(i));
                        otherDungeonGateEntity.setBlockId(new class_2960(blockId));
                        otherDungeonGateEntity.setParticleEffectId(particleId);
                        otherDungeonGateEntity.setUnlockItemId(unlockItemId);
                        otherDungeonGateEntity.method_5431();
                    }
                    DungeonServerPacket.writeS2CSyncGatePacket(player, (DungeonGateEntity)player.method_37908().method_8321(gatePos), otherDungeonGatesPosList);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SET_DUNGEON_COMPASS_PACKET, (server, player, handler, buffer, sender) -> {
            String dungeonType = buffer.method_19772();
            server.execute(() -> {
                if (player.method_6047().method_31574(ItemInit.DUNGEON_COMPASS) && InventoryHelper.hasRequiredItemStacks(player.method_31548(), ItemInit.REQUIRED_DUNGEON_COMPASS_CALIBRATION_ITEMS)) {
                    InventoryHelper.decrementRequiredItemStacks(player.method_31548(), ItemInit.REQUIRED_DUNGEON_COMPASS_CALIBRATION_ITEMS);
                    DungeonCompassItem.setCompassDungeonStructure((class_3218)player.method_37908(), player.method_24515(), player.method_6047(), dungeonType);
                }
            });
        });
    }

    public static void writeS2CDungeonInfoPacket(class_3222 serverPlayerEntity, List<Integer> breakableBlockIdList, List<Integer> placeableBlockIdList, boolean allowElytra) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_34060((IntList)new IntArrayList(breakableBlockIdList));
        buf.method_34060((IntList)new IntArrayList(placeableBlockIdList));
        buf.writeBoolean(allowElytra);
        class_2658 packet = new class_2658(DUNGEON_INFO_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CSyncScreenPacket(class_3222 serverPlayerEntity, DungeonPortalEntity dungeonPortalEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(dungeonPortalEntity.method_11016());
        buf.method_10814(dungeonPortalEntity.getDifficulty());
        class_2658 packet = new class_2658(SYNC_SCREEN_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2COpenOpScreenPacket(class_3222 serverPlayerEntity, @Nullable DungeonPortalEntity dungeonPortalEntity, @Nullable DungeonGateEntity dungeonGateEntity) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        if (dungeonPortalEntity != null) {
            buf.method_10814("portal");
            buf.method_10807(dungeonPortalEntity.method_11016());
            buf.method_10814(dungeonPortalEntity.getDungeonType());
            buf.method_10814(dungeonPortalEntity.getDifficulty());
        }
        if (dungeonGateEntity != null) {
            buf.method_10814("gate");
            buf.method_10807(dungeonGateEntity.method_11016());
            buf.method_10814(class_7923.field_41175.method_10221((Object)dungeonGateEntity.getBlockState().method_26204()).toString());
            buf.method_10814(dungeonGateEntity.getParticleEffect() != null ? dungeonGateEntity.getParticleEffect().method_10293() : "");
            buf.method_10814(dungeonGateEntity.getUnlockItem() != null ? class_7923.field_41178.method_10221((Object)dungeonGateEntity.getUnlockItem()).toString() : "");
        }
        class_2658 packet = new class_2658(OP_SCREEN_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2COpenCompassScreenPacket(class_3222 serverPlayerEntity, String dungeonType) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(dungeonType);
        int dungeonCount = DungeonzMain.DUNGEONS.size();
        buf.writeInt(dungeonCount);
        for (int i = 0; i < dungeonCount; ++i) {
            buf.method_10814(DungeonzMain.DUNGEONS.get(i).getDungeonTypeId());
        }
        class_2658 packet = new class_2658(COMPASS_SCREEN_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CSyncGatePacket(class_3222 serverPlayerEntity, DungeonGateEntity dungeonGateEntity, List<class_2338> dungeonGatesPosList) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(dungeonGatesPosList.size());
        for (int i = 0; i < dungeonGatesPosList.size(); ++i) {
            buf.method_10807(dungeonGatesPosList.get(i));
        }
        buf.method_10814(class_7923.field_41175.method_10221((Object)dungeonGateEntity.getBlockState().method_26204()).toString());
        buf.method_10814(dungeonGateEntity.getParticleEffect() != null ? dungeonGateEntity.getParticleEffect().method_10293() : "");
        buf.method_10814(dungeonGateEntity.getUnlockItem() != null ? class_7923.field_41178.method_10221((Object)dungeonGateEntity.getUnlockItem()).toString() : "");
        class_2658 packet = new class_2658(SYNC_GATE_BLOCK_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }

    public static void writeS2CDungeonTeleportCountdown(class_3222 serverPlayerEntity, int countdownTicks) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(countdownTicks);
        class_2658 packet = new class_2658(DUNGEON_TELEPORT_COUNTDOWN_PACKET, buf);
        serverPlayerEntity.field_13987.method_14364((class_2596)packet);
    }
}

