/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.dungeon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dungeonz.DungeonzMain;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class Dungeon {
    private final String dungeonTypeId;
    private final HashMap<Integer, List<class_1299<?>>> blockIdEntityMap;
    private final HashMap<Integer, HashMap<String, Float>> blockIdEntitySpawnChance;
    private final HashMap<Integer, Integer> blockIdBlockReplacement;
    private final HashMap<Integer, Integer> spawnerEntityIdCountMap;
    private final HashMap<Integer, Integer> requiredItemCountMap;
    private final List<Integer> breakableBlockIds;
    private final List<Integer> placeableBlockIds;
    private final HashMap<String, Float> difficultyMobModificator;
    private final HashMap<String, List<String>> difficultyLootTableIds;
    private final HashMap<String, Float> difficultyBossModificator;
    private final HashMap<String, String> difficultyBossLootTable;
    private final class_1299<?> bossEntityType;
    @Nullable
    private final class_2487 bossNbtCompound;
    private final int bossBlockId;
    private final int bossLootBlockId;
    private final int exitBlockId;
    private final boolean allowRespawn;
    private final boolean allowElytra;
    private final int maxGroupSize;
    private final int minGroupSize;
    private final int cooldown;
    private final class_2960 dungeonBackgroundId;
    private final class_2960 dungeonStructurePoolId;

    public Dungeon(String dungeonTypeId, HashMap<Integer, List<class_1299<?>>> blockIdEntityMap, HashMap<Integer, HashMap<String, Float>> blockIdEntitySpawnChance, HashMap<Integer, Integer> blockIdBlockReplacement, HashMap<Integer, Integer> spawnerEntityIdCountMap, HashMap<Integer, Integer> requiredItemCountMap, List<Integer> breakableBlockIds, List<Integer> placeableBlockIds, HashMap<String, Float> difficultyMobModificator, HashMap<String, List<String>> difficultyLootTableIds, HashMap<String, Float> difficultyBossModificator, HashMap<String, String> difficultyBossLootTable, class_1299<?> bossEntityType, class_2487 bossNbtCompound, int bossBlockId, int bossLootBlockId, int exitBlockId, boolean allowRespawn, boolean allowElytra, int maxGroupSize, int minGroupSize, int cooldown, class_2960 dungeonBackgroundId, class_2960 dungeonStructurePoolId) {
        this.dungeonTypeId = dungeonTypeId;
        this.blockIdEntityMap = blockIdEntityMap;
        this.blockIdEntitySpawnChance = blockIdEntitySpawnChance;
        this.blockIdBlockReplacement = blockIdBlockReplacement;
        this.spawnerEntityIdCountMap = spawnerEntityIdCountMap;
        this.requiredItemCountMap = requiredItemCountMap;
        this.breakableBlockIds = breakableBlockIds;
        this.placeableBlockIds = placeableBlockIds;
        this.difficultyMobModificator = difficultyMobModificator;
        this.difficultyLootTableIds = difficultyLootTableIds;
        this.difficultyBossModificator = difficultyBossModificator;
        this.difficultyBossLootTable = difficultyBossLootTable;
        this.bossEntityType = bossEntityType;
        this.bossNbtCompound = bossNbtCompound;
        this.bossBlockId = bossBlockId;
        this.bossLootBlockId = bossLootBlockId;
        this.exitBlockId = exitBlockId;
        this.allowRespawn = allowRespawn;
        this.allowElytra = allowElytra;
        this.maxGroupSize = maxGroupSize;
        this.minGroupSize = minGroupSize;
        this.cooldown = cooldown;
        this.dungeonBackgroundId = dungeonBackgroundId;
        this.dungeonStructurePoolId = dungeonStructurePoolId;
    }

    public String getDungeonTypeId() {
        return this.dungeonTypeId;
    }

    public class_2960 getStructurePoolId() {
        return this.dungeonStructurePoolId;
    }

    public class_2960 getBackgroundId() {
        return this.dungeonBackgroundId;
    }

    public List<String> getDifficultyList() {
        return new ArrayList<String>(this.difficultyMobModificator.keySet());
    }

    public HashMap<Integer, List<class_1299<?>>> getBlockIdEntityMap() {
        return this.blockIdEntityMap;
    }

    public HashMap<Integer, HashMap<String, Float>> getBlockIdEntitySpawnChanceMap() {
        return this.blockIdEntitySpawnChance;
    }

    public HashMap<Integer, Integer> getBlockIdBlockReplacementMap() {
        return this.blockIdBlockReplacement;
    }

    public HashMap<String, Float> getDifficultyMobModificatorMap() {
        return this.difficultyMobModificator;
    }

    public HashMap<String, List<String>> getDifficultyLootTableIdMap() {
        return this.difficultyLootTableIds;
    }

    public HashMap<String, Float> getDifficultyBossModificatorMap() {
        return this.difficultyBossModificator;
    }

    public HashMap<String, String> getDifficultyBossLootTableMap() {
        return this.difficultyBossLootTable;
    }

    public HashMap<Integer, Integer> getSpawnerEntityIdMap() {
        return this.spawnerEntityIdCountMap;
    }

    public HashMap<Integer, Integer> getRequiredItemCountMap() {
        return this.requiredItemCountMap;
    }

    public List<Integer> getBreakableBlockIdList() {
        return this.breakableBlockIds;
    }

    public List<Integer> getplaceableBlockIdList() {
        return this.placeableBlockIds;
    }

    public class_1299<?> getBossEntityType() {
        return this.bossEntityType;
    }

    @Nullable
    public class_2487 getBossNbtCompound() {
        return this.bossNbtCompound;
    }

    public int getBossBlockId() {
        return this.bossBlockId;
    }

    public int getBossLootBlockId() {
        return this.bossLootBlockId;
    }

    public int getExitBlockId() {
        return this.exitBlockId;
    }

    public int getMaxGroupSize() {
        return this.maxGroupSize;
    }

    public int getMinGroupSize() {
        return this.minGroupSize;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isElytraAllowed() {
        return this.allowElytra;
    }

    public boolean isRespawnAllowed() {
        return this.allowRespawn;
    }

    public boolean containsBlockId(int blockId) {
        return this.blockIdEntityMap.containsKey(blockId);
    }

    public static void addDungeon(Dungeon dungeon) {
        if (!DungeonzMain.DUNGEONS.stream().anyMatch(d -> d.getDungeonTypeId().equals(dungeon.getDungeonTypeId()))) {
            DungeonzMain.DUNGEONS.add(dungeon);
        }
    }

    @Nullable
    public static Dungeon getDungeon(String dungeonTypeId) {
        for (int i = 0; i < DungeonzMain.DUNGEONS.size(); ++i) {
            if (!DungeonzMain.DUNGEONS.get(i).getDungeonTypeId().equals(dungeonTypeId)) continue;
            return DungeonzMain.DUNGEONS.get(i);
        }
        return null;
    }
}

