/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.block.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.init.BlockInit;
import net.dungeonz.util.DungeonHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class DungeonPortalScreenHandler
extends class_1703 {
    private final class_1937 world;
    private final class_3914 context;
    private final DungeonPortalEntity dungeonPortalEntity;
    private class_2338 pos;
    private List<String> difficulties = new ArrayList<String>();
    private Map<String, List<class_1799>> possibleLootDifficultyItemStackMap = new HashMap<String, List<class_1799>>();
    private List<class_1799> requiredItemStacks = new ArrayList<class_1799>();
    private int waitingGroupSize = 0;

    public DungeonPortalScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        this(syncId, playerInventory, new DungeonPortalEntity(buf.method_10811(), playerInventory.field_7546.method_37908().method_8320(buf.method_10811())), class_3914.field_17304);
        this.pos = buf.method_10811();
        int dungeonPlayerCount = buf.readInt();
        ArrayList<UUID> dungeonPlayerUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < dungeonPlayerCount; ++i) {
            dungeonPlayerUUIDs.add(buf.method_10790());
        }
        int deadDungeonPlayerCount = buf.readInt();
        ArrayList<UUID> deadDungeonPlayerUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < deadDungeonPlayerCount; ++i) {
            deadDungeonPlayerUUIDs.add(buf.method_10790());
        }
        int difficultyCount = buf.readInt();
        ArrayList<String> difficulties = new ArrayList<String>();
        if (difficultyCount != 0) {
            for (int i = 0; i < difficultyCount; ++i) {
                difficulties.add(buf.method_19772());
            }
        }
        int possibleLootCount = buf.readInt();
        HashMap<String, List<class_1799>> possibleLootDifficultyItemStackMap = new HashMap<String, List<class_1799>>();
        if (possibleLootCount != 0) {
            for (int i = 0; i < possibleLootCount; ++i) {
                ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
                String difficulty = buf.method_19772();
                int lootCount = buf.readInt();
                for (int u = 0; u < lootCount; ++u) {
                    itemStacks.add(buf.method_10819());
                }
                possibleLootDifficultyItemStackMap.put(difficulty, itemStacks);
            }
        }
        HashMap<String, List<class_1799>> possibleLootDifficultyItemStacks = possibleLootDifficultyItemStackMap;
        int requiredItemCount = buf.readInt();
        ArrayList<class_1799> requiredItemStacks = new ArrayList<class_1799>();
        if (requiredItemCount != 0) {
            for (int i = 0; i < requiredItemCount; ++i) {
                requiredItemStacks.add(buf.method_10819());
            }
        }
        int maxGroupSize = buf.readInt();
        int minGroupSize = buf.readInt();
        int waitingGroupSize = buf.readInt();
        int cooldownTime = buf.readInt();
        String difficulty = buf.method_19772();
        boolean disableEffects = buf.readBoolean();
        boolean privateGroup = buf.readBoolean();
        this.setDifficulties(difficulties);
        this.setPossibleLootItemStacks(possibleLootDifficultyItemStacks);
        this.setRequiredItemStacks(requiredItemStacks);
        this.setWaitingGroupSize(waitingGroupSize);
        this.getDungeonPortalEntity().setDungeonPlayerUuids(dungeonPlayerUUIDs);
        this.getDungeonPortalEntity().setDeadDungeonPlayerUuids(deadDungeonPlayerUUIDs);
        this.getDungeonPortalEntity().setMaxGroupSize(maxGroupSize);
        this.getDungeonPortalEntity().setMinGroupSize(minGroupSize);
        this.getDungeonPortalEntity().setCooldownTime(cooldownTime);
        this.getDungeonPortalEntity().setDifficulty(difficulty);
        this.getDungeonPortalEntity().setDisableEffects(disableEffects);
        this.getDungeonPortalEntity().setPrivateGroup(privateGroup);
    }

    public DungeonPortalScreenHandler(int syncId, class_1661 playerInventory, DungeonPortalEntity dungeonPortalEntity, class_3914 context) {
        super(BlockInit.PORTAL, syncId);
        this.context = context;
        this.world = playerInventory.field_7546.method_37908();
        this.dungeonPortalEntity = dungeonPortalEntity;
        this.pos = dungeonPortalEntity.method_11016();
        if (!this.world.method_8608()) {
            this.setDifficulties(this.dungeonPortalEntity.getDungeon().getDifficultyList());
            this.setRequiredItemStacks(DungeonHelper.getRequiredItemStackList(this.dungeonPortalEntity.getDungeon()));
            this.setPossibleLootItemStacks(DungeonHelper.getPossibleLootItemStackMap(this.dungeonPortalEntity.getDungeon(), this.world.method_8503()));
        }
    }

    public class_1799 method_7601(class_1657 var1, int var2) {
        return null;
    }

    public boolean method_7597(class_1657 player) {
        return (Boolean)this.context.method_17396((world, pos) -> {
            if (!this.world.method_8320(pos).method_27852(BlockInit.DUNGEON_PORTAL)) {
                return false;
            }
            return player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0;
        }, (Object)true);
    }

    @Nullable
    public class_2960 getBackgroundId() {
        if (this.dungeonPortalEntity.getDungeon() == null) {
            return null;
        }
        return this.dungeonPortalEntity.getDungeon().getBackgroundId();
    }

    public DungeonPortalEntity getDungeonPortalEntity() {
        return this.dungeonPortalEntity;
    }

    public List<String> getDifficulties() {
        return this.difficulties;
    }

    public void setDifficulties(List<String> difficulties) {
        this.difficulties = difficulties;
    }

    public Map<String, List<class_1799>> getPossibleLootDifficultyItemStackMap() {
        return this.possibleLootDifficultyItemStackMap;
    }

    public void setPossibleLootItemStacks(Map<String, List<class_1799>> possibleLootDifficultyItemStackMap) {
        this.possibleLootDifficultyItemStackMap = possibleLootDifficultyItemStackMap;
    }

    public List<class_1799> getRequiredItemStacks() {
        return this.requiredItemStacks;
    }

    public void setRequiredItemStacks(List<class_1799> requiredItemStacks) {
        this.requiredItemStacks = requiredItemStacks;
    }

    public int getWaitingGroupSize() {
        return this.waitingGroupSize;
    }

    public void setWaitingGroupSize(int waitingGroupSize) {
        this.waitingGroupSize = waitingGroupSize;
    }

    public class_2338 getPos() {
        return this.pos;
    }
}

