/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.network;

import java.util.Optional;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.common.CritRecord;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.mehvahdjukaar.dummmmmmy.configs.CritMode;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;

public class ClientBoundDamageNumberMessage
implements Message {
    private final int entityID;
    private final float damageAmount;
    private final class_2960 damageType;
    private final boolean isCrit;
    private final float critMult;

    public ClientBoundDamageNumberMessage(class_2540 buf) {
        this.entityID = buf.readInt();
        this.damageAmount = buf.readFloat();
        this.damageType = buf.method_10810();
        this.isCrit = buf.readBoolean();
        this.critMult = this.isCrit ? buf.readFloat() : 0.0f;
    }

    public ClientBoundDamageNumberMessage(class_1309 e, float damage, class_1282 source, @Nullable CritRecord critical) {
        this(e.method_5628(), damage, ClientBoundDamageNumberMessage.encodeDamage(e.method_37908(), source), critical != null, critical == null ? 0.0f : critical.getMultiplier());
    }

    public static class_2960 encodeDamage(class_1937 level, class_1282 source) {
        if (source == null) {
            return Dummmmmmy.TRUE_DAMAGE;
        }
        class_8110 damageType = source.method_48792();
        if (damageType == null) {
            throw new AssertionError((Object)("Damage source has null type. How?: " + String.valueOf(source)));
        }
        Optional id = source.method_48793().method_40230();
        if (id.isEmpty()) {
            throw new AssertionError((Object)("Damage type not found in registry. This is a bug from that mod that added it!: " + String.valueOf(damageType)));
        }
        return ((class_5321)id.get()).method_29177();
    }

    protected ClientBoundDamageNumberMessage(int id, float damage, class_2960 damageType, boolean isCrit, float critMult) {
        this.entityID = id;
        this.damageAmount = damage;
        this.damageType = damageType;
        this.isCrit = isCrit;
        this.critMult = critMult;
    }

    public void writeToBuffer(class_2540 buf) {
        buf.writeInt(this.entityID);
        buf.writeFloat(this.damageAmount);
        buf.method_10812(this.damageType);
        buf.writeBoolean(this.isCrit);
        if (this.isCrit) {
            buf.writeFloat(this.critMult);
        }
    }

    public void handle(ChannelHandler.Context context) {
        class_1297 entity = class_310.method_1551().field_1687.method_8469(this.entityID);
        if (entity instanceof TargetDummyEntity) {
            TargetDummyEntity dummy = (TargetDummyEntity)entity;
            if (ClientConfigs.DAMAGE_NUMBERS.get().booleanValue()) {
                int i = dummy.getNextNumberPos();
                this.spawnParticle(entity, i);
            }
            if (ClientConfigs.HAY_PARTICLES.get().booleanValue()) {
                this.spawnHay(entity);
            }
        } else if (entity != null) {
            this.spawnParticle(entity, 0);
        }
    }

    private void spawnParticle(class_1297 entity, int animationPos) {
        class_2960 type = this.damageType;
        float mult = 0.0f;
        CritMode critMode = ClientConfigs.CRIT_MODE.get();
        if (critMode != CritMode.OFF && this.isCrit) {
            type = Dummmmmmy.CRITICAL_DAMAGE;
            if (critMode == CritMode.COLOR_AND_MULTIPLIER) {
                mult = this.critMult;
            }
        }
        double z = CritMode.encodeIntFloatToDouble(animationPos, mult);
        int color = ClientConfigs.getDamageColor(type);
        entity.method_37908().method_8406((class_2394)Dummmmmmy.NUMBER_PARTICLE.get(), entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), (double)this.damageAmount, (double)color, z);
    }

    private void spawnHay(class_1297 entity) {
        class_5819 random = entity.method_37908().field_9229;
        int amount = (int)(1.0f + class_3532.method_37959((float)this.damageAmount, (float)0.0f, (float)40.0f, (float)0.0f, (float)10.0f));
        amount = class_3532.method_15340((int)amount, (int)0, (int)10);
        for (int i = 0; i < amount; ++i) {
            class_243 pos = new class_243(entity.method_23322(0.5), entity.method_23318() + 0.75 + (double)random.method_43057() * 0.85, entity.method_23325(0.5));
            class_243 speed = ClientBoundDamageNumberMessage.getOutwardSpeed(pos.method_1020(entity.method_19538()), random);
            entity.method_37908().method_8406((class_2394)Dummmmmmy.HAY_PARTICLE.get(), pos.field_1352, pos.field_1351, pos.field_1350, speed.field_1352, (double)random.method_43057() * 0.04, speed.field_1350);
        }
    }

    public static class_243 getOutwardSpeed(class_243 position, class_5819 random) {
        class_243 direction = position.method_1029();
        float randomLen = 0.02f + random.method_43057() * 0.04f;
        float angleVariation = (float)(random.method_43059() * (double)0.3f);
        float sin = class_3532.method_15374((float)angleVariation);
        float cos = class_3532.method_15362((float)angleVariation);
        double newX = direction.field_1352 * (double)cos - direction.field_1350 * (double)sin;
        double newY = direction.field_1352 * (double)sin + direction.field_1350 * (double)cos;
        return new class_243(newX * (double)randomLen, 0.0, newY * (double)randomLen);
    }
}

