/*
 * Decompiled with CFR 0.152.
 */
package net.dehydration.thirst;

import com.mojang.blaze3d.systems.RenderSystem;
import net.dehydration.access.HudAccess;
import net.dehydration.access.ThirstManagerAccess;
import net.dehydration.init.ConfigInit;
import net.dehydration.init.EffectInit;
import net.dehydration.init.RenderInit;
import net.dehydration.item.LeatherFlask;
import net.dehydration.misc.ThirstTooltipData;
import net.dehydration.thirst.ThirstManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class ThirstHudRender {
    public static void renderThirstHud(class_332 context, class_310 client, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        ThirstManager thirstManager;
        if (playerEntity != null && !playerEntity.method_5655() && (thirstManager = ((ThirstManagerAccess)playerEntity).getThirstManager()).hasThirst()) {
            int thirst = thirstManager.getThirstLevel();
            int height = scaledHeight - 49;
            int width = scaledWidth / 2 + 91;
            if (vehicleHeartCount == 0) {
                class_1799 itemStack = null;
                if (ConfigInit.CONFIG.thirst_preview && thirst < 20) {
                    if (!playerEntity.method_6047().method_7960() && playerEntity.method_6047().method_32347().isPresent() && playerEntity.method_6047().method_32347().get() instanceof ThirstTooltipData) {
                        itemStack = playerEntity.method_6047();
                    } else if (!playerEntity.method_6079().method_7960() && playerEntity.method_6079().method_32347().isPresent() && playerEntity.method_6079().method_32347().get() instanceof ThirstTooltipData) {
                        itemStack = playerEntity.method_6079();
                    }
                }
                if (itemStack != null) {
                    ((HudAccess)client.field_1705).setOtherFlashAlpha(otherFlashAlpha += 0.06544985f);
                    ((HudAccess)client.field_1705).setFlashAlpha((class_3532.method_15362((float)(otherFlashAlpha + (float)Math.PI)) + 1.0f) / 2.0f);
                } else if (otherFlashAlpha > 0.01f) {
                    ((HudAccess)client.field_1705).setOtherFlashAlpha(0.0f);
                    ((HudAccess)client.field_1705).setFlashAlpha(0.0f);
                }
                for (int variable_one = 0; variable_one < 10; ++variable_one) {
                    int variable_three = height;
                    if (thirstManager.dehydration >= 4.0f && ticks % (thirst * 3 + 1) == 0) {
                        variable_three = height + (playerEntity.method_37908().method_8409().method_43048(3) - 1);
                        thirstManager.dehydration -= 4.0f;
                    } else if (ticks % (thirst * 8 + 3) == 0) {
                        variable_three = height + (playerEntity.method_37908().method_8409().method_43048(3) - 1);
                    }
                    int uppderCoord = 9;
                    if (ConfigInit.CONFIG.other_droplet_texture) {
                        uppderCoord += 9;
                    }
                    int beneathCoord = 0;
                    if (playerEntity.method_6059(EffectInit.THIRST)) {
                        beneathCoord = 36;
                    }
                    int variable_two = width - variable_one * 8 - 9;
                    context.method_25290(RenderInit.THIRST_ICON, variable_two += ConfigInit.CONFIG.hud_x, variable_three += ConfigInit.CONFIG.hud_y, 0.0f, 0.0f, 9, 9, 256, 256);
                    if (variable_one * 2 + 1 < thirst) {
                        context.method_25290(RenderInit.THIRST_ICON, variable_two, variable_three, (float)beneathCoord, (float)uppderCoord, 9, 9, 256, 256);
                    }
                    if (variable_one * 2 + 1 == thirst) {
                        context.method_25290(RenderInit.THIRST_ICON, variable_two, variable_three, (float)(beneathCoord + 9), (float)uppderCoord, 9, 9, 256, 256);
                    }
                    if (variable_one >= thirst / 2 && itemStack != null) {
                        RenderSystem.enableBlend();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)flashAlpha);
                        int thirstQuench = ((ThirstTooltipData)itemStack.method_32347().get()).getThirstQuench();
                        if (itemStack.method_7909() instanceof LeatherFlask) {
                            thirstQuench = ConfigInit.CONFIG.flask_thirst_quench;
                        }
                        int quality = ((ThirstTooltipData)itemStack.method_32347().get()).getDrinkQuality();
                        if (variable_one < (thirst + thirstQuench) / 2) {
                            context.method_25290(RenderInit.THIRST_ICON, variable_two, variable_three, (float)(quality * 18), 9.0f, 9, 9, 256, 256);
                        } else if ((thirst + thirstQuench) % 2 != 0 && variable_one < (thirst + thirstQuench) / 2 + 1) {
                            context.method_25290(RenderInit.THIRST_ICON, variable_two, variable_three, (float)(quality * 18 + 9), 9.0f, 9, 9, 256, 256);
                        }
                        RenderSystem.disableBlend();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    if (playerEntity.method_32312() <= 0) continue;
                    RenderSystem.enableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)playerEntity.method_32313());
                    if (variable_one * 2 + 1 < thirst) {
                        context.method_25290(RenderInit.THIRST_ICON, variable_two, variable_three, 54.0f, (float)uppderCoord, 9, 9, 256, 256);
                    }
                    if (variable_one * 2 + 1 == thirst) {
                        context.method_25290(RenderInit.THIRST_ICON, variable_two, variable_three, 63.0f, (float)uppderCoord, 9, 9, 256, 256);
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }
}

