/*
 * Decompiled with CFR 0.152.
 */
package net.dehydration.mixin;

import com.mojang.authlib.GameProfile;
import net.dehydration.access.ServerPlayerAccess;
import net.dehydration.access.ThirstManagerAccess;
import net.dehydration.network.ThirstServerPacket;
import net.dehydration.thirst.ThirstManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657
implements ServerPlayerAccess {
    private ThirstManager thirstManager = ((ThirstManagerAccess)((Object)this)).getThirstManager();
    private int syncedThirstLevel = -99999999;
    public int compatSync = 0;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"playerTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;tick()V", shift=At.Shift.AFTER)})
    public void playerTickMixin(CallbackInfo info) {
        if (this.syncedThirstLevel != this.thirstManager.getThirstLevel() && this.thirstManager.hasThirst()) {
            ThirstServerPacket.writeS2CThirstUpdatePacket((class_3222)this);
            this.syncedThirstLevel = this.thirstManager.getThirstLevel();
        }
        if (this.compatSync > 0) {
            --this.compatSync;
            if (this.compatSync == 1) {
                ThirstServerPacket.writeS2CExcludedSyncPacket((class_3222)this, this.thirstManager.hasThirst());
            }
        }
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerPlayerEntity;copyFrom(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setHealth(F)V")})
    public void copyFromMixinOne(class_3222 oldPlayer, boolean alive, CallbackInfo info) {
        this.thirstManager.setThirstLevel(((ThirstManagerAccess)oldPlayer).getThirstManager().getThirstLevel());
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerPlayerEntity;copyFrom(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V"}, at={@At(value="TAIL")})
    public void copyFromMixinTwo(class_3222 oldPlayer, boolean alive, CallbackInfo info) {
        this.syncedThirstLevel = -1;
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerPlayerEntity;teleport(Lnet/minecraft/server/world/ServerWorld;DDDFF)V"}, at={@At(value="TAIL")})
    private void teleportMixin(class_3218 targetWorld, double x, double y, double z, float yaw, float pitch, CallbackInfo info) {
        this.syncedThirstLevel = -1;
    }

    @Inject(method={"moveToWorld"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerPlayerEntity;syncedFoodLevel:I", ordinal=0)})
    @Nullable
    private void moveToWorldMixin(class_3218 destination, CallbackInfoReturnable<class_1297> info) {
        this.syncedThirstLevel = -1;
    }

    @Override
    public void compatSync() {
        this.compatSync = 5;
    }
}

