/*
 * Decompiled with CFR 0.152.
 */
package net.dehydration.mixin;

import net.dehydration.DehydrationMain;
import net.dehydration.access.PlayerAccess;
import net.dehydration.access.ThirstManagerAccess;
import net.dehydration.init.ConfigInit;
import net.dehydration.init.TagInit;
import net.dehydration.thirst.ThirstManager;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements ThirstManagerAccess,
PlayerAccess {
    private ThirstManager thirstManager = new ThirstManager();
    @Shadow
    protected class_1702 field_7493 = new class_1702();
    @Shadow
    private int field_7487;
    private int drinkTime = 0;

    @Override
    public ThirstManager getThirstManager() {
        return this.thirstManager;
    }

    public PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"Lnet/minecraft/entity/player/PlayerEntity;tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;update(Lnet/minecraft/entity/player/PlayerEntity;)V", shift=At.Shift.AFTER)})
    private void tickMixin(CallbackInfo info) {
        if (this.thirstManager.hasThirst()) {
            this.thirstManager.update((class_1657)this);
        }
    }

    @Inject(method={"Lnet/minecraft/entity/player/PlayerEntity;tickMovement()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;updateItems()V", shift=At.Shift.BEFORE)})
    private void tickMovementMixin(CallbackInfo info) {
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_37908().method_8450().method_8355(class_1928.field_19395) && this.thirstManager.hasThirst()) {
            class_1657 player = (class_1657)this;
            this.thirstManager.update(player);
            if (this.thirstManager.isNotFull() && this.field_6012 % 10 == 0) {
                this.thirstManager.setThirstLevel(this.thirstManager.getThirstLevel() + 1);
            }
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromTagMixin(class_2487 tag, CallbackInfo info) {
        this.thirstManager.readNbt(tag);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToTagMixin(class_2487 tag, CallbackInfo info) {
        this.thirstManager.writeNbt(tag);
    }

    @Inject(method={"Lnet/minecraft/entity/player/PlayerEntity;addExhaustion(F)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;addExhaustion(F)V", shift=At.Shift.AFTER)})
    private void addExhaustionMixin(float exhaustion, CallbackInfo info) {
        if (this.thirstManager.hasThirst()) {
            if (ConfigInit.CONFIG.harder_nether && this.method_37908().method_8597().comp_644()) {
                exhaustion *= ConfigInit.CONFIG.nether_factor;
            }
            this.thirstManager.addDehydration(exhaustion / ConfigInit.CONFIG.hydrating_factor);
        }
    }

    @Inject(method={"Lnet/minecraft/entity/player/PlayerEntity;wakeUp(ZZ)V"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/PlayerEntity;sleepTimer:I")})
    private void wakeUpMixin(boolean bl, boolean updateSleepingPlayers, CallbackInfo info) {
        if (!this.method_37908().method_8608() && this.thirstManager.hasThirst() && this.field_7487 >= 100) {
            int thirstLevel = this.thirstManager.getThirstLevel();
            int hungerLevel = this.field_7493.method_7586();
            int thirstConsumption = ConfigInit.CONFIG.sleep_thirst_consumption;
            int hungerConsumption = ConfigInit.CONFIG.sleep_hunger_consumption;
            this.thirstManager.setThirstLevel(thirstLevel >= thirstConsumption ? thirstLevel - thirstConsumption : 0);
            this.field_7493.method_7580(hungerLevel >= hungerConsumption ? hungerLevel - hungerConsumption : 0);
        }
    }

    @Inject(method={"eatFood"}, at={@At(value="HEAD")})
    private void eatFoodMixin(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> info) {
        int thirstQuench = 0;
        if (stack.method_31573(TagInit.HYDRATING_STEW)) {
            thirstQuench = ConfigInit.CONFIG.stew_thirst_quench;
        }
        if (stack.method_31573(TagInit.HYDRATING_FOOD)) {
            thirstQuench = ConfigInit.CONFIG.food_thirst_quench;
        }
        if (stack.method_31573(TagInit.HYDRATING_DRINKS)) {
            thirstQuench = ConfigInit.CONFIG.drinks_thirst_quench;
        }
        if (stack.method_31573(TagInit.STRONGER_HYDRATING_STEW)) {
            thirstQuench = ConfigInit.CONFIG.stronger_stew_thirst_quench;
        }
        if (stack.method_31573(TagInit.STRONGER_HYDRATING_FOOD)) {
            thirstQuench = ConfigInit.CONFIG.stronger_food_thirst_quench;
        }
        if (stack.method_31573(TagInit.STRONGER_HYDRATING_DRINKS)) {
            thirstQuench = ConfigInit.CONFIG.stronger_drinks_thirst_quench;
        }
        for (int i = 0; i < DehydrationMain.HYDRATION_TEMPLATES.size(); ++i) {
            if (!DehydrationMain.HYDRATION_TEMPLATES.get(i).containsItem(stack.method_7909())) continue;
            thirstQuench = DehydrationMain.HYDRATION_TEMPLATES.get(i).getHydration();
            break;
        }
        if (thirstQuench > 0) {
            ((ThirstManagerAccess)((class_1657)this)).getThirstManager().add(thirstQuench);
        }
    }

    @Override
    public void setDrinkTime(int time) {
        this.drinkTime = time;
    }

    @Override
    public int getDrinkTime() {
        return this.drinkTime;
    }
}

