/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.damagenumbers.client;

import dev.foxgirl.damagenumbers.DamageNumbers;
import dev.foxgirl.damagenumbers.client.Color;
import dev.foxgirl.damagenumbers.client.Config;
import dev.foxgirl.damagenumbers.client.ConfigScreenFactory;
import dev.foxgirl.damagenumbers.client.DamageNumbersHandler;
import dev.foxgirl.damagenumbers.client.TextParticle;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_403;
import net.minecraft.class_4066;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;

public final class DamageNumbersImpl
implements DamageNumbersHandler,
Config.PathProvider {
    @NotNull
    public final Config config = new Config();
    @NotNull
    public final Config configDefault = new Config();
    @NotNull
    public final Path configDirPath;
    private final Deque<TextParticle> particles = new ArrayDeque<TextParticle>();

    @Override
    @NotNull
    public Path getConfigFilePath() {
        return this.configDirPath.resolve("damagenumbers.json");
    }

    @Override
    @NotNull
    public Path getConfigTempPath() {
        return this.configDirPath.resolve("damagenumbers.json.tmp");
    }

    public DamageNumbersImpl(@NotNull Path configDir) {
        this.configDirPath = configDir;
        this.config.readConfig(this);
    }

    @Override
    @NotNull
    public class_437 createConfigScreen(@NotNull class_437 parent) {
        try {
            ConfigScreenFactory factory = (ConfigScreenFactory)Class.forName("dev.foxgirl.damagenumbers.client.ConfigScreenFactoryImpl").getConstructor(Config.class, Config.class, Config.PathProvider.class).newInstance(this.config, this.configDefault, this);
            return factory.createConfigScreen(parent);
        }
        catch (NoClassDefFoundError cause) {
            DamageNumbers.LOGGER.error("Failed to create config screen due to missing class", (Throwable)cause);
        }
        catch (ReflectiveOperationException cause) {
            DamageNumbers.LOGGER.error("Failed to create config screen due to reflection error", (Throwable)cause);
        }
        return new class_403(() -> class_310.method_1551().method_1507(parent), class_2561.method_30163((String)"Config screen unavailable"), class_2561.method_30163((String)"YACL3 (Yet Another Config Library 3) may not be installed.\nPlease install a supported version to use the Damage Numbers config screen."));
    }

    @Override
    public void onEntityHealthChange(@NotNull class_1309 entity, float oldHealth, float newHealth) {
        int particleLimit;
        if (!this.config.isEnabled) {
            return;
        }
        float damage = oldHealth - newHealth;
        if (damage <= 0.0f) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (entity == client.field_1724 && !this.config.isPlayerDamageShown) {
            return;
        }
        class_638 world = client.field_1687;
        if (world == null || world != entity.method_37908()) {
            return;
        }
        if (entity.method_5858((class_1297)client.field_1724) > 2304.0) {
            return;
        }
        switch ((class_4066)client.field_1690.method_42475().method_41753()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_18197: {
                int n = 256;
                break;
            }
            case field_18198: {
                int n = 64;
                break;
            }
            case field_18199: {
                int n = particleLimit = 16;
            }
        }
        while (this.particles.size() >= particleLimit) {
            TextParticle particle = this.particles.poll();
            if (particle == null) continue;
            particle.method_3085();
        }
        class_243 particlePos = entity.method_19538().method_1031(0.0, (double)entity.method_17682() + 0.25, 0.0);
        class_243 particleVelocity = entity.method_18798();
        class_243 particleVelocityForward = entity.method_19538();
        particleVelocityForward = particleVelocityForward.method_1020(client.field_1773.method_19418().method_19326()).method_1029();
        particleVelocityForward = particleVelocityForward.method_1021((double)entity.method_17681() * 10.0);
        particleVelocity = particleVelocity.method_1023(particleVelocityForward.field_1352, -20.0, particleVelocityForward.field_1350);
        TextParticle particle = new TextParticle(world, particlePos, particleVelocity);
        String text = String.format("%.1f", Float.valueOf(damage));
        if (text.endsWith(".0")) {
            text = text.substring(0, text.length() - 2);
        }
        particle.setText(text);
        if (damage >= 16.0f) {
            particle.setColor(this.config.colorLg);
        } else if (damage >= 8.0f) {
            particle.setColor(Color.lerp(this.config.colorMd, this.config.colorLg, (damage - 8.0f) / 8.0f));
        } else if (damage >= 2.0f) {
            particle.setColor(Color.lerp(this.config.colorSm, this.config.colorMd, (damage - 2.0f) / 6.0f));
        } else {
            particle.setColor(this.config.colorSm);
        }
        this.particles.add(particle);
        client.field_1713.method_3058((class_703)particle);
    }
}

