/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.alternator;

import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class AlternatorBlockEntity
extends KineticBlockEntity
implements EnergyTransferable {
    protected final InternalEnergyStorage energy;
    private boolean firstTickState = true;
    private LazyOptional<EnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<EnergyStorage> escacheWest = LazyOptional.empty();

    public AlternatorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.energy = new InternalEnergyStorage((Long)Config.ALTERNATOR_CAPACITY.get(), 0L, (Long)Config.ALTERNATOR_MAX_OUTPUT.get());
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"createaddition.tooltip.energy.production").method_27692(class_124.field_1080)));
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43470((String)(" " + Util.format(AlternatorBlockEntity.getEnergyProductionRate((int)(this.isSpeedRequirementFulfilled() ? this.getSpeed() : 0.0f))) + "fe/t ")).method_27692(class_124.field_1075)).method_10852((class_2561)Lang.translateDirect((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).method_27692(class_124.field_1063)));
        return true;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)Config.MAX_STRESS.get()).intValue() / 256.0f;
        return impact;
    }

    @Override
    public EnergyStorage getEnergyStorage(class_2350 side) {
        return this.energy;
    }

    public boolean isEnergyInput(class_2350 side) {
        return false;
    }

    public boolean isEnergyOutput(class_2350 side) {
        return true;
    }

    public void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
    }

    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            return;
        }
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            this.energy.internalProduceEnergy(AlternatorBlockEntity.getEnergyProductionRate((int)this.getSpeed()));
        }
        for (class_2350 d : class_2350.values()) {
            EnergyStorage ies;
            if (!this.isEnergyOutput(d) || (ies = this.getCachedEnergy(d)) == null) continue;
            try (Transaction t = Transaction.openOuter();){
                EnergyStorageUtil.move((EnergyStorage)this.energy, (EnergyStorage)ies, (long)((Long)Config.ALTERNATOR_MAX_OUTPUT.get()), (TransactionContext)t);
                t.commit();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        float componentSpeed = Math.abs(this.getSpeed());
        if (componentSpeed == 0.0f || !this.isSpeedRequirementFulfilled()) {
            return;
        }
        float pitch = class_3532.method_15363((float)(componentSpeed / 256.0f + 0.5f), (float)0.5f, (float)1.5f);
        if (((Boolean)Config.AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play(CASoundScapes.AmbienceGroup.DYNAMO, this.field_11867, pitch);
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)((Integer)Config.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0) * (Double)Config.ALTERNATOR_EFFICIENCY.get());
    }

    protected class_2248 getStressConfigKey() {
        return (class_2248)CABlocks.ALTERNATOR.get();
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.field_11863.method_8608()) {
            return;
        }
        for (class_2350 side : class_2350.values()) {
            class_2586 te = this.field_11863.method_8321(this.field_11867.method_10093(side));
            if (te == null) {
                this.setCache(side, (LazyOptional<EnergyStorage>)LazyOptional.empty());
                continue;
            }
            LazyOptional le = LazyOptional.ofObject((Object)((EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(side), (Object)side.method_10153())));
            this.setCache(side, (LazyOptional<EnergyStorage>)le);
        }
    }

    public void setCache(class_2350 side, LazyOptional<EnergyStorage> storage) {
        switch (side) {
            case field_11033: {
                this.escacheDown = storage;
                break;
            }
            case field_11034: {
                this.escacheEast = storage;
                break;
            }
            case field_11043: {
                this.escacheNorth = storage;
                break;
            }
            case field_11035: {
                this.escacheSouth = storage;
                break;
            }
            case field_11036: {
                this.escacheUp = storage;
                break;
            }
            case field_11039: {
                this.escacheWest = storage;
            }
        }
    }

    public EnergyStorage getCachedEnergy(class_2350 side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> (EnergyStorage)this.escacheDown.orElse(null);
            case class_2350.field_11034 -> (EnergyStorage)this.escacheEast.orElse(null);
            case class_2350.field_11043 -> (EnergyStorage)this.escacheNorth.orElse(null);
            case class_2350.field_11035 -> (EnergyStorage)this.escacheSouth.orElse(null);
            case class_2350.field_11036 -> (EnergyStorage)this.escacheUp.orElse(null);
            case class_2350.field_11039 -> (EnergyStorage)this.escacheWest.orElse(null);
        };
    }
}

