/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.Create;
import com.tterrag.registrate.fabric.BaseLangProvider;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class TagLangGen {
    public static void datagen() {
        Create.REGISTRATE.addDataGenerator(ProviderType.LANG, TagLangGen::genItemTagLang);
    }

    private static void genItemTagLang(RegistrateLangProvider prov) {
        TagLangHelper common = new TagLangHelper("c", (BaseLangProvider)prov);
        common.suffixedCategory("blocks").auto("andesite_alloy").auto("brass").auto("raw_zinc").auto("zinc");
        common.suffixedCategory("ingots").auto("brass").auto("zinc");
        common.suffixedCategory("nuggets").auto("brass").auto("zinc");
        common.suffixedCategory("plates").auto("copper").auto("gold").auto("iron").auto("brass").auto("obsidian");
        common.suffixedCategory("ores").auto("zinc");
        common.prefixedCategory("raw").auto("zinc").auto("ores").auto("zinc_ores");
        common.suffixedCategory("dough").autoRoot().auto("wheat");
        common.suffixedCategory("flour").autoRoot().auto("wheat");
        common.subDir("dusts").auto("obsidian");
        common.prefixedCategory("stripped").auto("logs").auto("wood");
        common.auto("boots");
        common.auto("chestplates");
        common.auto("helmets");
        common.auto("honey_buckets");
        common.auto("chocolate");
        common.auto("honey");
        common.auto("tea");
        TagLangHelper create = new TagLangHelper("create", (BaseLangProvider)prov);
        create.auto("tracks");
        create.subDir("blaze_burner_fuel").plural("regular").plural("special");
        create.plural("casing");
        create.put("contraption_controlled", "Actors");
        create.put("bottomless/allow", "Potentially Infinite Fluids");
        create.auto("diving_fluids");
        create.auto("create_ingots");
        create.auto("crushed_raw_materials");
        create.plural("deployable_drink");
        create.auto("modded_stripped_logs");
        create.auto("modded_stripped_wood");
        create.auto("pressurized_air_sources");
        create.auto("sandpaper");
        create.auto("seats");
        create.auto("sleepers");
        create.subDir("stone_types").ignoreDir("andesite").ignoreDir("asurine").ignoreDir("calcite").ignoreDir("crimsite").ignoreDir("deepslate").ignoreDir("diorite").ignoreDir("dripstone").ignoreDir("granite").ignoreDir("limestone").ignoreDir("ochrum").ignoreDir("scorchia").ignoreDir("scoria").ignoreDir("tuff").ignoreDir("veridium");
        create.subDir("stone_types/galosphere").ignoreDir("allurite").ignoreDir("amethyst").ignoreDir("lumiere");
        create.auto("toolboxes");
        create.auto("valve_handles");
        create.auto("vanilla_stripped_logs");
        create.auto("vanilla_stripped_wood");
        create.subDir("upgrade_aquatic").ignoreDir("coral");
    }

    public static String key(class_2960 tagId) {
        String namespace = tagId.method_12836();
        String path = tagId.method_12832().replace('/', '.');
        return "tag." + namespace + "." + path;
    }

    public static String translate(class_2960 tagId) {
        String path = tagId.method_12832();
        String[] split = path.split("/");
        switch (split.length) {
            case 1: {
                return TagLangGen.toSentence(split);
            }
            case 2: {
                String[] switched = new String[]{split[1], split[0]};
                return TagLangGen.toSentence(switched);
            }
        }
        throw new IllegalArgumentException("Tags with >1 subdirectory (" + tagId + ") cannot be automatically translated");
    }

    public static String toSentence(String[] segments) {
        StringBuilder sentence = new StringBuilder();
        for (String segment : segments) {
            String[] split;
            for (String word : split = segment.split("_")) {
                String capitalized = StringUtils.capitalize((String)word);
                sentence.append(capitalized).append(' ');
            }
        }
        return sentence.toString().trim();
    }

    public record TagLangHelper(String namespace, BaseLangProvider prov) {
        public TagLangHelper auto(String path) {
            class_2960 id = new class_2960(this.namespace, path);
            String key = TagLangGen.key(id);
            String name = TagLangGen.translate(id);
            this.prov.add(key, name);
            return this;
        }

        public TagLangHelper put(String path, String translated) {
            class_2960 id = new class_2960(this.namespace, path);
            String key = TagLangGen.key(id);
            this.prov.add(key, translated);
            return this;
        }

        public TagLangHelper plural(String path) {
            class_2960 id = new class_2960(this.namespace, path);
            String key = TagLangGen.key(id);
            String name = TagLangGen.translate(id) + "s";
            this.prov.add(key, name);
            return this;
        }

        public SubDirHelper subDir(String dir) {
            return new SubDirHelper(this, dir);
        }

        public CategoryHelper suffixedCategory(String suffix) {
            return new CategoryHelper(this, suffix, true);
        }

        public CategoryHelper prefixedCategory(String prefix) {
            return new CategoryHelper(this, prefix, false);
        }
    }

    public record CategoryHelper(TagLangHelper parent, String category, boolean suffix) {
        public CategoryHelper put(String path, String translated) {
            class_2960 id = this.tagId(path);
            this.parent.prov.add(TagLangGen.key(id), translated);
            return this;
        }

        public CategoryHelper auto(String path) {
            return this.put(path, TagLangGen.translate(this.tagId(path)));
        }

        public CategoryHelper plural(String path) {
            return this.put(path, TagLangGen.translate(this.tagId(path)) + "s");
        }

        public CategoryHelper autoRoot() {
            class_2960 id = new class_2960(this.parent.namespace, this.category);
            this.parent.prov.add(TagLangGen.key(id), TagLangGen.translate(id));
            return this;
        }

        public class_2960 tagId(String name) {
            String path = this.suffix ? name + "_" + this.category : this.category + "_" + name;
            return new class_2960(this.parent.namespace, path);
        }
    }

    public record SubDirHelper(TagLangHelper parent, String dir) {
        public SubDirHelper put(String path, String translated) {
            class_2960 id = this.tagId(path);
            this.parent.prov.add(TagLangGen.key(id), translated);
            return this;
        }

        public SubDirHelper auto(String path) {
            return this.put(path, TagLangGen.translate(this.tagId(path)));
        }

        public SubDirHelper ignoreDir(String path) {
            class_2960 id = new class_2960(this.parent.namespace, path);
            return this.put(path, TagLangGen.translate(id));
        }

        public SubDirHelper plural(String path) {
            return this.put(path, TagLangGen.translate(this.tagId(path)) + "s");
        }

        public SubDirHelper autoRoot() {
            class_2960 id = new class_2960(this.parent.namespace, this.dir);
            this.parent.prov.add(TagLangGen.key(id), TagLangGen.translate(id));
            return this;
        }

        public class_2960 tagId(String path) {
            return new class_2960(this.parent.namespace, this.dir + "/" + path);
        }
    }
}

