/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.content.contraptions.render.ContraptionEntityRenderer;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_765;

public class CarriageContraptionEntityRenderer
extends ContraptionEntityRenderer<CarriageContraptionEntity> {
    public CarriageContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public boolean shouldRender(CarriageContraptionEntity entity, class_4604 clippingHelper, double cameraX, double cameraY, double cameraZ) {
        Carriage carriage = entity.getCarriage();
        if (carriage != null) {
            for (CarriageBogey bogey : carriage.bogeys) {
                if (bogey == null) continue;
                bogey.couplingAnchors.replace(v -> null);
            }
        }
        return super.shouldRender(entity, clippingHelper, cameraX, cameraY, cameraZ);
    }

    @Override
    public void render(CarriageContraptionEntity entity, float yaw, float partialTicks, class_4587 ms, class_4597 buffers, int overlay) {
        if (!entity.validForRender || entity.firstPositionUpdate) {
            return;
        }
        super.render(entity, yaw, partialTicks, ms, buffers, overlay);
        Carriage carriage = entity.getCarriage();
        if (carriage == null) {
            return;
        }
        class_243 position = entity.method_30950(partialTicks);
        float viewYRot = entity.method_5705(partialTicks);
        float viewXRot = entity.method_5695(partialTicks);
        int bogeySpacing = carriage.bogeySpacing;
        carriage.bogeys.forEach(bogey -> {
            class_2338 bogeyPos;
            if (bogey == null) {
                return;
            }
            class_2338 class_23382 = bogeyPos = bogey.isLeading ? class_2338.field_10980 : class_2338.field_10980.method_10079(entity.getInitialOrientation().method_10160(), bogeySpacing);
            if (!Backend.canUseInstancing((class_1937)entity.method_37908()) && !entity.getContraption().isHiddenInPortal(bogeyPos)) {
                ms.method_22903();
                CarriageContraptionEntityRenderer.translateBogey(ms, bogey, bogeySpacing, viewYRot, viewXRot, partialTicks);
                int light = CarriageContraptionEntityRenderer.getBogeyLightCoords(entity, bogey, partialTicks);
                bogey.type.render(null, bogey.wheelAngle.getValue(partialTicks), ms, partialTicks, buffers, light, overlay, bogey.getStyle(), bogey.bogeyData);
                ms.method_22909();
            }
            bogey.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, partialTicks, bogey.isLeading);
            if (!carriage.isOnTwoBogeys()) {
                bogey.updateCouplingAnchor(position, viewXRot, viewYRot, bogeySpacing, partialTicks, !bogey.isLeading);
            }
        });
    }

    public static void translateBogey(class_4587 ms, CarriageBogey bogey, int bogeySpacing, float viewYRot, float viewXRot, float partialTicks) {
        boolean selfUpsideDown = bogey.isUpsideDown();
        boolean leadingUpsideDown = bogey.carriage.leadingBogey().isUpsideDown();
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)ms).rotateY((double)(viewYRot + 90.0f))).rotateX((double)(-viewXRot))).rotateY(180.0)).translate(0.0, 0.0, bogey.isLeading ? 0.0 : (double)(-bogeySpacing))).rotateY(-180.0)).rotateX((double)viewXRot)).rotateY((double)(-viewYRot - 90.0f))).rotateY((double)bogey.yaw.getValue(partialTicks))).rotateX((double)bogey.pitch.getValue(partialTicks))).translate(0.0, 0.5, 0.0)).rotateZ(selfUpsideDown ? 180.0 : 0.0)).translateY(selfUpsideDown != leadingUpsideDown ? 2.0 : 0.0);
    }

    public static int getBogeyLightCoords(CarriageContraptionEntity entity, CarriageBogey bogey, float partialTicks) {
        class_2338 lightPos = class_2338.method_49638((class_2374)((class_2374)Objects.requireNonNullElseGet(bogey.getAnchorPosition(), () -> entity.method_31166(partialTicks))));
        return class_765.method_23687((int)entity.method_37908().method_8314(class_1944.field_9282, lightPos), (int)entity.method_37908().method_8314(class_1944.field_9284, lightPos));
    }
}

