/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.display;

import com.google.common.base.Strings;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class FlapDisplaySection {
    static final Map<String, String[]> LOADED_FLAP_CYCLES = new HashMap<String, String[]>();
    static Random r = new Random();
    public static final float MONOSPACE = 7.0f;
    public static final float WIDE_MONOSPACE = 9.0f;
    float size;
    boolean singleFlap;
    boolean hasGap;
    boolean rightAligned;
    boolean wideFlaps;
    boolean sendTransition;
    String cycle;
    class_2561 component;
    String[] cyclingOptions;
    boolean[] spinning;
    int spinningTicks;
    String text;

    public FlapDisplaySection(float width, String cycle, boolean singleFlap, boolean hasGap) {
        this.size = width;
        this.cycle = cycle;
        this.hasGap = hasGap;
        this.singleFlap = singleFlap;
        this.spinning = new boolean[singleFlap ? 1 : Math.max(0, (int)(width / 7.0f))];
        this.text = Strings.repeat((String)" ", (int)this.spinning.length);
        this.component = null;
    }

    public FlapDisplaySection rightAligned() {
        this.rightAligned = true;
        return this;
    }

    public FlapDisplaySection wideFlaps() {
        this.wideFlaps = true;
        return this;
    }

    public void setText(class_2561 component) {
        this.component = component;
        this.sendTransition = true;
    }

    public void refresh(boolean transition) {
        if (this.component == null) {
            return;
        }
        Object newText = this.component.getString();
        if (!this.singleFlap) {
            if (this.rightAligned) {
                newText = ((String)newText).trim();
            }
            newText = ((String)newText).toUpperCase(Locale.ROOT);
            newText = ((String)newText).substring(0, Math.min(this.spinning.length, ((String)newText).length()));
            String whitespace = Strings.repeat((String)" ", (int)(this.spinning.length - ((String)newText).length()));
            Object object = newText = this.rightAligned ? whitespace + (String)newText : (String)newText + whitespace;
            if (!this.text.isEmpty()) {
                for (int i = 0; i < this.spinning.length; ++i) {
                    int n = i;
                    this.spinning[n] = this.spinning[n] | (transition && this.text.charAt(i) != ((String)newText).charAt(i));
                }
            }
        } else if (!this.text.isEmpty()) {
            this.spinning[0] = this.spinning[0] | (transition && !((String)newText).equals(this.text));
        }
        this.text = newText;
        this.spinningTicks = 0;
    }

    public int tick(boolean instant) {
        if (this.cyclingOptions == null) {
            return 0;
        }
        int max = Math.max(4, (int)((float)this.cyclingOptions.length * 1.75f));
        if (this.spinningTicks > max) {
            return 0;
        }
        ++this.spinningTicks;
        if (this.spinningTicks <= max && this.spinningTicks < 2) {
            return this.spinningTicks == 1 ? 0 : this.spinning.length;
        }
        int spinningFlaps = 0;
        for (int i = 0; i < this.spinning.length; ++i) {
            int increasingChance = class_3532.method_15340((int)(8 - this.spinningTicks), (int)1, (int)10);
            boolean continueSpin = !instant && r.nextInt(increasingChance * max / 4) != 0;
            boolean bl = max > 5 || this.spinningTicks < 2;
            int n = i;
            this.spinning[n] = this.spinning[n] & (continueSpin &= bl);
            if (i > 0 && r.nextInt(3) > 0) {
                int n2 = i - 1;
                this.spinning[n2] = this.spinning[n2] & continueSpin;
            }
            if (i < this.spinning.length - 1 && r.nextInt(3) > 0) {
                int n3 = i + 1;
                this.spinning[n3] = this.spinning[n3] & continueSpin;
            }
            if (this.spinningTicks > max) {
                this.spinning[i] = false;
            }
            if (!this.spinning[i]) continue;
            ++spinningFlaps;
        }
        return spinningFlaps;
    }

    public float getSize() {
        return this.size;
    }

    public class_2487 write() {
        class_2487 tag = new class_2487();
        tag.method_10548("Width", this.size);
        tag.method_10582("Cycle", this.cycle);
        if (this.rightAligned) {
            NBTHelper.putMarker(tag, "RightAligned");
        }
        if (this.singleFlap) {
            NBTHelper.putMarker(tag, "SingleFlap");
        }
        if (this.hasGap) {
            NBTHelper.putMarker(tag, "Gap");
        }
        if (this.wideFlaps) {
            NBTHelper.putMarker(tag, "Wide");
        }
        if (this.component != null) {
            tag.method_10582("Text", class_2561.class_2562.method_10867((class_2561)this.component));
        }
        if (this.sendTransition) {
            NBTHelper.putMarker(tag, "Transition");
        }
        this.sendTransition = false;
        return tag;
    }

    public static FlapDisplaySection load(class_2487 tag) {
        float width = tag.method_10583("Width");
        String cycle = tag.method_10558("Cycle");
        boolean singleFlap = tag.method_10545("SingleFlap");
        boolean hasGap = tag.method_10545("Gap");
        FlapDisplaySection section = new FlapDisplaySection(width, cycle, singleFlap, hasGap);
        section.cyclingOptions = FlapDisplaySection.getFlapCycle(cycle);
        section.rightAligned = tag.method_10545("RightAligned");
        section.wideFlaps = tag.method_10545("Wide");
        if (!tag.method_10545("Text")) {
            return section;
        }
        section.component = class_2561.class_2562.method_10877((String)tag.method_10558("Text"));
        section.refresh(tag.method_10577("Transition"));
        return section;
    }

    public void update(class_2487 tag) {
        this.component = class_2561.class_2562.method_10877((String)tag.method_10558("Text"));
        if (this.cyclingOptions == null) {
            this.cyclingOptions = FlapDisplaySection.getFlapCycle(this.cycle);
        }
        this.refresh(tag.method_10577("Transition"));
    }

    public boolean renderCharsIndividually() {
        return !this.singleFlap;
    }

    public class_2561 getText() {
        return this.component;
    }

    public static String[] getFlapCycle(String key) {
        return LOADED_FLAP_CYCLES.computeIfAbsent(key, k -> Lang.translateDirect("flap_display.cycles." + key, new Object[0]).getString().split(";"));
    }
}

