/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.companions.common.blockentity.ShadeMawAltarBlockEntity;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.ShadeAltarUpgradeHaloProjectile;
import dev.xylonity.companions.common.recipe.ShadeAltarRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ShadeAltarRecipeCategory
implements IRecipeCategory<ShadeAltarRecipe> {
    public static final class_2960 UID = new class_2960("companions", "shade_altar_interaction");
    public static final RecipeType<ShadeAltarRecipe> TYPE = new RecipeType(UID, ShadeAltarRecipe.class);
    public static final class_2960 SHADOW = new class_2960("companions", "textures/gui/sprites.png");
    private ShadeMawAltarBlockEntity cachedBlockEntity;
    private ShadeAltarUpgradeHaloProjectile cachedEntity;
    private long lastUpdateTime = 0L;
    private final IDrawable icon;
    private long lastEntityAppearTime = 0L;
    private int spawnCooldown;

    public ShadeAltarRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)CompanionsItems.CRYSTALLIZED_BLOOD.get()));
        this.spawnCooldown = 0;
    }

    @NotNull
    public RecipeType<ShadeAltarRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.companions.shade_altar_interaction.title");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 80;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ShadeAltarRecipe rec, @NotNull IFocusGroup focuses) {
        this.cachedEntity = null;
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private ShadeMawAltarBlockEntity getOrCreateBlockEntity() {
        if (this.cachedBlockEntity == null) {
            this.cachedBlockEntity = new ShadeMawAltarBlockEntity(class_2338.field_10980, CompanionsBlocks.SHADE_MAW_ALTAR.get().method_9564());
            this.cachedBlockEntity.addCharge();
        }
        return this.cachedBlockEntity;
    }

    private ShadeAltarUpgradeHaloProjectile getOrCreateEntity() {
        if (this.cachedEntity == null && this.spawnCooldown == 0) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 != null) {
                this.cachedEntity = new ShadeAltarUpgradeHaloProjectile((class_1299<? extends BaseProjectile>)CompanionsEntities.SHADE_ALTAR_UPGRADE_HALO, (class_1937)mc.field_1687);
                this.cachedEntity.method_5875(true);
                this.cachedEntity.field_6012 = 0;
            }
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        ShadeAltarUpgradeHaloProjectile entity;
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
            this.lastEntityAppearTime = currentTime;
        }
        if (currentTime - this.lastEntityAppearTime >= 1600L) {
            this.lastEntityAppearTime = currentTime;
            this.cachedEntity = null;
            this.spawnCooldown = 0;
        }
        if ((entity = this.getOrCreateEntity()) != null) {
            int ticks;
            long delta = currentTime - this.lastEntityAppearTime;
            entity.field_6012 = ticks = (int)(delta / 50L);
            if (ticks >= 16) {
                this.cachedEntity = null;
                this.spawnCooldown = 400;
            }
        }
        this.lastUpdateTime = currentTime;
        if (this.spawnCooldown > 0) {
            --this.spawnCooldown;
        }
    }

    public void draw(@NotNull ShadeAltarRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        GeoEntityRenderer entityRenderer;
        RenderSystem.setShaderTexture((int)0, (class_2960)SHADOW);
        guiGraphics.method_25302(SHADOW, 21, 55, 0, 0, 39, 17);
        guiGraphics.method_25302(SHADOW, 33, 10, 46, 3, 33, 22);
        guiGraphics.method_25302(SHADOW, 9, 4, 120, 0, 19, 19);
        this.updateAnimation();
        ShadeMawAltarBlockEntity blockEntity = this.getOrCreateBlockEntity();
        ShadeAltarUpgradeHaloProjectile entity = this.getOrCreateEntity();
        GeoBlockRenderer blockRenderer = (GeoBlockRenderer)class_310.method_1551().method_31975().method_3550((class_2586)blockEntity);
        GeoEntityRenderer geoEntityRenderer = entityRenderer = entity != null ? (GeoEntityRenderer)class_310.method_1551().method_1561().method_3953((class_1297)entity) : null;
        if (blockRenderer == null) {
            return;
        }
        class_4587 pose = guiGraphics.method_51448();
        class_4597.class_4598 buffer = guiGraphics.method_51450();
        pose.method_22903();
        pose.method_46416(60.0f, 55.0f, 20.0f);
        pose.method_22905(24.0f, 24.0f, 24.0f);
        pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
        pose.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.method_23760().method_23762();
        Vector3f up = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            blockRenderer.method_3569((class_2586)blockEntity, partialTicks, pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15), class_4608.field_21444);
        }
        catch (Exception e) {
            blockRenderer.method_3569((class_2586)blockEntity, class_310.method_1551().method_1488(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15), class_4608.field_21444);
        }
        pose.method_22909();
        if (entity != null) {
            pose.method_22903();
            pose.method_22904(60.0, 63.0, 27.5);
            pose.method_22905(24.0f, 24.0f, 24.0f);
            pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
            pose.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
            pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            entityRenderer.method_3936((class_1297)entity, 0.0f, class_310.method_1551().method_1488(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
            pose.method_22909();
        }
        buffer.method_22993();
    }
}

