/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.common.entity.companion.PuppetGloveEntity;
import dev.xylonity.companions.common.recipe.EmptyPuppetRecipe;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsEntities;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public final class PuppetRecipeCategory
implements IRecipeCategory<EmptyPuppetRecipe> {
    public static final class_2960 UID = new class_2960("companions", "puppet_interaction");
    public static final RecipeType<EmptyPuppetRecipe> TYPE = new RecipeType(UID, EmptyPuppetRecipe.class);
    public static final class_2960 SHADOW = new class_2960("companions", "textures/gui/sprites.png");
    private final IDrawable icon;
    private PuppetGloveEntity cachedEntity;
    private PuppetEntity cachedEntity2;
    private long lastUpdateTime = 0L;

    public PuppetRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)CompanionsBlocks.EMPTY_PUPPET.get()));
    }

    @NotNull
    public RecipeType<EmptyPuppetRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.companions.puppet_interaction.title");
    }

    public int getHeight() {
        return 80;
    }

    public int getWidth() {
        return 160;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EmptyPuppetRecipe rec, @NotNull IFocusGroup focuses) {
        this.cachedEntity = null;
        this.cachedEntity2 = null;
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addItemStack(rec.input);
    }

    private PuppetGloveEntity getOrCreateEntity() {
        if (this.cachedEntity == null) {
            this.cachedEntity = new PuppetGloveEntity(CompanionsEntities.PUPPET_GLOVE, (class_1937)class_310.method_1551().field_1687);
            this.cachedEntity.method_5977(true);
        }
        return this.cachedEntity;
    }

    private PuppetEntity getOrCreateEntity2() {
        if (this.cachedEntity2 == null) {
            this.cachedEntity2 = new PuppetEntity(CompanionsEntities.PUPPET, (class_1937)class_310.method_1551().field_1687);
            this.cachedEntity2.method_5977(true);
        }
        return this.cachedEntity2;
    }

    private void updateAnimation() {
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        if (currentTime - this.lastUpdateTime >= 50L) {
            this.lastUpdateTime = currentTime;
        }
        if (this.cachedEntity != null) {
            this.cachedEntity.field_6012 = (int)(System.currentTimeMillis() / 50L);
        }
        if (this.cachedEntity2 != null) {
            this.cachedEntity2.field_6012 = (int)(System.currentTimeMillis() / 50L);
        }
    }

    public void draw(@NotNull EmptyPuppetRecipe recipe, @NotNull IRecipeSlotsView slots, @NotNull class_332 guiGraphics, double mouseX, double mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SHADOW);
        guiGraphics.method_25302(SHADOW, 19, 62, 216, 5, 38, 16);
        guiGraphics.method_25302(SHADOW, 26, 10, 62, 56, 19, 29);
        guiGraphics.method_25302(SHADOW, 60, 50, 81, 6, 39, 12);
        guiGraphics.method_25302(SHADOW, 4, 4, 120, 0, 19, 19);
        guiGraphics.method_25302(SHADOW, 110, 62, 216, 5, 38, 16);
        this.updateAnimation();
        PuppetGloveEntity dragon1 = this.getOrCreateEntity();
        PuppetEntity dragon2 = this.getOrCreateEntity2();
        GeoEntityRenderer dragonRenderer1 = (GeoEntityRenderer)class_310.method_1551().method_1561().method_3953((class_1297)dragon1);
        GeoEntityRenderer dragonRenderer2 = (GeoEntityRenderer)class_310.method_1551().method_1561().method_3953((class_1297)dragon2);
        class_4587 pose = guiGraphics.method_51448();
        class_4597.class_4598 buffer = guiGraphics.method_51450();
        pose.method_22903();
        pose.method_46416(40.0f, 68.0f, 20.0f);
        pose.method_22905(17.0f, 17.0f, 17.0f);
        pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
        pose.method_22907(class_7833.field_40716.rotationDegrees(38.0f));
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        Matrix3f normalMat = pose.method_23760().method_23762();
        Vector3f up = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat.transform(up).normalize();
        normalMat.transform(front).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up, (Vector3f)front);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            dragonRenderer1.method_3936((class_1297)dragon1, 0.0f, partialTicks, pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
        }
        catch (Exception e) {
            dragonRenderer1.method_3936((class_1297)dragon1, 0.0f, class_310.method_1551().method_1488(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
        }
        pose.method_22909();
        pose.method_22903();
        pose.method_46416(130.0f, 68.0f, 20.0f);
        pose.method_22905(18.0f, 18.0f, 18.0f);
        pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
        pose.method_22907(class_7833.field_40716.rotationDegrees(38.0f));
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        Matrix3f normalMat2 = pose.method_23760().method_23762();
        Vector3f up2 = new Vector3f(-1.0f, 10.0f, -1.0f);
        Vector3f front2 = new Vector3f(-1.0f, 3.0f, -1.0f);
        normalMat2.transform(up2).normalize();
        normalMat2.transform(front2).normalize();
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)up2, (Vector3f)front2);
        try {
            float partialTicks = (float)((double)(System.currentTimeMillis() - this.lastUpdateTime) / 50.0);
            dragonRenderer2.method_3936((class_1297)dragon2, 0.0f, partialTicks, pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
        }
        catch (Exception e) {
            dragonRenderer2.method_3936((class_1297)dragon2, 0.0f, class_310.method_1551().method_1488(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
        }
        pose.method_22909();
        buffer.method_22993();
    }
}

