/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.common.recipe.HourglassRecipe;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class AntlionRecipeCategory
implements IRecipeCategory<HourglassRecipe> {
    public static final class_2960 UID = new class_2960("companions", "antlion_interaction");
    public static final RecipeType<HourglassRecipe> TYPE = new RecipeType(UID, HourglassRecipe.class);
    public static final class_2960 SHADOW = new class_2960("companions", "textures/gui/sprites.png");
    private AntlionEntity cachedEntity;
    private final IDrawable icon;
    private int phaseCooldown;

    public AntlionRecipeCategory(IGuiHelper gui) {
        this.icon = gui.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)CompanionsItems.HOURGLASS.get()));
    }

    @NotNull
    public RecipeType<HourglassRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jei.companions.antlion_interaction.title");
    }

    public int getWidth() {
        return 120;
    }

    public int getHeight() {
        return 80;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HourglassRecipe rec, @NotNull IFocusGroup focuses) {
        this.cachedEntity = null;
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).addItemStack(rec.input);
    }

    private AntlionEntity getOrCreateEntity() {
        if (this.cachedEntity == null) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 != null) {
                this.cachedEntity = new AntlionEntity(CompanionsEntities.ANTLION, (class_1937)mc.field_1687);
                this.cachedEntity.method_5875(true);
                this.phaseCooldown = 600;
            }
        }
        return this.cachedEntity;
    }

    private void updateAnimation() {
        if (this.cachedEntity != null) {
            this.cachedEntity.field_6012 = (int)(System.currentTimeMillis() / 50L);
            if (this.phaseCooldown <= 0) {
                this.cachedEntity.cycleVariant();
                this.phaseCooldown = 600;
            }
        }
        if (this.phaseCooldown > 0) {
            --this.phaseCooldown;
        }
    }

    public void draw(@NotNull HourglassRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SHADOW);
        guiGraphics.method_25302(SHADOW, 40, 60, 216, 5, 38, 16);
        guiGraphics.method_25302(SHADOW, 33, 10, 46, 3, 33, 22);
        guiGraphics.method_25302(SHADOW, 9, 4, 120, 0, 19, 19);
        this.updateAnimation();
        AntlionEntity entity = this.getOrCreateEntity();
        GeoEntityRenderer entityRenderer = entity != null ? (GeoEntityRenderer)class_310.method_1551().method_1561().method_3953((class_1297)entity) : null;
        class_4587 pose = guiGraphics.method_51448();
        class_4597.class_4598 buffer = guiGraphics.method_51450();
        if (entity != null) {
            pose.method_22903();
            pose.method_22904(60.0, 68.0, 27.5);
            pose.method_22905(24.0f, 24.0f, 24.0f);
            pose.method_22907(class_7833.field_40714.rotationDegrees(-25.0f));
            pose.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
            pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            entityRenderer.method_3936((class_1297)entity, 0.0f, class_310.method_1551().method_1488(), pose, (class_4597)buffer, class_765.method_23687((int)15, (int)15));
            pose.method_22909();
        }
        buffer.method_22993();
    }
}

