/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.material;

import dev.xylonity.companions.config.CompanionsConfig;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.jetbrains.annotations.NotNull;

public enum ArmorMaterials implements class_1741
{
    MAGE("mage", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), () -> new ArmorStats(CompanionsConfig.MAGE_SET_STATS)),
    HOLY_ROBE("holy_robe", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), () -> new ArmorStats(CompanionsConfig.HOLY_ROBE_SET_STATS)),
    CRYSTALLIZED_BLOOD("crystallized_blood", () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), () -> new ArmorStats(CompanionsConfig.CRYSTALLIZED_BLOOD_SET_STATS));

    private final String name;
    private final Supplier<class_1856> repairIngredient;
    private final Supplier<ArmorStats> statsSupplier;
    private static final EnumMap<class_1738.class_8051, Integer> HEALTH_FUNCTION_FOR_TYPE;

    private ArmorMaterials(String name, Supplier<class_1856> repairIngredient, Supplier<ArmorStats> sup) {
        this.name = name;
        this.repairIngredient = repairIngredient;
        this.statsSupplier = sup;
    }

    private ArmorStats stats() {
        return this.statsSupplier.get();
    }

    public int method_48402(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_1738.class_8051 type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * (int)this.stats().durabilityMultiplier;
    }

    public int method_48403(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_1738.class_8051 type) {
        return ArmorMaterials.toProtectionMap(this.stats().prot).get(type);
    }

    public int method_7699() {
        return 20;
    }

    @NotNull
    public class_3414 method_7698() {
        return class_3417.field_15103;
    }

    @NotNull
    public class_1856 method_7695() {
        return this.repairIngredient.get();
    }

    @NotNull
    public String method_7694() {
        return "companions:" + this.name;
    }

    public float method_7700() {
        return (float)this.stats().toughness;
    }

    public float method_24355() {
        return (float)this.stats().knockbackResistance;
    }

    private static EnumMap<class_1738.class_8051, Integer> toProtectionMap(int[] prot) {
        EnumMap<class_1738.class_8051, Integer> map = new EnumMap<class_1738.class_8051, Integer>(class_1738.class_8051.class);
        map.put(class_1738.class_8051.field_41934, prot[0]);
        map.put(class_1738.class_8051.field_41935, prot[1]);
        map.put(class_1738.class_8051.field_41936, prot[2]);
        map.put(class_1738.class_8051.field_41937, prot[3]);
        return map;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)class_156.method_654(new EnumMap(class_1738.class_8051.class), m -> {
            m.put(class_1738.class_8051.field_41937, 13);
            m.put(class_1738.class_8051.field_41936, 15);
            m.put(class_1738.class_8051.field_41935, 16);
            m.put(class_1738.class_8051.field_41934, 11);
        });
    }

    private static class ArmorStats {
        final int[] prot;
        final double toughness;
        final double knockbackResistance;
        final double durabilityMultiplier;

        ArmorStats(String s) {
            String[] parts = s.trim().split("\\s*,\\s*");
            if (parts.length != 7) {
                throw new IllegalArgumentException("[Companions!] Invalid armor stats format! Expected 7 values for " + s);
            }
            this.prot = new int[]{ArmorStats.parse(parts[0]), ArmorStats.parse(parts[1]), ArmorStats.parse(parts[2]), ArmorStats.parse(parts[3])};
            this.toughness = Double.parseDouble(parts[4]);
            this.knockbackResistance = Double.parseDouble(parts[5]);
            this.durabilityMultiplier = Double.parseDouble(parts[6]);
        }

        private static int parse(String s) {
            return Integer.parseInt(s.trim());
        }
    }
}

