/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item.book.books;

import dev.xylonity.companions.common.entity.projectile.StoneSpikeProjectile;
import dev.xylonity.companions.common.item.book.AbstractMagicBook;
import dev.xylonity.companions.common.material.ArmorMaterials;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.function.BiPredicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class StoneSpikesBook
extends AbstractMagicBook {
    public StoneSpikesBook(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    protected String tooltipName() {
        return "stone_spikes_book";
    }

    @Override
    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 usedHand) {
        double yaw = Math.toRadians(player.field_5982);
        class_243 baseDir = new class_243(-Math.sin(yaw), 0.0, Math.cos(yaw)).method_1029();
        int spikes = 10;
        this.spawnSpikeRow(baseDir, spikes, player);
        this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, -30.0), (int)((double)spikes * 0.3), player);
        this.spawnSpikeRow(Util.rotateHorizontalDirection(baseDir, 30.0), (int)((double)spikes * 0.3), player);
        if (!level.field_9236) {
            player.method_7357().method_7906((class_1792)this, (int)((double)CompanionsConfig.STONE_SPIKES_COOLDOWN * (1.0 - (double)Util.hasFullSetOn(player, ArmorMaterials.MAGE) * CompanionsConfig.MAGE_SET_COOLDOWN_REDUCTION)));
        }
        return super.method_7836(level, player, usedHand);
    }

    @Override
    protected void playSound(class_1657 player) {
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15119, player.method_5634(), 1.0f, 1.0f);
    }

    private void spawnSpikeRow(class_243 direction, int count, class_1657 player) {
        for (int i = 0; i < count; ++i) {
            class_243 line = player.method_19538().method_1019(direction.method_1021(1.5 + (double)i * 1.5));
            int ix = class_3532.method_15357((double)line.field_1352);
            int iz = class_3532.method_15357((double)line.field_1350);
            int iy = class_3532.method_15357((double)line.field_1351);
            StoneSpikeProjectile spike = (StoneSpikeProjectile)CompanionsEntities.STONE_SPIKE_PROJECTILE.method_5883(player.method_37908());
            if (spike == null) continue;
            spike.method_5808((double)ix + 0.5, this.findSpikeH(player.method_37908(), ix, iy, iz, Math.toRadians(player.method_36455()) < 0.0) + 1, (double)iz + 0.5, player.method_36454(), 0.0f);
            spike.method_7432((class_1297)player);
            if (i == 0) {
                player.method_37908().method_8649((class_1297)spike);
                continue;
            }
            TickScheduler.scheduleBoth((class_1937)player.method_37908(), () -> player.method_37908().method_8649((class_1297)spike), (int)(i * 2));
        }
    }

    private int findSpikeH(class_1937 level, int x, int yStart, int z, boolean shouldCheckUp) {
        BiPredicate<class_1937, class_2338> solid = (level1, pos) -> !level1.method_8320(pos).method_26220((class_1922)level1, pos).method_1110();
        if (shouldCheckUp) {
            class_2338 pos2;
            int y;
            for (y = yStart; y <= level.method_31600(); ++y) {
                pos2 = new class_2338(x, y, z);
                if (!solid.test(level, pos2)) continue;
                return y;
            }
            for (y = yStart; y >= level.method_31607(); --y) {
                pos2 = new class_2338(x, y, z);
                if (!solid.test(level, pos2)) continue;
                return y;
            }
        } else {
            class_2338 pos3;
            int y;
            for (y = yStart; y >= level.method_31607(); --y) {
                pos3 = new class_2338(x, y, z);
                if (!solid.test(level, pos3)) continue;
                return y;
            }
            for (y = yStart; y <= level.method_31600(); ++y) {
                pos3 = new class_2338(x, y, z);
                if (!solid.test(level, pos3)) continue;
                return y;
            }
        }
        return yStart;
    }
}

