/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class BraceProjectile
extends BaseProjectile {
    private static final double BOUNCE_DAMPING_VERTICAL = 0.6;
    private static final double BOUNCE_DAMPING_HORIZONTAL = 0.7;
    private static final int MAX_BOUNCES = 5;
    private static final double MIN_UPWARD = 0.4;
    private final List<Integer> hitEntities = new ArrayList<Integer>();
    private int entityBounces = 0;
    private int blockBounces = 0;

    public BraceProjectile(class_1299<? extends BaseProjectile> type, class_1937 level) {
        super(type, level);
        this.field_5960 = false;
    }

    @Override
    public void method_5773() {
        double blockDist;
        super.method_5773();
        if (this.field_6012 > this.getLifetime() || this.entityBounces >= 5) {
            if (!this.method_37908().field_9236) {
                this.method_37908().method_8421((class_1297)this, (byte)3);
            }
            this.method_5650(class_1297.class_5529.field_26999);
        }
        class_243 vel = this.method_18798().method_1031(0.0, -0.03, 0.0).method_1021(0.98);
        class_243 start = this.method_19538();
        class_243 end = start.method_1019(vel);
        class_239 entityHit = class_1675.method_49997((class_1297)this, this::method_26958);
        class_3965 blockHit = this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        double entityDist = entityHit.method_17783() == class_239.class_240.field_1331 ? entityHit.method_17784().method_1025(start) : Double.MAX_VALUE;
        double d = blockDist = blockHit.method_17783() != class_239.class_240.field_1333 ? blockHit.method_17784().method_1025(start) : Double.MAX_VALUE;
        if (entityDist < blockDist) {
            this.handleEntityHit((class_3966)entityHit);
        } else if (blockDist < Double.MAX_VALUE) {
            this.handleBlockHit(blockHit);
        } else {
            this.move(vel);
        }
        if (this.field_6012 % 3 == 0) {
            this.method_37908().method_8406((class_2394)CompanionsParticles.EMBER.get(), this.method_23317(), this.method_23318() - (double)this.method_17682() * 0.5, this.method_23321(), 0.0, 0.0, 0.0);
        }
        if (this.method_37908().field_9236 && (this.field_6012 % 50 == 0 || this.field_6012 == 1)) {
            float r = 0.98039216f;
            float g = (float)(203 + this.method_37908().field_9229.method_43048(10)) / 255.0f;
            float b = (float)(138 + this.method_37908().field_9229.method_43048(10)) / 255.0f;
            Companions.PROXY.spawnGenericRibbonTrail((class_1297)this, this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), r, g, b, 0.0f, 0.35f);
        }
    }

    private void handleEntityHit(class_3966 hit) {
        class_1309 target;
        class_1297 entity = hit.method_17782();
        if (!(entity instanceof class_1309) || Util.areEntitiesLinked((class_1297)(target = (class_1309)entity), (class_1297)this) || this.hitEntities.contains(entity.method_5628())) {
            this.move(this.method_18798());
            return;
        }
        target.method_5643(this.method_48923().method_48811((class_1297)this, this.method_24921()), (float)CompanionsConfig.BRACE_PROJECTILE_DAMAGE);
        target.method_5639(this.field_5974.method_43051(1, 10));
        this.hitEntities.add(target.method_5628());
        ++this.entityBounces;
        this.method_33574(hit.method_17784());
        class_243 bouncePos = new class_243(target.method_23317(), target.method_23320(), target.method_23321());
        this.method_33574(bouncePos);
        this.method_18799(class_243.field_1353);
        if (this.entityBounces >= 5) {
            this.spawnParticles();
            this.method_31472();
            return;
        }
        class_1309 next = this.findNextTarget();
        if (next == null) {
            this.spawnParticles();
            this.method_31472();
            return;
        }
        class_243 direction = next.method_19538().method_1031(0.0, (double)next.method_17682() * 0.5, 0.0).method_1020(this.method_19538()).method_1029();
        if (direction.field_1351 < 0.4) {
            direction = new class_243(direction.field_1352, 0.4, direction.field_1350).method_1029();
        }
        this.method_18799(direction.method_1021(0.6));
    }

    private void handleBlockHit(class_3965 hit) {
        class_2350 face = hit.method_17780();
        class_243 normal = new class_243((double)face.method_10148(), (double)face.method_10164(), (double)face.method_10165());
        class_243 reflected = this.method_18798().method_1020(normal.method_1021(2.0 * this.method_18798().method_1026(normal)));
        reflected = face.method_10166().method_10178() ? new class_243(reflected.field_1352, reflected.field_1351 * 0.6, reflected.field_1350) : new class_243(reflected.field_1352 * 0.7, reflected.field_1351, reflected.field_1350 * 0.7);
        ++this.blockBounces;
        if (this.blockBounces >= 5) {
            reflected = class_243.field_1353;
        }
        this.method_33574(hit.method_17784().method_1019(normal.method_1021(0.02)));
        this.move(reflected);
    }

    private void spawnSmokeParticles() {
        for (int i = 0; i < 6; ++i) {
            double speedX = (this.field_5974.method_43058() - 0.5) * 0.1;
            double speedY = (this.field_5974.method_43058() - 0.5) * 0.1;
            double speedZ = (this.field_5974.method_43058() - 0.5) * 0.1;
            this.method_37908().method_8406((class_2394)CompanionsParticles.EMBER.get(), this.method_23317(), this.method_23318(), this.method_23321(), speedX, speedY, speedZ);
        }
    }

    public void method_5711(byte pId) {
        if (pId == 3) {
            this.spawnSmokeParticles();
        } else {
            super.method_5711(pId);
        }
    }

    private void spawnParticles() {
        if (!this.method_37908().field_9236) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            float speed = 0.1f;
            this.method_37908().method_8406((class_2394)CompanionsParticles.EMBER.get(), this.method_23317(), this.method_23318(), this.method_23321(), (this.field_5974.method_43058() - 0.5) * (double)speed, (this.field_5974.method_43058() - 0.5) * (double)speed, (this.field_5974.method_43058() - 0.5) * (double)speed);
        }
    }

    private class_1309 findNextTarget() {
        return this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(10.0), e -> e.method_5805() && !Util.areEntitiesLinked((class_1297)this, (class_1297)e) && !this.hitEntities.contains(e.method_5628())).stream().min(Comparator.comparingDouble(e -> e.method_5858((class_1297)this))).orElse(null);
    }

    private void move(class_243 vel) {
        if (this.method_24828() && Math.abs(vel.field_1351) < 0.001 && vel.method_37268() < 9.0E-4) {
            vel = class_243.field_1353;
        }
        this.method_18799(vel);
        this.method_5784(class_1313.field_6308, vel);
    }

    protected boolean method_26958(@NotNull class_1297 e) {
        if (Util.areEntitiesLinked((class_1297)this, e)) {
            return false;
        }
        if (e == this.method_24921() || e == this) {
            return false;
        }
        if (this.hitEntities.contains(e.method_5628())) {
            return false;
        }
        return e instanceof class_1309;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
    }

    public void method_5694(@NotNull class_1657 player) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }

    @NotNull
    public class_2596<class_2602> method_18002() {
        return super.method_18002();
    }
}

