/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BlackHoleProjectile
extends BaseProjectile {
    private static final RawAnimation DISAPPEAR = RawAnimation.begin().thenPlay("disappear");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final class_2940<Boolean> IS_LOCKED = class_2945.method_12791(BlackHoleProjectile.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> TICKCOUNT = class_2945.method_12791(BlackHoleProjectile.class, (class_2941)class_2943.field_13327);
    private static final double ATTRACT_RADIUS = CompanionsConfig.BLACK_HOLE_ATTRACTION_RADIUS;
    private static final float GRAVITY = 0.03f;

    public BlackHoleProjectile(class_1299<? extends BaseProjectile> type, class_1937 level) {
        super(type, level);
        this.field_5960 = false;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_LOCKED, (Object)false);
        this.field_6011.method_12784(TICKCOUNT, (Object)0);
    }

    public boolean isLocked() {
        return (Boolean)this.field_6011.method_12789(IS_LOCKED);
    }

    public void setLocked(boolean locked) {
        this.field_6011.method_12778(IS_LOCKED, (Object)locked);
    }

    public int getTickCount() {
        return (Integer)this.field_6011.method_12789(TICKCOUNT);
    }

    public void setTickCount(int tickCount) {
        this.field_6011.method_12778(TICKCOUNT, (Object)tickCount);
    }

    private void updateRotation(class_243 vel) {
        double horizontalMag = vel.method_37267();
        float newYaw = (float)(class_3532.method_15349((double)vel.field_1352, (double)vel.field_1350) * 57.29577951308232);
        float newPitch = (float)(class_3532.method_15349((double)vel.field_1351, (double)horizontalMag) * 57.29577951308232);
        this.method_36456(BlackHoleProjectile.method_26960((float)this.method_36454(), (float)newYaw));
        this.method_36457(BlackHoleProjectile.method_26960((float)this.method_36455(), (float)newPitch));
    }

    @Override
    public void method_5773() {
        if (!this.method_37908().field_9236) {
            this.setTickCount(this.field_6012);
        }
        super.method_5773();
        if (this.getTickCount() == 20) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), CompanionsSounds.SPELL_RELEASE_SPEARS.get(), this.method_5634(), 1.5f, 1.0f);
        }
        Random random = new Random();
        if ((double)random.nextFloat() < 0.44 && this.getTickCount() < this.getLifetime() - 20) {
            for (int i = 0; i < 1; ++i) {
                class_1937 class_19372 = this.method_37908();
                if (!(class_19372 instanceof class_3218)) continue;
                class_3218 level = (class_3218)class_19372;
                double x = (Math.random() - 0.5) * 0.5;
                double z = (Math.random() - 0.5) * 0.5;
                level.method_14199((class_2394)CompanionsParticles.BLACK_HOLE_STAR.get(), this.method_23317() + x, this.method_23318() - 0.2, this.method_23321() + z, 1, (Math.random() - 0.5) * 0.1, 0.0, (Math.random() - 0.5) * 0.1, 0.2);
            }
        }
        if (this.getTickCount() >= this.getLifetime()) {
            this.method_31472();
            return;
        }
        if (this.isLocked()) {
            if (this.method_37908().field_9236) {
                for (class_1657 player : this.method_37908().method_18467(class_1657.class, this.method_5829().method_1014(30.0))) {
                    Companions.PROXY.shakePlayerCamera(player, 5, 0.1f, 0.1f, 0.1f, 10);
                }
            }
            this.method_18799(class_243.field_1353);
            this.attractNearbyEntities();
            return;
        }
        if (!this.method_37908().field_9236 && this.field_6012 >= 20 && !this.isLocked()) {
            this.setLocked(true);
        }
        class_243 oldPos = this.method_19538();
        class_243 vel = this.method_18798();
        if (!this.field_5960) {
            vel = vel.method_1031(0.0, (double)-0.03f, 0.0);
        }
        vel = vel.method_1021(0.99);
        class_3965 blockHit = this.method_37908().method_17742(new class_3959(oldPos, oldPos.method_1019(vel), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (blockHit.method_17783() == class_239.class_240.field_1332) {
            class_243 hitPos = blockHit.method_17784();
            this.method_5814(hitPos.field_1352, hitPos.field_1351, hitPos.field_1350);
            this.method_18799(class_243.field_1353);
            this.setLocked(true);
        } else {
            this.method_18799(vel);
            this.method_5784(class_1313.field_6308, vel);
            this.updateRotation(vel);
            if (this.method_24828()) {
                this.setLocked(true);
                this.method_18799(class_243.field_1353);
            }
        }
        this.attractNearbyEntities();
    }

    private void attractNearbyEntities() {
        List nearby = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(ATTRACT_RADIUS), e -> !Util.areEntitiesLinked((class_1297)e, (class_1297)this));
        for (class_1309 ent : nearby) {
            class_243 toCenter = new class_243(this.method_23317() - ent.method_23317(), this.method_23318() - ent.method_23318(), this.method_23321() - ent.method_23321());
            double distance = toCenter.method_1033();
            if (distance < 0.05) continue;
            toCenter = toCenter.method_1029();
            double linear = (ATTRACT_RADIUS - distance) / ATTRACT_RADIUS;
            if (linear < 0.0) {
                linear = 0.0;
            }
            class_243 desiredVel = toCenter.method_1021(Math.pow(linear, 2.0) * CompanionsConfig.BLACK_HOLE_ATTRACTION_SPEED);
            class_243 currentVel = ent.method_18798();
            class_243 newVel = currentVel.method_35590(desiredVel, 0.15);
            ent.method_18799(newVel);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "extraController", this::extraPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    @Override
    protected int baseLifetime() {
        return 100;
    }

    private <T extends GeoAnimatable> PlayState extraPredicate(AnimationState<T> event) {
        if (this.getTickCount() >= this.getLifetime() - 7) {
            event.getController().setAnimation(DISAPPEAR);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }
}

