/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionBaseAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionBaseLongAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.wild.goal.WildAntlionNearestAttackableTarget;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.mixin.FallingBlockEntityAccessor;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1379;
import net.minecraft.class_1408;
import net.minecraft.class_1540;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6026;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class WildAntlionEntity
extends HostileEntity
implements class_6026 {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation DIG_IN = RawAnimation.begin().thenPlay("dig");
    private final RawAnimation DIG_OUT = RawAnimation.begin().thenPlay("dig_out");
    private final RawAnimation DIG_IDLE = RawAnimation.begin().thenPlay("dig_idle");
    private final RawAnimation DIG_ATTACK = RawAnimation.begin().thenPlay("dig_attack");
    private final RawAnimation DIG_SHOOT = RawAnimation.begin().thenPlay("dig_attack2");
    private static final class_2940<Integer> ATTACK_TYPE = class_2945.method_12791(WildAntlionEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> STATE = class_2945.method_12791(WildAntlionEntity.class, (class_2941)class_2943.field_13327);
    private static final int ANIMATION_BASE_DIG_IN_TICKS = 55;
    private static final int ANIMATION_BASE_DIG_OUT_TICKS = 15;
    private static final int NO_TARGET_MAX_TICKS = 20;
    private int diginCounter = -1;
    private int digoutCounter = -1;
    private int noTargetCounter = -1;

    public WildAntlionEntity(class_1299<? extends class_1588> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.setNoMovement(this.isUnderground() || this.getState() == 1);
            if (this.getState() == 1 && this.diginCounter == -1) {
                ++this.diginCounter;
            }
            if (this.getState() == 2 && this.noTargetCounter == -1 && this.method_5968() == null) {
                ++this.noTargetCounter;
            } else if (this.getState() == 2 && this.noTargetCounter == -1 && this.method_5968() == null) {
                this.noTargetCounter = -1;
            }
            if (this.diginCounter != -1) {
                ++this.diginCounter;
            }
            if (this.digoutCounter != -1) {
                ++this.digoutCounter;
            }
            if (this.noTargetCounter != -1) {
                ++this.noTargetCounter;
            }
            if (this.diginCounter == 55) {
                this.cycleState();
                this.diginCounter = -1;
            }
            if (this.noTargetCounter == 20) {
                this.cycleState();
                this.noTargetCounter = -1;
                ++this.digoutCounter;
            }
            if (this.digoutCounter == 15) {
                this.cycleState();
                this.digoutCounter = -1;
            }
            if (this.diginCounter == 20 || this.diginCounter == 35 || this.digoutCounter == 5) {
                this.earthquake();
            }
        }
    }

    private void earthquake() {
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist < 1 || dist > radius) continue;
                class_2338 blockPos = this.method_24515().method_10069(x, -1, z);
                class_2680 state = this.method_37908().method_8320(blockPos);
                if (state.method_26215() || state.method_26204() == class_2246.field_9987) continue;
                if (dist == 1) {
                    this.spawnFallingBlock(blockPos, state, 0.18);
                    continue;
                }
                TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.spawnFallingBlock(blockPos, state, 0.2), (int)5);
            }
        }
    }

    private void spawnFallingBlock(class_2338 pos, class_2680 state, double yDelay) {
        class_1540 block = FallingBlockEntityAccessor._new(this.method_37908(), (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, state);
        block.method_18800(0.0, yDelay, 0.0);
        this.method_37908().method_8649((class_1297)block);
        this.method_37908().method_8650(pos, false);
    }

    public void cycleState() {
        switch (this.getState()) {
            case 0: {
                this.setState(1);
                break;
            }
            case 1: {
                this.setState(2);
                break;
            }
            case 2: {
                this.setState(3);
                break;
            }
            case 3: {
                this.setState(0);
            }
        }
    }

    public void setState(int state) {
        this.field_6011.method_12778(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.field_6011.method_12789(STATE);
    }

    public boolean isUnderground() {
        return this.getState() == 2;
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 pLevel) {
        return new GroundNavigator((class_1308)this, pLevel);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new WildAntlionBaseAttackGoal(this, 20, 60));
        this.field_6201.method_6277(1, (class_1352)new WildAntlionBaseLongAttackGoal(this, 20, 60));
        this.field_6201.method_6277(2, (class_1352)new class_1379((class_1314)this, 0.43));
        this.field_6185.method_6277(1, new WildAntlionNearestAttackableTarget<class_1657>(this, class_1657.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return HostileEntity.method_26828().method_26868(class_5134.field_23716, 50.0).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23717, 35.0);
    }

    public int getAttackType() {
        return (Integer)this.field_6011.method_12789(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.field_6011.method_12778(ATTACK_TYPE, (Object)type);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACK_TYPE, (Object)0);
        this.field_6011.method_12784(STATE, (Object)0);
    }

    public void method_5784(@NotNull class_1313 pType, @NotNull class_243 pPos) {
        super.method_5784(pType, pPos);
        this.method_5852();
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        if (!this.isEntityInFront((class_1297)player) && player.method_5998(hand).method_7909() == CompanionsItems.CRYSTALLIZED_BLOOD.get()) {
            if (this.method_37908().field_9236) {
                return class_1269.field_5812;
            }
            if (this.tameAntlion(player)) {
                this.tameParticles();
                this.method_31472();
            } else {
                this.failureParticles();
            }
        }
        return super.method_5992(player, hand);
    }

    @Nullable
    protected class_3414 method_6002() {
        return CompanionsSounds.ANTLION_DEATH.get();
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 pDamageSource) {
        return CompanionsSounds.ANTLION_HURT.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return CompanionsSounds.ANTLION_IDLE.get();
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        this.method_43077(CompanionsSounds.ANTLION_STEPS.get());
    }

    protected boolean isEntityInFront(class_1297 target) {
        class_243 toTarget = new class_243(target.method_23317(), this.method_23318(), target.method_23321()).method_1020(this.method_19538()).method_1029();
        double angle = Math.acos(this.method_5720().method_1029().method_1026(toTarget)) * 57.29577951308232;
        return angle < 100.0;
    }

    private boolean tameAntlion(class_1657 player) {
        if (this.method_37908().field_9229.method_43057() < 0.55f) {
            AntlionEntity antlion = (AntlionEntity)CompanionsEntities.ANTLION.method_5883(this.method_37908());
            if (antlion != null) {
                antlion.method_29495(this.method_19538());
                antlion.tameInteraction(player);
                this.method_37908().method_8649((class_1297)antlion);
            }
            return true;
        }
        return false;
    }

    private void tameParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            if (level.field_9229.method_43057() < 0.65f) {
                level.method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.1);
            }
            if (!(level.field_9229.method_43057() < 0.25f)) continue;
            level.method_14199((class_2394)((class_2400)KnightLibParticles.STARSET.get()), this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.2);
        }
    }

    private void failureParticles() {
        for (int i = 0; i < 20; ++i) {
            double dx = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dy = (this.field_5974.method_43058() - 0.5) * 2.0;
            double dz = (this.field_5974.method_43058() - 0.5) * 2.0;
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 level = (class_3218)class_19372;
            if (!(level.field_9229.method_43057() < 0.65f)) continue;
            level.method_14199((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.025);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getAttackType() == 1) {
            event.getController().setAnimation(this.DIG_ATTACK);
        } else if (this.getAttackType() == 2) {
            event.getController().setAnimation(this.DIG_SHOOT);
        } else if (this.getState() == 1) {
            event.getController().setAnimation(this.DIG_IN);
        } else if (this.getState() == 2) {
            event.getController().setAnimation(this.DIG_IDLE);
        } else if (this.getState() == 3) {
            event.getController().setAnimation(this.DIG_OUT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

