/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1316;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1403;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ShadeMawEntity
extends ShadeEntity
implements class_1316 {
    private final RawAnimation SPAWN = RawAnimation.begin().thenPlay("spawn");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation RUN = RawAnimation.begin().thenPlay("run");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation BITE = RawAnimation.begin().thenPlay("bite");
    private final RawAnimation SWIM = RawAnimation.begin().thenPlay("swim");
    private static final int ANIMATION_SPAWN_MAX_TICKS = 130;
    private static final float WALK_THETA = 0.02f;
    private static final float RUN_THETA = 0.375f;
    private static final float ACCEL = 0.02f;
    private static final float LIQUID_DRAG = 0.9f;
    private float throttle = 0.0f;
    private boolean canJump = true;
    private int jumpCharge = 0;
    private boolean hasSpawned = false;

    public ShadeMawEntity(class_1299<? extends CompanionEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.field_5985 = true;
        this.method_49477(1.1f);
        this.method_5857(this.method_33332());
    }

    @Override
    public int getMaxLifetime() {
        return CompanionsConfig.SHADOW_MAW_LIFETIME;
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 pLevel) {
        return new GroundNavigator((class_1308)this, pLevel);
    }

    @NotNull
    public class_238 method_33332() {
        float hw = (float)((double)this.method_17681() * 0.8 / 2.0);
        return new class_238(this.method_23317() - (double)hw, this.method_23318(), this.method_23321() - (double)hw, this.method_23317() + (double)hw, this.method_23318() + (double)this.method_17682(), this.method_23321() + (double)hw);
    }

    public float method_5871() {
        return (float)(((double)this.method_17681() - (double)this.method_17681() * 0.8) * 0.5);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new CompanionFollowOwnerGoal(this, 0.6, 10.0f, 4.0f, false){

            @Override
            public boolean method_6264() {
                return super.method_6264() && !ShadeMawEntity.this.isSpawning();
            }
        });
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new CompanionsHurtTargetGoal(this));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, CompanionsConfig.SHADOW_MAW_MAX_LIFE).method_26868(class_5134.field_23721, CompanionsConfig.SHADOW_MAW_DAMAGE).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.45f).method_26868(class_5134.field_23717, 35.0);
    }

    protected void method_6013(@NotNull class_1282 pSource) {
        this.method_43077(CompanionsSounds.SHADE_HURT.get());
    }

    @Nullable
    protected class_3414 method_5994() {
        return CompanionsSounds.SHADE_IDLE.get();
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        if (this.method_18798().method_37268() > 0.140625) {
            if (this.field_6012 % 5 == 0) {
                this.method_5783(CompanionsSounds.SHADE_STEP.get(), 2.0f, 1.0f);
            }
        } else {
            this.method_5783(CompanionsSounds.SHADE_STEP.get(), 2.0f, 1.0f);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.method_5855(this.method_5748());
        if (this.method_37908().field_9236) {
            Companions.PROXY.tickShadeMaw(this);
        }
        if (!this.hasSpawned && this.isSpawning()) {
            TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setIsSpawning(false), (int)130);
            TickScheduler.scheduleBoth((class_1937)this.method_37908(), () -> ((ShadeMawEntity)this).method_18382(), (int)110);
            TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.method_5648(false), (int)5);
            this.hasSpawned = true;
        }
        if (this.field_6012 % 6 == 0 && !this.isSpawning()) {
            double dx = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
            double dy = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
            double dz = (this.field_5974.method_43058() - 0.5) * (double)this.method_17681();
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 level = (class_3218)class_19372;
                level.method_14199((class_2394)CompanionsParticles.SHADE_TRAIL.get(), this.method_23317(), this.method_23318() + (double)this.method_17682() * Math.random(), this.method_23321(), 1, dx, dy, dz, 0.1);
            }
        }
        this.setLifetime(this.getLifetime() - 1);
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 class_12972;
        if (!this.method_5987() && (class_12972 = this.method_31483()) instanceof class_1309) {
            class_1309 e = (class_1309)class_12972;
            return e;
        }
        return null;
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_30949(@NotNull class_1297 pEntity) {
        if (pEntity == this.method_31483()) {
            return false;
        }
        if (pEntity instanceof class_1657) {
            class_1657 player = (class_1657)pEntity;
            return player.equals((Object)this.method_35057());
        }
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5863() {
        return true;
    }

    public void method_6091(@NotNull class_243 travelVec) {
        class_1309 rider = this.method_5642();
        if (rider == null && !this.method_37908().method_8316(this.method_24515()).method_15769()) {
            this.method_18799(this.method_18798().method_1021(0.8));
            this.method_5796(true);
            super.method_6091(class_243.field_1353);
            return;
        }
        if (this.method_5782() && rider != null && !this.isSpawning()) {
            this.method_36456(rider.method_36454());
            this.field_6283 = this.field_5982 = this.method_36454();
            float strafe = rider.field_6212 * 0.5f;
            float forward = rider.field_6250;
            if (forward < 0.0f) {
                forward *= 0.25f;
            }
            this.throttle = Math.abs(forward) > 0.001f || Math.abs(strafe) > 0.001f ? class_3532.method_15363((float)(this.throttle + 0.02f), (float)0.0f, (float)1.0f) : class_3532.method_15363((float)(this.throttle - 0.03f), (float)0.0f, (float)1.0f);
            if (this.field_5976 && !this.isInAnyFluid()) {
                this.throttle = 0.3525f;
                this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            }
            if (this.isInAnyFluid()) {
                double len;
                float speed = (float)this.method_26825(class_5134.field_23719) * (0.6f + 0.2f * this.throttle);
                class_243 lookDir = rider.method_5720().method_1029();
                class_243 motion = lookDir.method_1021((double)(speed * forward));
                if (Math.abs(strafe) > 0.001f) {
                    motion = motion.method_1019(new class_243(0.0, 1.0, 0.0).method_1036(lookDir).method_1029().method_1021((double)(speed * strafe)));
                }
                if (this.isOnLiquidSurface() && forward > 0.05f) {
                    class_243 fHoriz = new class_243(lookDir.field_1352, 0.0, lookDir.field_1350).method_1029();
                    class_2338 inFront = class_2338.method_49637((double)(this.method_23317() + fHoriz.field_1352 * 0.8), (double)(this.method_23318() + 0.2), (double)(this.method_23321() + fHoriz.field_1350 * 0.8));
                    motion = this.method_37908().method_8316(inFront).method_15769() ? motion.method_1031(0.0, 0.26, 0.0).method_1019(fHoriz.method_1021(0.05)) : motion.method_1031(0.0, 0.03, 0.0);
                }
                if (this.field_5976) {
                    double upAmount = this.isOnLiquidSurface() ? Math.max(0.22, (double)speed * 0.35) : Math.max(0.12, (double)speed * 0.25);
                    class_243 right = new class_243(0.0, 1.0, 0.0).method_1036(lookDir).method_1029();
                    motion = motion.method_1031(0.0, upAmount, 0.0).method_1019(right.method_1021((double)(speed * 0.2f * (float)(strafe >= 0.0f ? 1 : -1))));
                }
                if ((len = motion.method_1033()) > 0.9) {
                    motion = motion.method_1021(0.9 / len);
                }
                this.method_36457((float)(-Math.toDegrees(Math.atan2(motion.field_1351, Math.sqrt(motion.field_1352 * motion.field_1352 + motion.field_1350 * motion.field_1350)))));
                this.method_5784(class_1313.field_6308, motion);
                this.method_18799(this.method_18798().method_1021((double)0.9f));
                this.method_5796(true);
            } else {
                this.method_6125((float)this.method_26825(class_5134.field_23719) * this.throttle);
                super.method_6091(new class_243((double)strafe, travelVec.field_1351, (double)Math.signum(forward)));
            }
            return;
        }
        super.method_6091(travelVec);
    }

    protected void method_49481(@NotNull class_1657 rider, @NotNull class_243 travelVector) {
        super.method_49481(rider, travelVector);
        if (rider.method_6112(class_1294.field_5918) == null) {
            rider.method_6092(new class_1293(class_1294.field_5918, 10, 0, false, false));
        }
        if (this.isInAnyFluid()) {
            rider.method_18380(class_4050.field_18079);
        }
        if (rider.method_5799()) {
            rider.method_5855(rider.method_5748());
        }
        if (rider.method_5771()) {
            rider.method_46395();
            rider.method_5646();
        }
        if (!this.method_37908().field_9236 && rider.field_6252 && rider.method_6047().method_7960()) {
            this.doAttack();
            rider.field_6252 = false;
        }
        if (this.jumpCharge > 0 && this.canJump && this.method_24828()) {
            double yStr;
            if (this.isOnLiquidSurface()) {
                yStr = 0.5;
            } else if (this.method_24828()) {
                yStr = 0.25 + 0.008 * (double)this.jumpCharge;
            } else {
                return;
            }
            this.method_18800(this.method_18798().field_1352, yStr, this.method_18798().field_1350);
            this.field_6007 = true;
            this.jumpCharge = 0;
        }
    }

    private void doAttack() {
        if (this.getAttackType() != 1) {
            this.setAttackType(1);
            TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> this.setAttackType(0), (int)12);
            TickScheduler.scheduleServer((class_1937)this.method_37908(), () -> {
                for (class_1297 e : this.method_37908().method_18467(class_1297.class, new class_238(this.method_24515()).method_1014(3.0))) {
                    class_1309 livingEntity;
                    if (!(e instanceof class_1309) || !this.method_6057((class_1297)(livingEntity = (class_1309)e)) || !ShadeMawEntity.isEntityInFront((class_1309)this, (class_1297)livingEntity, 150.0) || livingEntity == this) continue;
                    this.method_6121((class_1297)livingEntity);
                    livingEntity.method_6005(0.5, this.method_23317() - livingEntity.method_23317(), this.method_23321() - livingEntity.method_23321());
                }
            }, (int)10);
            this.method_5783(CompanionsSounds.SHADE_MAW_BITE.get(), 0.3325f, 1.0f);
        }
    }

    public static boolean isEntityInFront(class_1309 viewer, class_1297 target, double fov) {
        class_243 toTarget;
        class_243 view = viewer.method_5720().method_1029();
        double angle = Math.acos(view.method_1026(toTarget = target.method_19538().method_1031(0.0, (double)target.method_5751() * 0.5, 0.0).method_1020(viewer.method_5836(1.0f)).method_1029())) * 57.29577951308232;
        return angle < fov / 2.0;
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        if (!player.method_21823() && !player.method_5715() && this.method_35057() != null && player.equals((Object)this.method_35057())) {
            if (!this.method_37908().field_9236 && !this.isSpawning()) {
                player.method_5873((class_1297)this, true);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    protected void method_5865(@NotNull class_1297 pPassenger, @NotNull class_1297.class_4738 pCallback) {
        if (this.method_5626(pPassenger)) {
            double baseY = this.method_23318() + this.method_5621() + pPassenger.method_5678();
            if (this.isInAnyFluid()) {
                baseY -= 1.35;
            }
            pCallback.accept(pPassenger, this.method_23317(), baseY + 0.5, this.method_23321());
        }
    }

    public void method_6154(int strength) {
        if (strength > 0) {
            this.jumpCharge = class_3532.method_15340((int)strength, (int)0, (int)100);
            if (this.isOnLiquidSurface()) {
                this.method_18800(this.method_18798().field_1352, 0.5, this.method_18798().field_1350);
                this.field_6007 = true;
                this.jumpCharge = 0;
            }
        }
    }

    private boolean isOnLiquidSurface() {
        if (!this.isInAnyFluid()) {
            return false;
        }
        class_2338 pos = this.method_24515();
        class_2338 abovePos = pos.method_10084();
        class_3610 fluidState = this.method_37908().method_8316(pos);
        class_3610 aboveFluidState = this.method_37908().method_8316(abovePos);
        return !fluidState.method_15769() && aboveFluidState.method_15769();
    }

    public boolean method_6153() {
        return this.canJump && (this.method_24828() || this.isOnLiquidSurface());
    }

    public void method_6155(int strength) {
        this.jumpCharge = strength;
        this.canJump = false;
    }

    public void method_6156() {
        this.canJump = true;
    }

    public int method_45327() {
        return 0;
    }

    protected boolean method_5818(@NotNull class_1297 pPassenger) {
        return super.method_5818(pPassenger);
    }

    public boolean method_5747(float pFallDistance, float pMultiplier, @NotNull class_1282 pSource) {
        return false;
    }

    protected void method_5623(double pY, boolean pOnGround, @NotNull class_2680 pState, @NotNull class_2338 pPos) {
    }

    public void method_6005(double pStrength, double pX, double pZ) {
        if (!this.isSpawning()) {
            super.method_6005(pStrength, pX, pZ);
        }
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 2, this::attackPredicate)});
    }

    public boolean isInAnyFluid() {
        class_243 eyePos = this.method_5836(1.0f);
        return !this.method_37908().method_8316(new class_2338((int)eyePos.field_1352, (int)eyePos.field_1351, (int)eyePos.field_1350)).method_15769();
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        double speed = this.method_18798().method_37268();
        if (this.isSpawning()) {
            event.setAnimation(this.SPAWN);
        } else if (this.isInAnyFluid()) {
            event.setAnimation(this.SWIM);
        } else if (speed > 0.140625) {
            event.setAnimation(this.RUN);
        } else if (speed > (double)4.0E-4f) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (this.getAttackType() == 1 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.setAnimation(this.BITE);
        }
        return PlayState.CONTINUE;
    }
}

