/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.projectile.ShadeAltarUpgradeHaloProjectile;
import dev.xylonity.companions.common.item.ShadowBellItem;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractShadeAltarBlockEntity
extends class_2586
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int MAX_CHARGES = CompanionsConfig.SHADOW_ALTAR_MAX_CHARGES;
    private static final int MAX_BLOOD_CHARGES = CompanionsConfig.SHADOW_ALTAR_BLOOD_CHARGES_AMOUNT;
    public UUID activeShadeUUID = null;
    private int charges = 0;
    private int prevCharges = 0;

    public AbstractShadeAltarBlockEntity(class_2591<?> pType, class_2338 pos, class_2680 state) {
        super(pType, pos, state);
    }

    public int getCharges() {
        return this.charges;
    }

    public int getMaxCharges() {
        return MAX_CHARGES;
    }

    public int getBloodCharges() {
        return MAX_BLOOD_CHARGES;
    }

    public boolean isBloodUpgradeActive() {
        return this.getCharges() >= MAX_CHARGES - MAX_BLOOD_CHARGES;
    }

    public boolean addCharge() {
        if (this.charges >= MAX_CHARGES) {
            if (this.field_11863 != null) {
                this.field_11863.method_45447(null, this.method_11016(), CompanionsSounds.SHADE_ALTAR_FULL.get(), class_3419.field_15245);
            }
            return false;
        }
        ++this.charges;
        this.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_45447(null, this.method_11016(), CompanionsSounds.SHADE_ALTAR_CHARGE.get(), class_3419.field_15245);
        }
        return true;
    }

    public boolean consumeCharge() {
        if (this.charges <= 0) {
            return false;
        }
        --this.charges;
        this.method_5431();
        return true;
    }

    public void setCharges(int charges) {
        this.charges = charges;
        this.method_5431();
    }

    public void clearCharges() {
        this.charges = 0;
        this.method_5431();
    }

    protected boolean isImportantChargeDiff() {
        return this.prevCharges == 0 && this.charges == 1 || this.prevCharges == MAX_CHARGES - MAX_BLOOD_CHARGES - 1 && this.charges == MAX_CHARGES - MAX_BLOOD_CHARGES;
    }

    protected boolean hasIncreasedFromPrevInteraction() {
        return this.charges > this.prevCharges;
    }

    public void method_5431() {
        ShadeAltarUpgradeHaloProjectile halo;
        super.method_5431();
        if (this.field_11863 != null && this.hasIncreasedFromPrevInteraction() && (halo = (ShadeAltarUpgradeHaloProjectile)CompanionsEntities.SHADE_ALTAR_UPGRADE_HALO.method_5883(this.field_11863)) != null) {
            halo.method_5814((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.015, (double)this.method_11016().method_10260() + 0.5);
            this.field_11863.method_8649((class_1297)halo);
        }
        this.prevCharges = this.charges;
    }

    protected void method_11007(@NotNull class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("Charges", this.charges);
        tag.method_10569("PrevCharges", this.prevCharges);
        if (this.activeShadeUUID != null) {
            tag.method_25927("ActiveShadeUUID", this.activeShadeUUID);
        } else {
            tag.method_10551("ActiveShadeUUID");
        }
    }

    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.charges = tag.method_10550("Charges");
        this.prevCharges = tag.method_10550("PrevCharges");
        this.activeShadeUUID = tag.method_25928("ActiveShadeUUID") ? tag.method_25926("ActiveShadeUUID") : null;
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        tag.method_10569("Charges", this.getCharges());
        tag.method_10569("PrevCharges", this.prevCharges);
        if (this.activeShadeUUID != null) {
            tag.method_25927("ActiveShadeUUID", this.activeShadeUUID);
        }
        return tag;
    }

    public void sync() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2622 pkt = class_2622.method_38585((class_2586)this);
        serverLevel.method_14178().field_17254.method_17210(new class_1923(this.field_11867), false).forEach(arg_0 -> AbstractShadeAltarBlockEntity.lambda$sync$0((class_2596)pkt, arg_0));
    }

    @Nullable
    public abstract ShadeEntity spawnShade(@NotNull class_1937 var1, @NotNull class_1657 var2, @NotNull class_1268 var3, ShadowBellItem var4);

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public double findPlaceToSpawn(@NotNull class_1657 pPlayer, @NotNull class_1937 pLevel, int blockX, int blockZ) {
        int baseY = class_3532.method_15357((double)pPlayer.method_23318());
        int minY = pLevel.method_31607();
        int maxY = pLevel.method_31600() - 1;
        int spawnY = baseY;
        boolean found = false;
        for (int offset = 0; offset <= Math.max(baseY - minY, maxY - baseY) && !found; ++offset) {
            int yUp;
            int yDown = baseY - offset;
            if (yDown >= minY) {
                class_2338 below = new class_2338(blockX, yDown - 1, blockZ);
                class_2338 curr = new class_2338(blockX, yDown, blockZ);
                if (yDown - 1 >= minY && !pLevel.method_8320(below).method_26215() && pLevel.method_8320(curr).method_26215()) {
                    spawnY = yDown;
                    found = true;
                }
            }
            if (found || offset <= 0 || (yUp = baseY + offset) > maxY) continue;
            class_2338 below = new class_2338(blockX, yUp - 1, blockZ);
            class_2338 curr = new class_2338(blockX, yUp, blockZ);
            if (yUp - 1 < minY || pLevel.method_8320(below).method_26215() || !pLevel.method_8320(curr).method_26215()) continue;
            spawnY = yUp;
            found = true;
        }
        if (!found) {
            return Math.max(minY + 1, Math.min(maxY, baseY));
        }
        return spawnY;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$sync$0(class_2596 pkt, class_3222 p) {
        p.field_13987.method_14364(pkt);
    }
}

