/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.ai.navigator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.xylonity.companions.common.ai.navigator.BonusPathFinder;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1409;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;

public class GroundNavigator
extends class_1409 {
    private static final float EPSILON = 1.0E-8f;
    private class_243 lastPos = class_243.field_1353;
    private int noMoveTicks = 0;
    private final Cache<class_2338, Boolean> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();

    public GroundNavigator(class_1308 entity, class_1937 world) {
        super(entity, world);
    }

    @NotNull
    protected class_13 method_6336(int maxVisitedNodes) {
        this.field_6678 = new class_14();
        this.field_6678.method_15(true);
        return new BonusPathFinder(this.field_6678, maxVisitedNodes);
    }

    protected void method_6339() {
        class_243 curr;
        int lastIdx;
        if (this.field_6681 == null || this.field_6681.method_46()) {
            return;
        }
        class_243 entityPos = this.method_6347();
        int nextIdx = this.field_6681.method_39();
        double yFloor = Math.floor(entityPos.field_1351);
        for (lastIdx = nextIdx; lastIdx < this.field_6681.method_38() && (double)this.field_6681.method_40((int)lastIdx).field_39 == yFloor; ++lastIdx) {
        }
        class_243 base = entityPos.method_1023((double)this.field_6684.method_17681(), 0.0, (double)this.field_6684.method_17681());
        this.attemptShortcut(this.field_6681, entityPos, lastIdx, base);
        if (this.hasReached(this.field_6681, 1.0f) || this.isAtElevationChange(this.field_6681) && this.hasReached(this.field_6681, 1.0f)) {
            this.field_6681.method_44();
        }
        if (!this.field_6681.method_46()) {
            class_243 target = this.field_6681.method_49((class_1297)this.field_6684);
            this.field_6684.method_5962().method_6239(target.field_1352, target.field_1351, target.field_1350, this.field_6668);
            if (this.field_6684.field_5976 && this.field_6684.method_24828()) {
                class_2338 abovePos;
                class_7 aboveType;
                float malus;
                class_2350 dir = this.field_6684.method_5735();
                class_2338 frontPos = this.field_6684.method_24515().method_10093(dir);
                class_2680 state = this.field_6677.method_8320(frontPos);
                class_265 shape = state.method_26220((class_1922)this.field_6677, frontPos);
                double shapeHeight = shape.method_1105(class_2350.class_2351.field_11052);
                if (shapeHeight > 0.0 && shapeHeight <= 1.0 && (malus = this.field_6684.method_5944(aboveType = this.field_6678.method_25((class_1922)this.field_6677, (abovePos = frontPos.method_10084()).method_10263(), abovePos.method_10264(), abovePos.method_10260(), this.field_6684))) >= 0.0f && malus < 8.0f) {
                    this.field_6684.method_5993().method_6233();
                }
            }
        }
        this.noMoveTicks = (curr = class_243.method_24954((class_2382)this.field_6684.method_24515()).method_1031(0.0, (double)(this.field_6684.method_17682() / 2.0f), 0.0)).method_1022(this.lastPos) < 0.01 ? ++this.noMoveTicks : 0;
        this.lastPos = curr;
        if (this.noMoveTicks > 10) {
            this.cache.invalidateAll();
            this.field_6681 = null;
            this.field_6684.method_5962().method_6239(this.field_6684.method_23317(), this.field_6684.method_23318(), this.field_6684.method_23321(), 0.0);
            if (this.method_6355() != null) {
                this.method_6348(this.method_6355(), (int)this.field_6684.method_26825(class_5134.field_23717));
            }
            this.noMoveTicks = 0;
        }
        this.method_6346(entityPos);
    }

    private boolean hasReached(class_11 path, float threshold) {
        class_243 pathPos = path.method_49((class_1297)this.field_6684);
        if (Math.abs(this.field_6684.method_23317() - pathPos.field_1352) >= (double)threshold) {
            return false;
        }
        if (Math.abs(this.field_6684.method_23321() - pathPos.field_1350) >= (double)threshold) {
            return false;
        }
        return Math.abs(this.field_6684.method_23318() - pathPos.field_1351) <= 1.001;
    }

    private boolean isAtElevationChange(class_11 path) {
        int currIndex = path.method_39();
        int endIndex = Math.min(path.method_38(), currIndex + class_3532.method_15386((float)(this.field_6684.method_17681() * 0.5f)) + 1);
        int currY = path.method_40((int)currIndex).field_39;
        for (int i = currIndex + 1; i < endIndex; ++i) {
            if (path.method_40((int)i).field_39 == currY) continue;
            return true;
        }
        return false;
    }

    private boolean attemptShortcut(class_11 path, class_243 entityPos, int pathLength, class_243 base) {
        int nextNodeIndex = path.method_39();
        for (int i = pathLength - 1; i > nextNodeIndex; --i) {
            class_243 vec = path.method_47((class_1297)this.field_6684, i).method_1020(entityPos);
            if (!this.catchF(vec, base)) continue;
            path.method_42(i);
            return false;
        }
        return true;
    }

    private boolean catchF(class_243 vec, class_243 base) {
        int stepZ;
        float tNextZ;
        float tDeltaZ;
        int stepY;
        float tNextY;
        float tDeltaY;
        int stepX;
        float tNextX;
        float tDeltaX;
        float maxT = (float)vec.method_1033();
        if (maxT < 1.0E-8f) {
            return true;
        }
        float dx = (float)vec.field_1352 / maxT;
        float dy = (float)vec.field_1351 / maxT;
        float dz = (float)vec.field_1350 / maxT;
        if (Math.abs(dx) < 1.0E-8f) {
            tDeltaX = Float.POSITIVE_INFINITY;
            tNextX = Float.POSITIVE_INFINITY;
            stepX = 0;
        } else {
            stepX = dx > 0.0f ? 1 : -1;
            float voxelBoundaryX = stepX > 0 ? (float)(class_3532.method_15357((double)base.field_1352) + 1) : (float)class_3532.method_15357((double)base.field_1352);
            tDeltaX = 1.0f / Math.abs(dx);
            tNextX = (float)(((double)voxelBoundaryX - base.field_1352) / (double)dx);
        }
        int currentX = class_3532.method_15357((double)base.field_1352);
        if (Math.abs(dy) < 1.0E-8f) {
            tDeltaY = Float.POSITIVE_INFINITY;
            tNextY = Float.POSITIVE_INFINITY;
            stepY = 0;
        } else {
            stepY = dy > 0.0f ? 1 : -1;
            float voxelBoundaryY = stepY > 0 ? (float)(class_3532.method_15357((double)base.field_1351) + 1) : (float)class_3532.method_15357((double)base.field_1351);
            tDeltaY = 1.0f / Math.abs(dy);
            tNextY = (float)(((double)voxelBoundaryY - base.field_1351) / (double)dy);
        }
        int currentY = class_3532.method_15357((double)base.field_1351);
        if (Math.abs(dz) < 1.0E-8f) {
            tDeltaZ = Float.POSITIVE_INFINITY;
            tNextZ = Float.POSITIVE_INFINITY;
            stepZ = 0;
        } else {
            stepZ = dz > 0.0f ? 1 : -1;
            float voxelBoundaryZ = stepZ > 0 ? (float)(class_3532.method_15357((double)base.field_1350) + 1) : (float)class_3532.method_15357((double)base.field_1350);
            tDeltaZ = 1.0f / Math.abs(dz);
            tNextZ = (float)(((double)voxelBoundaryZ - base.field_1350) / (double)dz);
        }
        int currentZ = class_3532.method_15357((double)base.field_1350);
        class_2338.class_2339 pos = new class_2338.class_2339();
        float t = 0.0f;
        while (t <= maxT) {
            if (tNextX < tNextY) {
                if (tNextX < tNextZ) {
                    currentX += stepX;
                    t = tNextX;
                    tNextX += tDeltaX;
                } else {
                    currentZ += stepZ;
                    t = tNextZ;
                    tNextZ += tDeltaZ;
                }
            } else if (tNextY < tNextZ) {
                currentY += stepY;
                t = tNextY;
                tNextY += tDeltaY;
            } else {
                currentZ += stepZ;
                t = tNextZ;
                tNextZ += tDeltaZ;
            }
            pos.method_10103(currentX, currentY, currentZ);
            class_2338 immutablePos = pos.method_10062();
            Boolean isPathfindable = (Boolean)this.cache.getIfPresent((Object)immutablePos);
            if (isPathfindable == null) {
                class_2680 blockState = this.field_6677.method_8320((class_2338)pos);
                isPathfindable = blockState.method_26171((class_1922)this.field_6677, (class_2338)pos, class_10.field_50);
                this.cache.put((Object)immutablePos, (Object)isPathfindable);
            }
            if (!isPathfindable.booleanValue()) {
                return false;
            }
            class_7 pathType = this.field_6678.method_25((class_1922)this.field_6677, currentX, currentY, currentZ, this.field_6684);
            float malus = this.field_6684.method_5944(pathType);
            if (!(malus < 0.0f) && !(malus >= 8.0f) && pathType != class_7.field_3 && pathType != class_7.field_9 && pathType != class_7.field_17) continue;
            return false;
        }
        return true;
    }
}

