/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.entity.renderer;

import dev.xylonity.companions.client.entity.model.DinamoModel;
import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.entity.companion.DinamoEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.util.interfaces.ITeslaUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class DinamoRenderer
extends GeoEntityRenderer<DinamoEntity>
implements ITeslaUtil {
    public DinamoRenderer(class_5617.class_5618 renderManager, int totalFrames, int ticksPerFrame) {
        super(renderManager, (GeoModel)new DinamoModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer(new ElectricConnectionLayer((GeoRenderer<DinamoEntity>)this, new class_2960("companions", "textures/misc/electric_arch.png"), totalFrames, ticksPerFrame));
        this.field_4673 = 1.0f;
    }

    public DinamoRenderer(class_5617.class_5618 renderManager) {
        this(renderManager, 8, 1);
    }

    private static class ElectricConnectionLayer
    extends GeoRenderLayer<DinamoEntity> {
        private final class_2960 texture;
        private final int totalFrames;
        private final int ticksPerFrame;

        public ElectricConnectionLayer(GeoRenderer<DinamoEntity> renderer, class_2960 texture, int totalFrames, int ticksPerFrame) {
            super(renderer);
            this.texture = texture;
            this.totalFrames = totalFrames;
            this.ticksPerFrame = ticksPerFrame;
        }

        public void render(class_4587 poseStack, DinamoEntity animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
            block6: {
                int frame;
                block5: {
                    frame = this.calculateCurrentFrame(animatable);
                    if (frame < 0) {
                        return;
                    }
                    if (animatable.getMainAction() != 0 || !animatable.isActive()) break block5;
                    class_243 origin = animatable.method_19538();
                    class_243 originOffset = new class_243(0.0, (double)animatable.method_17682() * 0.8, 0.0);
                    for (TeslaConnectionManager.ConnectionNode node : TeslaConnectionManager.getInstance().getOutgoing(animatable.asConnectionNode())) {
                        class_243 direction;
                        if (node.isEntity()) {
                            class_1297 target = CompanionsEntityTracker.getEntityByUUID(node.entityId());
                            if (!(target instanceof class_1309)) continue;
                            class_1309 le = (class_1309)target;
                            end = le.method_19538().method_1031(0.0, (double)animatable.method_17682() * 0.8, 0.0);
                            direction = end.method_1020(origin);
                        } else {
                            AbstractTeslaBlockEntity be = TeslaConnectionManager.getInstance().getBlockEntity(node);
                            class_243 base = new class_243((double)be.method_11016().method_10263() + 0.5, (double)be.method_11016().method_10264(), (double)be.method_11016().method_10260() + 0.5);
                            end = base.method_1019(be.electricalChargeEndOffset());
                            direction = end.method_1020(origin);
                        }
                        this.renderConnection(bufferSource, poseStack, originOffset, direction, frame, packedLight);
                    }
                    break block6;
                }
                if (animatable.getMainAction() == 0 || !animatable.isActiveForAttack()) break block6;
                class_243 origin = animatable.method_19538();
                class_243 originOffset = new class_243(0.0, (double)animatable.method_17682() * 0.8, 0.0);
                for (class_1309 entity : animatable.entitiesToAttack) {
                    class_243 end = entity.method_19538().method_1031(0.0, (double)entity.method_17682() * 0.5, 0.0);
                    class_243 direction = end.method_1020(origin);
                    this.renderConnection(bufferSource, poseStack, originOffset, direction, frame, packedLight);
                }
            }
        }

        private int calculateCurrentFrame(DinamoEntity animatable) {
            int frame = animatable.getAnimationStartTick() / this.ticksPerFrame;
            if (frame >= this.totalFrames) {
                return -1;
            }
            return frame;
        }

        private void renderConnection(class_4597 bufferSource, class_4587 poseStack, class_243 p0, class_243 p1, int frame, int light) {
            int[] indices;
            class_4588 vertexConsumer = bufferSource.getBuffer(AutoGlowingTexture.getRenderType((class_2960)this.texture));
            Matrix4f positionMatrix = poseStack.method_23760().method_23761();
            Matrix3f normalMatrix = poseStack.method_23760().method_23762();
            float x0 = (float)p0.field_1352;
            float y0 = (float)p0.field_1351;
            float z0 = (float)p0.field_1350;
            float x1 = (float)p1.field_1352;
            float y1 = (float)p1.field_1351;
            float z1 = (float)p1.field_1350;
            float dx = x1 - x0;
            float dy = y1 - y0;
            float dz = z1 - z0;
            if (dx == 0.0f) {
                dx = 0.001f;
            }
            float dHorizontal = class_3532.method_15355((float)(dx * dx + dz * dz));
            float length = class_3532.method_15355((float)(dHorizontal * dHorizontal + dy * dy));
            float offset = 0.5f;
            float yOffset = offset * (dHorizontal / length);
            float xOffset = offset * (dy / length) * (dx / dHorizontal);
            float zOffset = offset * (dy / length) * (dz / dHorizontal);
            float frameSize = 1.0f / (float)this.totalFrames;
            float v0 = (float)frame * frameSize;
            float v1 = v0 + frameSize;
            VertexCoordinates[] vertices = new VertexCoordinates[]{new VertexCoordinates(x0 + xOffset, y0 - yOffset, z0 + zOffset, 0.0f, v1), new VertexCoordinates(x1 + xOffset, y1 - yOffset, z1 + zOffset, 1.0f, v1), new VertexCoordinates(x1 - xOffset, y1 + yOffset, z1 - zOffset, 1.0f, v0), new VertexCoordinates(x0 - xOffset, y0 + yOffset, z0 - zOffset, 0.0f, v0)};
            for (int i : indices = new int[]{0, 1, 2, 3, 3, 2, 1, 0}) {
                this.produceVertex(vertexConsumer, positionMatrix, normalMatrix, light, vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].u, vertices[i].v);
            }
        }

        private void produceVertex(class_4588 vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, int light, float x, float y, float z, float textureU, float textureV) {
            vertexConsumer.method_22918(positionMatrix, x, y, z).method_1336(255, 255, 255, 255).method_22913(textureU, textureV).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        }

        private record VertexCoordinates(float x, float y, float z, float u, float v) {
        }
    }
}

