/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.capability.ChunkLoaderCache;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.capability.PlayerActivityTracker;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderAdded;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderRemoved;
import com.supermartijn642.chunkloaders.packet.PackedStartLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedStopLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedTogglePlayerActivity;
import com.supermartijn642.core.network.BasePacket;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3230;

public class ServerChunkLoadingCapability
extends ChunkLoadingCapability {
    private static final class_3230<class_1923> CHUNK_LOADING_TICKET_TYPE = class_3230.method_14291((String)"chunkloaders:loaded", Comparator.comparingLong(class_1923::method_8324));

    public ServerChunkLoadingCapability(class_1937 level) {
        super(level);
    }

    public void addChunkLoader(ChunkLoaderBlockEntity entity) {
        class_2338 pos = entity.method_11016();
        UUID owner = entity.getOwner();
        if (!this.chunkLoadersPerPlayer.containsKey(owner) || !((Set)this.chunkLoadersPerPlayer.get(owner)).contains(pos)) {
            class_1923 chunkPos = new class_1923(pos);
            this.chunkLoadersPerChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.chunkLoadersPerChunk.get(chunkPos)).add(pos);
            this.chunkLoadersPerPlayer.putIfAbsent(owner, new HashSet());
            ((Set)this.chunkLoadersPerPlayer.get(owner)).add(pos);
            this.chunkLoaderCacheMap.put(pos, new ChunkLoaderCache(pos, entity.getChunkLoaderType(), owner));
            int centerChunkX = entity.method_11016().method_10263() >> 4;
            int centerChunkZ = entity.method_11016().method_10260() >> 4;
            int range = entity.getChunkLoaderType().getRange();
            this.availableChunksPerPlayer.putIfAbsent(owner, new HashSet());
            for (int x = -range + 1; x < range; ++x) {
                for (int z = -range + 1; z < range; ++z) {
                    ((Set)this.availableChunksPerPlayer.get(owner)).add(new class_1923(centerChunkX + x, centerChunkZ + z));
                }
            }
            this.sendToAllPlayers(new PackedChunkLoaderAdded(pos, owner, entity.getChunkLoaderType()));
        }
    }

    public void removeChunkLoader(ChunkLoaderBlockEntity entity) {
        class_2338 pos = entity.method_11016();
        class_1923 chunkPos = new class_1923(pos);
        Set chunkLoadersPerChunk = (Set)this.chunkLoadersPerChunk.get(chunkPos);
        if (chunkLoadersPerChunk != null && chunkLoadersPerChunk.contains(pos)) {
            chunkLoadersPerChunk.remove(pos);
            if (chunkLoadersPerChunk.isEmpty()) {
                this.chunkLoadersPerChunk.remove(chunkPos);
            }
            UUID owner = entity.getOwner();
            Set chunkLoadersPerPlayer = (Set)this.chunkLoadersPerPlayer.get(owner);
            chunkLoadersPerPlayer.remove(pos);
            if (chunkLoadersPerPlayer.isEmpty()) {
                this.chunkLoadersPerPlayer.remove(owner);
            }
            this.chunkLoaderCacheMap.remove(pos);
            Set loadedChunksPerPlayer = (Set)this.loadedChunksPerPlayer.get(owner);
            Set availableChunksPerPlayer = (Set)this.availableChunksPerPlayer.get(owner);
            int radius = entity.getChunkLoaderType().getRange();
            for (int x = -radius + 1; x < radius; ++x) {
                block1: for (int z = -radius + 1; z < radius; ++z) {
                    class_1923 otherChunk = new class_1923(chunkPos.field_9181 + x, chunkPos.field_9180 + z);
                    if (this.chunkLoadersPerPlayer.containsKey(owner)) {
                        for (class_2338 chunkLoaderPos : (Set)this.chunkLoadersPerPlayer.get(owner)) {
                            int chunkLoaderChunkX = chunkLoaderPos.method_10263() >> 4;
                            int chunkLoaderChunkZ = chunkLoaderPos.method_10260() >> 4;
                            ChunkLoaderType type = ((ChunkLoaderCache)this.chunkLoaderCacheMap.get((Object)chunkLoaderPos)).chunkLoaderType;
                            if (Math.abs(chunkLoaderChunkX - otherChunk.field_9181) >= type.getRange() || Math.abs(chunkLoaderChunkZ - otherChunk.field_9180) >= type.getRange()) continue;
                            continue block1;
                        }
                    }
                    if (loadedChunksPerPlayer != null && loadedChunksPerPlayer.contains(otherChunk)) {
                        this.stopLoadingChunk(owner, otherChunk);
                    }
                    availableChunksPerPlayer.remove(otherChunk);
                }
            }
            if (availableChunksPerPlayer.isEmpty()) {
                this.availableChunksPerPlayer.remove(owner);
            }
            this.sendToAllPlayers(new PackedChunkLoaderRemoved(pos, owner, entity.getChunkLoaderType()));
        }
    }

    public void startLoadingChunk(UUID player, class_1923 chunkPos) {
        if (!this.canPlayerLoadChunk(player, chunkPos)) {
            return;
        }
        boolean active = PlayerActivityTracker.isPlayerActive(player);
        if (active) {
            this.activePlayersPerLoadedChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.activePlayersPerLoadedChunk.get(chunkPos)).add(player);
        } else {
            this.inactivePlayersPerLoadedChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.inactivePlayersPerLoadedChunk.get(chunkPos)).add(player);
        }
        this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
        ((Set)this.loadedChunksPerPlayer.get(player)).add(chunkPos);
        this.loadChunk(chunkPos);
        this.sendToAllPlayers(new PackedStartLoadingChunk(player, chunkPos, active));
    }

    public void stopLoadingChunk(UUID player, class_1923 chunkPos) {
        Set loadedChunksPerPlayer;
        Set players;
        Set inactivePlayer = (Set)this.inactivePlayersPerLoadedChunk.get(chunkPos);
        if (inactivePlayer != null) {
            inactivePlayer.remove(player);
            if (inactivePlayer.isEmpty()) {
                this.inactivePlayersPerLoadedChunk.remove(chunkPos);
            }
        }
        if ((players = (Set)this.activePlayersPerLoadedChunk.get(chunkPos)) != null) {
            players.remove(player);
            if (players.isEmpty()) {
                this.activePlayersPerLoadedChunk.remove(chunkPos);
            }
        }
        if ((inactivePlayer == null || inactivePlayer.isEmpty()) && (players == null || players.isEmpty())) {
            this.unloadChunk(chunkPos);
        }
        if ((loadedChunksPerPlayer = (Set)this.loadedChunksPerPlayer.get(player)) != null) {
            loadedChunksPerPlayer.remove(chunkPos);
            if (loadedChunksPerPlayer.isEmpty()) {
                this.loadedChunksPerPlayer.remove(player);
            }
        }
        this.sendToAllPlayers(new PackedStopLoadingChunk(player, chunkPos));
    }

    public void togglePlayerActivity(UUID player, boolean active) {
        Set chunks = (Set)this.loadedChunksPerPlayer.get(player);
        if (chunks != null) {
            if (active) {
                for (class_1923 chunk : chunks) {
                    Set activePlayers;
                    Set inactivePlayers = (Set)this.inactivePlayersPerLoadedChunk.get(chunk);
                    if (inactivePlayers != null) {
                        inactivePlayers.remove(player);
                        if (inactivePlayers.isEmpty()) {
                            this.inactivePlayersPerLoadedChunk.remove(chunk);
                        }
                    }
                    if ((activePlayers = this.activePlayersPerLoadedChunk.computeIfAbsent(chunk, c -> new HashSet())).isEmpty()) {
                        this.loadChunk(chunk);
                    }
                    activePlayers.add(player);
                }
            } else {
                for (class_1923 chunk : chunks) {
                    Set activePlayers = (Set)this.activePlayersPerLoadedChunk.get(chunk);
                    if (activePlayers != null) {
                        activePlayers.remove(player);
                        if (activePlayers.isEmpty()) {
                            this.activePlayersPerLoadedChunk.remove(chunk);
                            this.unloadChunk(chunk);
                        }
                    }
                    this.inactivePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                    ((Set)this.inactivePlayersPerLoadedChunk.get(chunk)).add(player);
                }
            }
            this.sendToAllPlayers(new PackedTogglePlayerActivity(player, active));
        }
    }

    public Set<class_1923> getChunksToBeTicked() {
        return this.activePlayersPerLoadedChunk.keySet();
    }

    private void loadChunk(class_1923 pos) {
        ((class_3218)this.level).method_14178().method_17297(CHUNK_LOADING_TICKET_TYPE, pos, 2, (Object)pos);
    }

    private void unloadChunk(class_1923 pos) {
        ((class_3218)this.level).method_14178().method_17300(CHUNK_LOADING_TICKET_TYPE, pos, 2, (Object)pos);
    }

    public void onLoadLevel() {
        for (class_1923 pos : this.activePlayersPerLoadedChunk.keySet()) {
            this.loadChunk(pos);
        }
    }

    private void sendToAllPlayers(BasePacket packet) {
        ChunkLoaders.CHANNEL.sendToDimension(this.level, packet);
    }

    public class_2487 writeClientInfo() {
        class_2487 compound = new class_2487();
        class_2499 chunkLoaderCachesTag = new class_2499();
        for (ChunkLoaderCache cache : this.chunkLoaderCacheMap.values()) {
            chunkLoaderCachesTag.add((Object)cache.write());
        }
        compound.method_10566("chunkLoaderCaches", (class_2520)chunkLoaderCachesTag);
        class_2499 loadedChunksPerActivePlayerTag = new class_2499();
        class_2499 loadedChunksPerInactivePlayerTag = new class_2499();
        for (Map.Entry entry : this.loadedChunksPerPlayer.entrySet()) {
            class_2487 playerTag = new class_2487();
            playerTag.method_25927("player", (UUID)entry.getKey());
            playerTag.method_10564("chunks", ((Set)entry.getValue()).stream().mapToLong(class_1923::method_8324).toArray());
            if (PlayerActivityTracker.isPlayerActive((UUID)entry.getKey())) {
                loadedChunksPerActivePlayerTag.add((Object)playerTag);
                continue;
            }
            loadedChunksPerInactivePlayerTag.add((Object)playerTag);
        }
        compound.method_10566("loadedChunksPerActivePlayer", (class_2520)loadedChunksPerActivePlayerTag);
        compound.method_10566("loadedChunksPerInactivePlayer", (class_2520)loadedChunksPerInactivePlayerTag);
        return compound;
    }
}

