/*
 * Decompiled with CFR 0.152.
 */
package net.lazrproductions.chess.util;

import java.util.ArrayList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.lazrproductions.chess.block.ModBlocks;
import net.lazrproductions.chess.block.custom.BoardBlock;
import net.lazrproductions.chess.block.custom.ChessPieceBlock;
import net.lazrproductions.chess.config.ModConfigs;
import net.lazrproductions.chess.util.Utilities;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ChessClientMod
implements ClientModInitializer {
    public static ChessClientMod instance;
    private int offsetX = 0;
    private int offsetZ = 0;
    private boolean showGrid = true;
    private boolean isBlocks = true;
    private int maximumMoveDistance = 20;
    private double maxDistFromMove = 10.0;
    private float[] blockColor = this.colorToRgb(16308224);
    private float[] blockColor2 = this.colorToRgb(0xFFFFFF);
    private float[] opponentColor = this.colorToRgb(0xC60000);
    private float blockColorSpeed = 0.02f;
    private boolean dump = true;
    private long lastDumpTime;
    private long thisDumpTime;
    public GamePiece selectedPiece = null;
    public Moveset[] pieceMoves = new Moveset[]{new Moveset(new String[]{"     ", " !?! ", "  O  ", "     ", "     "}), new Moveset(new String[]{" 1 1 ", "1   1", "  O  ", "1   1", " 1 1 "}), new Moveset(new String[]{"     ", " * * ", "  O  ", " * * ", "     "}), new Moveset(new String[]{"     ", "  *  ", " *O* ", "  *  ", "     "}), new Moveset(new String[]{"     ", " 111 ", " 1O1 ", " 111 ", "     "}), new Moveset(new String[]{"     ", " *** ", " *O* ", " *** ", "     "}), new Moveset(new String[]{"     ", " 1 1 ", "  O  ", "     ", "     "}), new Moveset(new String[]{"     ", " 1 1 ", "  O  ", " 1 1 ", "     "})};
    float t = 0.0f;

    public void onInitializeClient() {
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), new class_2248[]{ModBlocks.CHESS_PIECE});
        instance = this;
        this.blockColor = this.colorToRgb(ModConfigs.SELECTIONCOLOR1);
        this.blockColor2 = this.colorToRgb(ModConfigs.SELECTIONCOLOR2);
        this.opponentColor = this.colorToRgb(ModConfigs.SELECTIONOPPONENTCOLOR);
        this.maximumMoveDistance = ModConfigs.SELECTIONMAXMOVEDIST;
        this.maxDistFromMove = ModConfigs.SELECTIONMAXDISTTOMOVE;
    }

    private float[] colorToRgb(int color) {
        float[] result = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 0 & 0xFF) / 255.0f};
        return result;
    }

    public void clearSelectedPiece() {
        this.selectedPiece = null;
    }

    public boolean selectPiece(GamePiece piece) {
        if (this.selectedPiece != null) {
            return false;
        }
        this.selectedPiece = piece;
        return true;
    }

    public boolean selectPiece(class_2338 pos, int piece, int color, int facing) {
        if (this.selectedPiece != null && this.selectedPiece.pos == pos) {
            return false;
        }
        this.selectedPiece = new GamePiece(pos, piece, color, facing);
        return true;
    }

    public boolean deselectPiece(GamePiece piece) {
        if (this.selectedPiece == piece) {
            this.selectedPiece = null;
            return true;
        }
        return false;
    }

    public boolean deselectPiece(class_2338 pos) {
        if (this.selectedPiece.pos == pos) {
            this.selectedPiece = null;
            return true;
        }
        return false;
    }

    public boolean deselectPiece() {
        this.selectedPiece = null;
        return true;
    }

    public boolean pieceIsSelected(GamePiece piece) {
        return this.selectedPiece == piece;
    }

    public boolean pieceIsSelected(class_2338 pos) {
        return this.selectedPiece != null && this.selectedPiece.pos == pos;
    }

    public boolean changeSelectedPiece(class_2338 pos, int piece) {
        if (this.selectedPiece != null && this.selectedPiece.pos == pos) {
            this.selectedPiece.piece = piece;
            return true;
        }
        return false;
    }

    public boolean changeSelectedPieceColor(class_2338 pos, int color) {
        if (this.selectedPiece != null && this.selectedPiece.pos == pos) {
            this.selectedPiece.color = color;
            return true;
        }
        return false;
    }

    public void renderOverlay(float partialTicks, class_4587 stack, class_4588 consumer, double cameraX, double cameraY, double cameraZ) {
        if (!this.showGrid) {
            return;
        }
        stack.method_22903();
        stack.method_22904(-cameraX, -cameraY, -cameraZ);
        float ta = this.t;
        if (this.t > 1.0f) {
            ta = (this.t - 2.0f) / -1.0f;
        }
        float[] curBlockColor = new float[]{Utilities.Lerp(this.blockColor[0], this.blockColor2[0], ta), Utilities.Lerp(this.blockColor[1], this.blockColor2[1], ta), Utilities.Lerp(this.blockColor[2], this.blockColor2[2], ta)};
        this.t += this.blockColorSpeed;
        if (this.t > 2.0f) {
            this.t = 0.0f;
        }
        this.thisDumpTime = System.currentTimeMillis();
        this.dump = false;
        if (this.thisDumpTime > this.lastDumpTime + 50000L) {
            this.dump = false;
            this.lastDumpTime = this.thisDumpTime;
        }
        if (this.showGrid) {
            stack.method_22903();
            stack.method_46416((float)this.offsetX, 0.0f, (float)this.offsetZ);
            if (this.isBlocks && this.selectedPiece != null) {
                class_1937 world = class_310.method_1551().method_1560().method_37908();
                class_310 inst = class_310.method_1551();
                ArrayList<MovesetDirection> set = this.movesetToDirections(world, this.pieceMoves[this.selectedPiece.piece].movements, this.selectedPiece.facing);
                ArrayList<Selection> selections = new ArrayList<Selection>(0);
                block0: for (int i = 0; i < set.size(); ++i) {
                    if (set.get((int)i).infinite) {
                        for (int d = 1; d < this.maximumMoveDistance; ++d) {
                            class_2338 p = new class_2338(set.get((int)i).direction.method_10263() * d + this.selectedPiece.pos.method_10263(), this.selectedPiece.pos.method_10264(), set.get((int)i).direction.method_10260() * d + this.selectedPiece.pos.method_10260());
                            Selection s = new Selection(p, curBlockColor);
                            if (world.method_8320(p.method_10069(0, -1, 0)).method_26204().getClass() != BoardBlock.class) continue;
                            if (world.method_8320(p).method_26204() != class_2246.field_10124) {
                                if (world.method_8320(p).method_26204().getClass() != ChessPieceBlock.class || (Integer)world.method_8320(p).method_11654((class_2769)ChessPieceBlock.COLOR) == this.selectedPiece.color) continue block0;
                                s.color = this.opponentColor;
                                selections.add(s);
                                continue block0;
                            }
                            selections.add(s);
                        }
                        continue;
                    }
                    if (set.get((int)i).mustDefeat) {
                        class_2338 p = new class_2338(set.get((int)i).direction.method_10263() + this.selectedPiece.pos.method_10263(), this.selectedPiece.pos.method_10264(), set.get((int)i).direction.method_10260() + this.selectedPiece.pos.method_10260());
                        if (world.method_8320(p.method_10069(0, -1, 0)).method_26204().getClass() != BoardBlock.class || world.method_8320(p).method_26204() == class_2246.field_10124 || world.method_8320(p).method_26204().getClass() != ChessPieceBlock.class || (Integer)world.method_8320(p).method_11654((class_2769)ChessPieceBlock.COLOR) == this.selectedPiece.color) continue;
                        selections.add(new Selection(p, this.opponentColor));
                        continue;
                    }
                    if (set.get((int)i).cannotDefeat) {
                        class_2338 p = new class_2338(set.get((int)i).direction.method_10263() + this.selectedPiece.pos.method_10263(), this.selectedPiece.pos.method_10264(), set.get((int)i).direction.method_10260() + this.selectedPiece.pos.method_10260());
                        if (world.method_8320(p.method_10069(0, -1, 0)).method_26204().getClass() != BoardBlock.class || world.method_8320(p).method_26204() != class_2246.field_10124) continue;
                        selections.add(new Selection(p, curBlockColor));
                        continue;
                    }
                    class_2338 p = new class_2338(set.get((int)i).direction.method_10263() + this.selectedPiece.pos.method_10263(), this.selectedPiece.pos.method_10264(), set.get((int)i).direction.method_10260() + this.selectedPiece.pos.method_10260());
                    Selection s = new Selection(p, curBlockColor);
                    if (world.method_8320(p.method_10069(0, -1, 0)).method_26204().getClass() != BoardBlock.class) continue;
                    if (world.method_8320(p).method_26204() != class_2246.field_10124) {
                        if (world.method_8320(p).method_26204().getClass() != ChessPieceBlock.class || (Integer)world.method_8320(p).method_11654((class_2769)ChessPieceBlock.COLOR) == this.selectedPiece.color) continue;
                        s.color = this.opponentColor;
                        selections.add(s);
                        continue;
                    }
                    selections.add(s);
                }
                for (int s = 0; s < selections.size(); ++s) {
                    this.drawSquare(consumer, stack, ((Selection)selections.get((int)s)).pos.method_10263(), ((Selection)selections.get((int)s)).pos.method_10264(), ((Selection)selections.get((int)s)).pos.method_10260(), ((Selection)selections.get((int)s)).color[0], ((Selection)selections.get((int)s)).color[1], ((Selection)selections.get((int)s)).color[2], 0.0625f, 0.9375f);
                    this.drawSquare(consumer, stack, ((Selection)selections.get((int)s)).pos.method_10263(), ((Selection)selections.get((int)s)).pos.method_10264(), ((Selection)selections.get((int)s)).pos.method_10260(), ((Selection)selections.get((int)s)).color[0], ((Selection)selections.get((int)s)).color[1], ((Selection)selections.get((int)s)).color[2], 0.0f, 1.0f);
                }
                if (world.method_8320(this.selectedPiece.pos).method_26204() == class_2246.field_10124) {
                    this.selectedPiece = null;
                }
                if (inst.field_1729.method_1609()) {
                    // empty if block
                }
            }
            stack.method_22909();
        }
        stack.method_22909();
    }

    private void drawSquare(class_4588 consumer, class_4587 stack, float x, float y, float z, float r, float g, float b, float from, float to) {
        this.drawLine(consumer, stack, x + from, x + to, y, y, z + from, z + from, r, g, b);
        this.drawLine(consumer, stack, x + to, x + to, y, y, z + from, z + to, r, g, b);
        this.drawLine(consumer, stack, x + to, x + from, y, y, z + to, z + to, r, g, b);
        this.drawLine(consumer, stack, x + from, x + from, y, y, z + to, z + from, r, g, b);
    }

    private void drawLine(class_4588 consumer, class_4587 stack, float x1, float x2, float y1, float y2, float z1, float z2, float red, float green, float blue) {
        Matrix4f model;
        if (this.dump) {
            System.out.println("line from " + x1 + "," + y1 + "," + z1 + " to " + x2 + "," + y2 + "," + z2);
        }
        if ((model = new Matrix4f((Matrix4fc)stack.method_23760().method_23761())) != null) {
            consumer.method_22918(model, x1, y1, z1).method_22915(red, green, blue, 1.0f).method_22916(0).method_22914(0.0f, 1.0f, 0.0f).method_22913(0.0f, 0.0f).method_1344();
            consumer.method_22918(model, x2, y2, z2).method_22915(red, green, blue, 1.0f).method_22916(0).method_22914(0.0f, 1.0f, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        }
    }

    public ArrayList<MovesetDirection> movesetToDirections(class_1937 world, String[] move, int facing) {
        ArrayList<MovesetDirection> positions = new ArrayList<MovesetDirection>(0);
        for (int i = 0; i < 5; ++i) {
            for (int p = 0; p < 5; ++p) {
                if (facing == 0) {
                    if (move[i].charAt(p) == '1') {
                        positions.add(new MovesetDirection(new class_2338(p - 2, 0, i - 2), false, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '*') {
                        positions.add(new MovesetDirection(new class_2338(p - 2, 0, i - 2), true, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '!') {
                        positions.add(new MovesetDirection(new class_2338(p - 2, 0, i - 2), false, true, false));
                        continue;
                    }
                    if (move[i].charAt(p) != '?') continue;
                    positions.add(new MovesetDirection(new class_2338(p - 2, 0, i - 2), false, false, true));
                    continue;
                }
                if (facing == 1) {
                    if (move[i].charAt(p) == '1') {
                        positions.add(new MovesetDirection(new class_2338(-p + 2, 0, -i + 2), false, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '*') {
                        positions.add(new MovesetDirection(new class_2338(-p + 2, 0, -i + 2), true, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '!') {
                        positions.add(new MovesetDirection(new class_2338(-p + 2, 0, -i + 2), false, true, false));
                        continue;
                    }
                    if (move[i].charAt(p) != '?') continue;
                    positions.add(new MovesetDirection(new class_2338(-p + 2, 0, -i + 2), false, false, true));
                    continue;
                }
                if (facing == 2) {
                    if (move[i].charAt(p) == '1') {
                        positions.add(new MovesetDirection(new class_2338(i - 2, 0, p - 2), false, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '*') {
                        positions.add(new MovesetDirection(new class_2338(i - 2, 0, p - 2), true, false, false));
                        continue;
                    }
                    if (move[i].charAt(p) == '!') {
                        positions.add(new MovesetDirection(new class_2338(i - 2, 0, p - 2), false, true, false));
                        continue;
                    }
                    if (move[i].charAt(p) != '?') continue;
                    positions.add(new MovesetDirection(new class_2338(i - 2, 0, p - 2), false, false, true));
                    continue;
                }
                if (facing != 3) continue;
                if (move[i].charAt(p) == '1') {
                    positions.add(new MovesetDirection(new class_2338(-i + 2, 0, -p + 2), false, false, false));
                    continue;
                }
                if (move[i].charAt(p) == '*') {
                    positions.add(new MovesetDirection(new class_2338(-i + 2, 0, -p + 2), true, false, false));
                    continue;
                }
                if (move[i].charAt(p) == '!') {
                    positions.add(new MovesetDirection(new class_2338(-i + 2, 0, -p + 2), false, true, false));
                    continue;
                }
                if (move[i].charAt(p) != '?') continue;
                positions.add(new MovesetDirection(new class_2338(-i + 2, 0, -p + 2), false, false, true));
            }
        }
        return positions;
    }

    public class GamePiece {
        public int piece;
        public class_2338 pos;
        public int color;
        public int facing;

        public GamePiece(class_2338 pos, int piece, int color, int facing) {
            this.piece = piece;
            this.pos = pos;
            this.color = color;
            this.facing = facing;
        }
    }

    public class Moveset {
        public String[] movements = new String[]{"     ", "  1  ", " 1O1 ", "  1  ", "     "};

        public Moveset(String[] movements) {
            this.movements = movements;
        }
    }

    class MovesetDirection {
        public class_2338 direction;
        public boolean infinite;
        public boolean mustDefeat;
        public boolean cannotDefeat;

        public MovesetDirection(class_2338 p, boolean inf, boolean mustDefeat, boolean cannotDefeat) {
            this.direction = p;
            this.infinite = inf;
            this.mustDefeat = mustDefeat;
            this.cannotDefeat = cannotDefeat;
        }
    }

    class Selection {
        public class_2338 pos;
        public float[] color;

        public Selection(class_2338 p, float[] color) {
            this.pos = p;
            this.color = color;
        }
    }

    public class GameBoard {
        public GamePiece piece;
        public class_2338 pos;

        public GameBoard(class_2338 pos, GamePiece piece) {
            this.piece = piece;
            this.pos = pos;
        }
    }
}

