/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.BuildingDimension.Persistance;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.BuildingDimension.BuildingDimension;
import net.fabricmc.BuildingDimension.Persistance.PersistenceManager;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class PersistentPlayer {
    private final PersistenceManager manager;

    public PersistentPlayer(@NotNull MinecraftServer server) {
        this.manager = PersistenceManager.getSavedData(server);
    }

    public void save(class_3222 player, class_5321<class_1937> dimension) {
        this.savePlayerInventory(player, dimension);
        if (!dimension.method_29177().method_12836().equals("building_dimension")) {
            this.savePosition(player);
            this.saveGamemode(player);
            this.saveEnderChest(player, dimension);
            this.saveExperience(player);
            this.saveEffect(player);
            this.saveAchievements(player);
            if (BuildingDimension.isModLoaded("trinkets")) {
                this.saveTrinkets(player);
            }
        }
    }

    public void cleanPlayer(@NotNull class_3222 player) {
        player.method_31548().method_5448();
        player.method_7274().method_5448();
        player.method_14252(0);
        player.field_7510 = 0.0f;
        player.method_6026().clear();
        player.method_7336(class_1934.field_9215);
        MinecraftServer server = player.method_5682();
        if (server == null) {
            BuildingDimension.logError("Failed to completely clean the player : getting the server failed", new Exception(), player.method_5671());
            return;
        }
        for (class_161 advancement : server.method_3851().method_12893()) {
            Map criteria = advancement.method_682();
            for (String criterion : criteria.keySet()) {
                player.method_14236().method_12883(advancement, criterion);
            }
        }
        if (BuildingDimension.isModLoaded("trinkets") && TrinketsApi.getTrinketComponent((class_1309)player).isPresent()) {
            ((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).getAllEquipped().forEach(pair -> {
                SlotReference slot = (SlotReference)pair.method_15442();
                slot.inventory().method_5448();
            });
        }
    }

    public void load(class_3222 player, class_5321<class_1937> dimension) {
        this.loadPlayerInventory(player, dimension);
        this.loadEnderChest(player, dimension);
        if (!dimension.method_29177().method_12836().equals("building_dimension")) {
            this.loadExperience(player);
            this.loadEffects(player);
            this.loadAchievements(player);
            if (BuildingDimension.isModLoaded("trinkets")) {
                this.loadTrinkets(player);
            }
        }
    }

    private void savePlayerInventory(@NotNull class_3222 player, class_5321<class_1937> dimension) {
        this.saveInventory(player.method_5845(), player.method_31548().method_7384(new class_2499()), dimension, "player_inventory");
    }

    private void saveEnderChest(@NotNull class_3222 player, class_5321<class_1937> dimension) {
        this.saveInventory(player.method_5845(), player.method_7274().method_7660(), dimension, "ender_chest");
    }

    private void loadPlayerInventory(class_3222 player, class_5321<class_1937> dimension) {
        class_2499 inv = this.loadInventory(player, dimension, "player_inventory");
        player.method_31548().method_7397(inv);
    }

    private void loadEnderChest(class_3222 player, class_5321<class_1937> dimension) {
        class_2499 inv = this.loadInventory(player, dimension, "ender_chest");
        player.method_7274().method_7659(inv);
    }

    private void saveInventory(String uuid, class_2499 inventory, class_5321<class_1937> dimension, String inventory_name) {
        class_2487 dimension_nbt;
        class_2487 player_nbt = (class_2487)this.manager.load(uuid);
        if (player_nbt == null) {
            player_nbt = new class_2487();
        }
        if ((dimension_nbt = player_nbt.method_10562(dimension.method_29177().toString())) == null) {
            dimension_nbt = new class_2487();
        }
        dimension_nbt.method_10566(inventory_name, (class_2520)inventory);
        player_nbt.method_10566(dimension.method_29177().toString(), (class_2520)dimension_nbt);
        this.manager.save(uuid, (class_2520)player_nbt);
    }

    @NotNull
    private class_2499 loadInventory(@NotNull class_3222 player, class_5321<class_1937> dimension, String inventory_name) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            return new class_2499();
        }
        class_2487 dimension_nbt = player_nbt.method_10562(dimension.method_29177().toString());
        if (dimension_nbt == null) {
            return new class_2499();
        }
        class_2499 inventory_nbt = dimension_nbt.method_10554(inventory_name, 10);
        if (inventory_nbt == null) {
            return new class_2499();
        }
        return inventory_nbt;
    }

    private void saveExperience(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            player_nbt = new class_2487();
        }
        player_nbt.method_10569("experience", player.field_7520);
        player_nbt.method_10548("experienceProgress", player.field_7510);
        this.manager.save(player.method_5845(), (class_2520)player_nbt);
    }

    private void loadExperience(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            return;
        }
        player.method_14252(player_nbt.method_10550("experience"));
        player.field_7510 = player_nbt.method_10583("experienceProgress");
    }

    private void saveEffect(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            player_nbt = new class_2487();
        }
        class_2499 effects = new class_2499();
        for (class_1293 status : player.method_6026()) {
            class_2487 effect = new class_2487();
            effect.method_10569("effect", class_1291.method_5554((class_1291)status.method_5579()));
            effect.method_10569("duration", status.method_5584());
            effect.method_10569("amplifier", status.method_5578());
            effect.method_10556("ambient", status.method_5591());
            effect.method_10556("visible", status.method_5581());
            effect.method_10556("showIcon", status.method_5592());
            effects.add((Object)effect);
        }
        player_nbt.method_10566("effects", (class_2520)effects);
        this.manager.save(player.method_5845(), (class_2520)player_nbt);
    }

    private void loadEffects(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            return;
        }
        class_2499 effects = player_nbt.method_10554("effects", 10);
        if (effects == null) {
            return;
        }
        for (int i = 0; i < effects.size(); ++i) {
            class_2487 effect = effects.method_10602(i);
            class_1293 status = new class_1293(Objects.requireNonNull(class_1291.method_5569((int)effect.method_10550("effect"))), effect.method_10550("duration"), effect.method_10550("amplifier"), effect.method_10577("ambient"), effect.method_10577("visible"), effect.method_10577("showIcon"));
            player.method_6092(status);
        }
    }

    private void savePosition(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            player_nbt = new class_2487();
        }
        class_2487 position = new class_2487();
        position.method_10549("x", player.method_23317());
        position.method_10549("y", player.method_23318());
        position.method_10549("z", player.method_23321());
        player_nbt.method_10566("position", (class_2520)position);
        this.manager.save(player.method_5845(), (class_2520)player_nbt);
    }

    @NotNull
    public class_243 getPosition(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            return new class_243(0.0, 0.0, 0.0);
        }
        class_2487 position = player_nbt.method_10562("position");
        if (position == null) {
            return new class_243(0.0, 0.0, 0.0);
        }
        return new class_243(position.method_10574("x"), position.method_10574("y"), position.method_10574("z"));
    }

    private void saveGamemode(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            player_nbt = new class_2487();
        }
        player_nbt.method_10569("gamemode", player.field_13974.method_14257().method_8379());
        this.manager.save(player.method_5845(), (class_2520)player_nbt);
    }

    public class_1934 getGamemode(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            return class_1934.field_9220;
        }
        return class_1934.method_8384((int)player_nbt.method_10550("gamemode"));
    }

    private void saveAchievements(@NotNull class_3222 player) {
        MinecraftServer server;
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            player_nbt = new class_2487();
        }
        if ((server = player.method_5682()) == null) {
            BuildingDimension.logError("Failed to save achievements: server is null", new Exception(), player.method_5671());
            return;
        }
        class_2499 achievements = new class_2499();
        for (class_161 advancement : server.method_3851().method_12893()) {
            Iterable iterable = player.method_14236().method_12882(advancement).method_734();
            for (String s : iterable) {
                class_2487 achievement = new class_2487();
                achievement.method_10582("advancement", advancement.method_688().toString());
                achievement.method_10582("criterion", s);
                achievements.add((Object)achievement);
            }
        }
        player_nbt.method_10566("achievements", (class_2520)achievements);
        this.manager.save(player.method_5845(), (class_2520)player_nbt);
    }

    private void loadAchievements(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            return;
        }
        class_2499 achievements = player_nbt.method_10554("achievements", 10);
        if (achievements == null) {
            return;
        }
        MinecraftServer server = player.method_5682();
        if (server == null) {
            BuildingDimension.logError("Failed to load achievements: server is null", new Exception(), player.method_5671());
            return;
        }
        class_1928.class_4310 announce = (class_1928.class_4310)player.method_37908().method_8450().method_20746(class_1928.field_19409);
        boolean should_announce = announce.method_20753();
        announce.method_20758(false, server);
        for (int i = 0; i < achievements.size(); ++i) {
            class_2487 achievement = achievements.method_10602(i);
            player.method_14236().method_12878(server.method_3851().method_12896(new class_2960(achievement.method_10558("advancement"))), achievement.method_10558("criterion"));
        }
        announce.method_20758(should_announce, server);
    }

    private void saveTrinkets(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            player_nbt = new class_2487();
        }
        class_2487 trinkets = new class_2487();
        if (TrinketsApi.getTrinketComponent((class_1309)player).isPresent()) {
            ((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).writeToNbt(trinkets);
        }
        player_nbt.method_10566("trinkets", (class_2520)trinkets);
        this.manager.save(player.method_5845(), (class_2520)player_nbt);
    }

    private void loadTrinkets(@NotNull class_3222 player) {
        class_2487 player_nbt = (class_2487)this.manager.load(player.method_5845());
        if (player_nbt == null) {
            return;
        }
        class_2487 trinkets = player_nbt.method_10562("trinkets");
        if (trinkets == null) {
            return;
        }
        if (TrinketsApi.getTrinketComponent((class_1309)player).isPresent()) {
            ((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).readFromNbt(trinkets);
        }
    }
}

