/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.BuildingDimension.Persistance;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.BuildingDimension.BuildingDimension;
import net.fabricmc.BuildingDimension.Persistance.PersistenceManager;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class PersistentDimensions {
    private final PersistenceManager manager;

    public PersistentDimensions(@NotNull MinecraftServer server) {
        this.manager = PersistenceManager.getSavedData(server);
    }

    public void save(Map<class_5321<class_1937>, class_5321<class_1937>> dimensions) {
        class_2487 nbt = new class_2487();
        for (Map.Entry<class_5321<class_1937>, class_5321<class_1937>> entry : dimensions.entrySet()) {
            nbt.method_10566(entry.getKey().method_29177().toString(), PersistentDimensions.worldKeyToNBT(entry.getValue()));
        }
        this.manager.save("dimensions", (class_2520)nbt);
    }

    public Map<class_5321<class_1937>, class_5321<class_1937>> load() {
        class_2487 nbt = (class_2487)this.manager.load("dimensions");
        if (nbt == null) {
            return new HashMap<class_5321<class_1937>, class_5321<class_1937>>();
        }
        HashMap<class_5321<class_1937>, class_5321<class_1937>> dimensions = new HashMap<class_5321<class_1937>, class_5321<class_1937>>();
        for (String key : nbt.method_10541()) {
            class_5321<class_1937> dimension = PersistentDimensions.nbtToWorldKey(nbt.method_10580(key));
            if (dimension != null) {
                class_5321 world = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(key));
                dimensions.put((class_5321<class_1937>)world, dimension);
                continue;
            }
            BuildingDimension.log("Failed to load dimension: " + key);
        }
        return dimensions;
    }

    private static class_2520 worldKeyToNBT(class_5321<class_1937> dimension) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("namespace", dimension.method_29177().method_12836());
        nbt.method_10582("path", dimension.method_29177().method_12832());
        return nbt;
    }

    private static class_5321<class_1937> nbtToWorldKey(class_2520 nbt) {
        if (nbt == null) {
            return null;
        }
        class_2487 compound = (class_2487)nbt;
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compound.method_10558("namespace"), compound.method_10558("path")));
    }
}

