/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.BuildingDimension;

import com.moandjiezana.toml.Toml;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.BuildingDimension.BuildingDimension;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class Configs {
    private static final String FILE_NAME = "building_dimension.toml";
    public static final String FILE_PATH = String.valueOf(FabricLoader.getInstance().getConfigDir()) + "/building_dimension.toml";
    private static final File FILE = new File(FILE_PATH);
    public static int MAX_RADIUS = 8;
    public static boolean ONLY_OP = false;
    public static boolean NON_OPS_SPECTATOR = true;
    public static boolean OP_SYNC = false;

    public static void load() {
        if (!FILE.exists()) {
            Configs.generate();
            return;
        }
        Toml toml = new Toml().read(FILE);
        Configs.check_config(toml, "max_radius", config_value -> {
            MAX_RADIUS = Integer.max(1, Integer.min(32, toml.getLong(config_value).intValue()));
            return MAX_RADIUS;
        });
        Configs.check_config(toml, "only_ops", config_value -> {
            ONLY_OP = toml.getBoolean(config_value);
            return ONLY_OP;
        });
        Configs.check_config(toml, "non_ops_spectators", config_value -> {
            NON_OPS_SPECTATOR = toml.getBoolean(config_value);
            return NON_OPS_SPECTATOR;
        });
        Configs.check_config(toml, "op_sync", config_value -> {
            OP_SYNC = toml.getBoolean(config_value);
            return OP_SYNC;
        });
    }

    private static void generate() {
        try {
            Files.copy(Objects.requireNonNull(BuildingDimension.class.getResourceAsStream("/assets/config/building_dimension.toml")), FILE.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            BuildingDimension.logError("Failed to generate config file!", e, null);
        }
    }

    private static void check_config(@NotNull Toml toml, String config_value, Function<String, Object> apply) {
        if (toml.contains(config_value)) {
            try {
                apply.apply(config_value);
            }
            catch (Exception e) {
                BuildingDimension.logError("Failed to load config value: " + config_value, e, null);
            }
        }
    }
}

