/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.BuildingDimension.Commands;

import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import net.fabricmc.BuildingDimension.BuildingDimension;
import net.fabricmc.BuildingDimension.Commands.SwitchDimension;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.server.MinecraftServer;

public class SyncDimension {
    public static MinecraftServer server;
    public static final Queue<class_3545<class_2818, class_1937>> chunksToSync;

    public static int sync_chunk_one(CommandContext<class_2168> context) {
        return SyncDimension.sync(context, 1);
    }

    public static int sync_chunk_radius(CommandContext<class_2168> context) {
        return SyncDimension.sync(context, (Integer)context.getArgument("radius", Integer.class));
    }

    private static int sync(CommandContext<class_2168> context, int radius) {
        try {
            class_3218 building_world;
            class_3218 world;
            if (server == null) {
                server = Objects.requireNonNull(((class_2168)context.getSource()).method_9211());
            }
            BuildingDimension.log("Syncing chunks in radius " + radius + " around " + ((class_2168)context.getSource()).method_9222().toString());
            if (((class_2168)context.getSource()).method_9225().method_27983().method_29177().method_12836().equals("building_dimension")) {
                world = ((class_2168)context.getSource()).method_9211().method_3847(SwitchDimension.DIMENSIONS.get(((class_2168)context.getSource()).method_9225().method_27983()));
                building_world = ((class_2168)context.getSource()).method_9225();
            } else {
                world = ((class_2168)context.getSource()).method_9225();
                building_world = ((class_2168)context.getSource()).method_9211().method_3847(SwitchDimension.DIMENSIONS.get(((class_2168)context.getSource()).method_9225().method_27983()));
            }
            if (world == null) {
                BuildingDimension.log("Failed to sync chunks: unable to find world for which to sync chunks from");
                return -1;
            }
            if (building_world == null) {
                BuildingDimension.log("Failed to sync chunks: unable to find world for which to sync chunks to");
                return -1;
            }
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    int chunkX = (int)Math.floor(((class_2168)context.getSource()).method_9222().field_1352 / 16.0) + x;
                    int chunkZ = (int)Math.floor(((class_2168)context.getSource()).method_9222().field_1350 / 16.0) + z;
                    class_2818 chunk = world.method_8497(chunkX, chunkZ);
                    chunksToSync.add((class_3545<class_2818, class_1937>)new class_3545((Object)chunk, (Object)building_world));
                }
            }
            return 0;
        }
        catch (Exception e) {
            BuildingDimension.logError("Failed to sync chunks: ", e, (class_2168)context.getSource());
            return -1;
        }
    }

    static {
        chunksToSync = new LinkedList<class_3545<class_2818, class_1937>>();
    }
}

