/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.BuildingDimension.Commands;

import com.mojang.brigadier.context.CommandContext;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.BuildingDimension.BuildingDimension;
import net.fabricmc.BuildingDimension.Persistance.PersistentDimensions;
import net.fabricmc.BuildingDimension.Persistance.PersistentPlayer;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5454;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import qouteall.q_misc_util.api.DimensionAPI;

public class SwitchDimension {
    public static Map<class_5321<class_1937>, class_5321<class_1937>> DIMENSIONS = new HashMap<class_5321<class_1937>, class_5321<class_1937>>();
    private static final Map<UUID, Long> last_switch = new HashMap<UUID, Long>();
    public static final Set<UUID> allowed_switching = new HashSet<UUID>();

    public static int switch_dim(@NotNull CommandContext<class_2168> context) {
        try {
            class_1934 gamemode;
            class_243 position;
            class_2168 source = (class_2168)context.getSource();
            class_3222 player = source.method_44023();
            if (player == null) {
                source.method_45068((class_2561)class_2561.method_43470((String)"You must be a player to use this command"));
                return -1;
            }
            if (SwitchDimension.isOnCooldown(player)) {
                source.method_45068((class_2561)class_2561.method_43470((String)"You must wait 5 seconds between dimension switches"));
                return -1;
            }
            if (SwitchDimension.setupDimensions(source)) {
                source.method_45068((class_2561)class_2561.method_43470((String)"Error creating new dimension"));
                return -1;
            }
            PersistentPlayer persistent_player = new PersistentPlayer(source.method_9211());
            class_5321<class_1937> target_dim = DIMENSIONS.get(source.method_9225().method_27983());
            BuildingDimension.log("Switching dimension to : " + String.valueOf(target_dim.method_29177()));
            persistent_player.save(player, (class_5321<class_1937>)source.method_9225().method_27983());
            persistent_player.cleanPlayer(player);
            if (player.method_37908().method_27983().method_29177().method_12836().equals("building_dimension")) {
                BuildingDimension.log("Loading from save");
                position = persistent_player.getPosition(player);
                gamemode = persistent_player.getGamemode(player);
            } else {
                BuildingDimension.log("Saving to save");
                position = player.method_19538();
                gamemode = class_1934.field_9220;
            }
            player.method_7336(gamemode);
            class_5454 target = new class_5454(position, new class_243(0.0, 0.0, 0.0), player.method_36454(), player.method_36455());
            BuildingDimension.log("Teleporting player to : " + String.valueOf(target_dim.method_29177()));
            BuildingDimension.log("Teleporting player to : " + target.field_25879.toString());
            BuildingDimension.log("Switching player gamemode to : " + gamemode.toString());
            allowed_switching.add(player.method_5667());
            FabricDimensions.teleport((class_1297)player, (class_3218)source.method_9211().method_3847(target_dim), (class_5454)target);
            allowed_switching.remove(player.method_5667());
            persistent_player.load(player, target_dim);
            return 1;
        }
        catch (Exception e) {
            BuildingDimension.logError("Failed to switch dimension: ", e, (class_2168)context.getSource());
            return -1;
        }
    }

    private static boolean setupDimensions(@NotNull class_2168 source) {
        if (!DIMENSIONS.containsKey(source.method_9225().method_27983())) {
            class_3218 world = source.method_9225();
            BuildingDimension.log("Creating new dimension : " + world.method_27983().method_29177().method_12832());
            if (SwitchDimension.createDimension(source.method_9211(), (class_5321<class_1937>)world.method_27983())) {
                return true;
            }
            class_5321 building_dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960("building_dimension", world.method_27983().method_29177().method_12832()));
            DIMENSIONS.put((class_5321<class_1937>)world.method_27983(), (class_5321<class_1937>)building_dimension);
            DIMENSIONS.put((class_5321<class_1937>)building_dimension, (class_5321<class_1937>)world.method_27983());
            new PersistentDimensions(source.method_9211()).save(DIMENSIONS);
        }
        return false;
    }

    public static boolean createDimension(MinecraftServer server, class_5321<class_1937> dimension) {
        if (dimension.method_29177().method_12836().equals("building_dimension")) {
            return false;
        }
        class_3218 world = server.method_3847(dimension);
        if (world == null) {
            BuildingDimension.logError("Failed to load world: ", new Exception(), null);
            return true;
        }
        try {
            DimensionAPI.addDimensionDynamically((class_2960)new class_2960("building_dimension", dimension.method_29177().method_12832()), (class_5363)new class_5363(world.method_40134(), world.method_14178().method_12129()));
        }
        catch (Exception e) {
            BuildingDimension.logError("Failed to create dimension: ", e, null);
            return true;
        }
        BuildingDimension.log("Loaded building dimension equivalent of : " + String.valueOf(dimension.method_29177()));
        return false;
    }

    private static boolean isOnCooldown(@NotNull class_3222 player) {
        if (last_switch.containsKey(player.method_5667())) {
            long last_switch_time = last_switch.get(player.method_5667());
            long current_time = new Date().getTime();
            return current_time - last_switch_time < 5000L;
        }
        last_switch.put(player.method_5667(), new Date().getTime());
        return false;
    }
}

