/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.BuildingDimension;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.fabricmc.BuildingDimension.Commands.SwitchDimension;
import net.fabricmc.BuildingDimension.Commands.SyncDimension;
import net.fabricmc.BuildingDimension.Commands.Teleport;
import net.fabricmc.BuildingDimension.Configs;
import net.fabricmc.BuildingDimension.Events.dimensionLoading;
import net.fabricmc.BuildingDimension.Persistance.PersistenceManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildingDimension
implements ModInitializer {
    public static final String MOD_ID = "building_dimension";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"building_dimension");

    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public void onInitialize() {
        Configs.load();
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
        this.registerEvents();
    }

    private void registerCommands(@NotNull CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"building").executes(SwitchDimension::switch_dim)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sync").requires(source -> source.method_9259(Configs.OP_SYNC ? 2 : 0))).executes(SyncDimension::sync_chunk_one)).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Configs.MAX_RADIUS)).executes(SyncDimension::sync_chunk_radius)))).then(class_2170.method_9247((String)"teleport").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(Teleport::teleport))));
    }

    public static void logError(@NotNull String s, @NotNull Exception e, @Nullable class_2168 source) {
        StackTraceElement[] stackTrace;
        LOGGER.error(s + e.getMessage());
        for (StackTraceElement element : stackTrace = e.getStackTrace()) {
            LOGGER.error(element.toString());
        }
        if (source != null) {
            source.method_9213(class_2561.method_30163((String)(s + e.getMessage())));
        }
    }

    public static void log(String message) {
        LOGGER.info(message);
    }

    private void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(PersistenceManager::getSavedData);
        dimensionLoading.init();
        net.fabricmc.BuildingDimension.Events.SyncDimension.init();
    }
}

