/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.network.packet;

import mod.azure.azurelibarmor.animatable.SingletonGeoAnimatable;
import mod.azure.azurelibarmor.constant.DataTickets;
import mod.azure.azurelibarmor.core.animatable.GeoAnimatable;
import mod.azure.azurelibarmor.network.AbstractPacket;
import mod.azure.azurelibarmor.network.SerializableDataTicket;
import mod.azure.azurelibarmor.platform.services.AzureLibNetwork;
import mod.azure.azurelibarmor.util.ClientUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class AnimDataSyncPacket<D>
extends AbstractPacket {
    private final String syncableId;
    private final long instanceId;
    private final SerializableDataTicket<D> dataTicket;
    private final D data;

    public AnimDataSyncPacket(String syncableId, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10814(this.syncableId);
        buf.method_10791(this.instanceId);
        buf.method_10814(this.dataTicket.id());
        this.dataTicket.encode(this.data, buf);
    }

    @Override
    public class_2960 getPacketID() {
        return AzureLibNetwork.ANIM_DATA_SYNC_PACKET_ID;
    }

    public static <D> AnimDataSyncPacket<D> receive(class_2540 buf) {
        String syncableId = buf.method_19772();
        long instanceID = buf.method_10792();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(buf.method_19772());
        Object data = dataTicket.decode(buf);
        return new AnimDataSyncPacket(syncableId, instanceID, dataTicket, data);
    }

    @Override
    public void handle() {
        GeoAnimatable animatable = AzureLibNetwork.getSyncedAnimatable(this.syncableId);
        if (animatable instanceof SingletonGeoAnimatable) {
            SingletonGeoAnimatable singleton = (SingletonGeoAnimatable)animatable;
            singleton.setAnimData((class_1297)ClientUtils.getClientPlayer(), this.instanceId, this.dataTicket, this.data);
        }
    }
}

