/*
 * Decompiled with CFR 0.152.
 */
package com.grim3212.assorted.tools.config;

import com.google.common.collect.Lists;
import com.grim3212.assorted.lib.config.ConfigurationType;
import com.grim3212.assorted.lib.config.IConfigurationBuilder;
import com.grim3212.assorted.lib.platform.Services;
import com.grim3212.assorted.tools.api.item.ToolsArmorMaterials;
import com.grim3212.assorted.tools.api.item.ToolsItemTier;
import com.grim3212.assorted.tools.config.ArmorMaterialConfig;
import com.grim3212.assorted.tools.config.ItemTierConfig;
import com.grim3212.assorted.tools.config.ModdedItemTierConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public class ToolsCommonConfig {
    public final Supplier<Boolean> wandsEnabled;
    public final Supplier<Boolean> boomerangsEnabled;
    public final Supplier<Boolean> hammersEnabled;
    public final Supplier<Boolean> multiToolsEnabled;
    public final Supplier<Boolean> pokeballEnabled;
    public final Supplier<Boolean> chickenSuitEnabled;
    public final Supplier<Boolean> extraMaterialsEnabled;
    public final Supplier<Boolean> spearsEnabled;
    public final Supplier<Boolean> betterSpearsEnabled;
    public final Supplier<Boolean> betterBucketsEnabled;
    public final Supplier<Boolean> moreShearsEnabled;
    public final Supplier<Boolean> ultimateFistEnabled;
    public final Supplier<Boolean> hideUncraftableItems;
    public final Supplier<Boolean> allowPartialBucketAmounts;
    public final Supplier<Boolean> freeBuildMode;
    public final Supplier<Boolean> bedrockBreaking;
    public final Supplier<Boolean> easyMiningObsidian;
    public final Supplier<Boolean> turnAroundItem;
    public final Supplier<Boolean> turnAroundMob;
    public final Supplier<Boolean> breaksTorches;
    public final Supplier<Boolean> breaksPlants;
    public final Supplier<Boolean> hitsButtons;
    public final Supplier<Boolean> turnAroundButton;
    public final Supplier<Integer> woodBoomerangRange;
    public final Supplier<Integer> woodBoomerangDamage;
    public final Supplier<Integer> diamondBoomerangRange;
    public final Supplier<Integer> diamondBoomerangDamage;
    public final Supplier<Boolean> diamondBoomerangFollows;
    public final Supplier<List<? extends Float>> conductivityLightningChances;
    public final ItemTierConfig woodItemTier;
    public final ItemTierConfig stoneItemTier;
    public final ItemTierConfig goldItemTier;
    public final ItemTierConfig ironItemTier;
    public final ItemTierConfig diamondItemTier;
    public final ItemTierConfig netheriteItemTier;
    public final ItemTierConfig ultimateItemTier;
    public final ArmorMaterialConfig chickenSuitArmorMaterial;
    public final Map<String, ModdedItemTierConfig> moddedTiers;
    public final Map<String, ArmorMaterialConfig> moddedArmors;

    public ToolsCommonConfig() {
        IConfigurationBuilder builder = Services.CONFIG.createBuilder(ConfigurationType.NOT_SYNCED, "assortedtools-common");
        this.wandsEnabled = builder.defineBoolean("parts.wandsEnabled", true, "Set this to true if you would like wands to be craftable and found in the creative tab.");
        this.boomerangsEnabled = builder.defineBoolean("parts.boomerangsEnabled", true, "Set this to true if you would like boomerangs to be craftable and found in the creative tab.");
        this.hammersEnabled = builder.defineBoolean("parts.hammersEnabled", true, "Set this to true if you would like hammers to be craftable and found in the creative tab.");
        this.multiToolsEnabled = builder.defineBoolean("parts.multiToolsEnabled", true, "Set this to true if you would like multitools to be craftable and found in the creative tab.");
        this.pokeballEnabled = builder.defineBoolean("parts.pokeballEnabled", true, "Set this to true if you would like the pokeball to be craftable and found in the creative tab.");
        this.chickenSuitEnabled = builder.defineBoolean("parts.chickenSuitEnabled", true, "Set this to true if you would like the chicken suit to be craftable and found in the creative tab as well as if you want the Chicken Jump enchantment to be able to be applied.");
        this.extraMaterialsEnabled = builder.defineBoolean("parts.extraMaterialsEnabled", true, "Set this to true if you would like to enable support for crafting the extra tools and armor that this supports. For example, Steel, Copper, or Ruby tools and armor.");
        this.spearsEnabled = builder.defineBoolean("parts.spearsEnabled", false, "Set this to true if you would like the old DEPRECATED spears to be craftable and found in the creative tab.");
        this.betterSpearsEnabled = builder.defineBoolean("parts.betterSpearsEnabled", true, "Set this to true if you would like the better spears (the ones that can be enchanted) to be craftable and found in the creative tab as well as the Enchantments for it to be enchanted on books.");
        this.betterBucketsEnabled = builder.defineBoolean("parts.betterBucketsEnabled", true, "Set this to true if you would like better buckets to be craftable and found in the creative tab.");
        this.moreShearsEnabled = builder.defineBoolean("parts.moreShearsEnabled", true, "Set this to true if you would like the extra shears to be craftable and found in the creative tab.");
        this.ultimateFistEnabled = builder.defineBoolean("parts.ultimateFistEnabled", true, "Set this to true if you would like the ultimate fist to be craftable and found in the creative tab as well as the fragments generate in loot.");
        this.hideUncraftableItems = builder.defineBoolean("general.hideUncraftableItems", false, "For any item that is unobtainable (like missing materials from other mods) hide it from the creative menu / JEI.");
        this.allowPartialBucketAmounts = builder.defineBoolean("better_buckets.allowPartialBucketAmounts", false, "Set to true if you would like the better buckets to be able to accept partial bucket amounts. Meaning some can get left over after placing all the full buckets.");
        this.freeBuildMode = builder.defineBoolean("wands.freeBuildMode", false, "Set to true if you would like the wands to not require any blocks to build with.");
        this.bedrockBreaking = builder.defineBoolean("wands.bedrockBreaking", false, "Set to true if you would like the breaking wands to be able to break bedrock.");
        this.easyMiningObsidian = builder.defineBoolean("wands.easyMiningObsidian", false, "Set to true if you would like the mining wands to be able to mine obsidian.");
        this.turnAroundItem = builder.defineBoolean("boomerangs.turnAroundItem", false, "Set this to true if you would like boomerangs to turn around after they have picked up items.");
        this.turnAroundMob = builder.defineBoolean("boomerangs.turnAroundMob", false, "Set this to true if you would like boomerangs to turn around after they have hit a mob.");
        this.breaksTorches = builder.defineBoolean("boomerangs.breaksTorches", false, "Set this to true if you would like boomerangs to be able to break torches.");
        this.breaksPlants = builder.defineBoolean("boomerangs.breaksPlants", false, "Set this to true if you would like boomerangs to be able to break plants and any other weak blocks.");
        this.hitsButtons = builder.defineBoolean("boomerangs.hitsButtons", true, "Set this to false if you would like boomerangs to not be able to hit buttons or levers.");
        this.turnAroundButton = builder.defineBoolean("boomerangs.turnAroundButton", true, "Set this to false if you would like boomerangs to not turn around after they have hit a button or a lever.");
        this.woodBoomerangRange = builder.defineInteger("boomerangs.woodBoomerangRange", 20, 1, 200, "The maximum range away from the player the wood boomerang will travel before turning around.");
        this.woodBoomerangDamage = builder.defineInteger("boomerangs.woodBoomerangDamage", 1, 1, 500, "The amount of damage the wood boomerang does to mobs.");
        this.diamondBoomerangRange = builder.defineInteger("boomerangs.diamondBoomerangRange", 30, 1, 200, "The maximum range away from the player the diamond boomerang will travel before turning around.");
        this.diamondBoomerangDamage = builder.defineInteger("boomerangs.diamondBoomerangDamage", 5, 1, 200, "The amount of damage the diamond boomerang does to mobs.");
        this.diamondBoomerangFollows = builder.defineBoolean("boomerangs.diamondBoomerangFollows", false, "Set to true if you would like the diamond boomerang to follow where the player is looking.");
        this.conductivityLightningChances = builder.defineList("better_spears.conductivityLightningChances", (List)Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.6f), Float.valueOf(0.3f), Float.valueOf(0.1f)}), Float.class, "The chances modifier for lightning to spawn at each level of conductivity. The smaller the number the higher chance.");
        this.woodItemTier = new ItemTierConfig(builder, "wood", "vanilla_tool_overrides", (class_1832)class_1834.field_8922, 6.0f, -3.2f, 1, 0, 1000.0f, true, 1.5f);
        this.stoneItemTier = new ItemTierConfig(builder, "stone", "vanilla_tool_overrides", (class_1832)class_1834.field_8927, 7.0f, -3.2f, 1, 0, 5000.0f, true, 1.5f);
        this.goldItemTier = new ItemTierConfig(builder, "gold", "vanilla_tool_overrides", (class_1832)class_1834.field_8929, 6.0f, -3.0f, 4, 0, 5000.0f, false, 1.5f);
        this.ironItemTier = new ItemTierConfig(builder, "iron", "vanilla_tool_overrides", (class_1832)class_1834.field_8923, 6.0f, -3.1f, 1, 0, 5000.0f, false, 1.5f);
        this.diamondItemTier = new ItemTierConfig(builder, "diamond", "vanilla_tool_overrides", (class_1832)class_1834.field_8930, 5.0f, -3.0f, 16, 1, 5000.0f, false, 1.5f);
        this.netheriteItemTier = new ItemTierConfig(builder, "netherite", "vanilla_tool_overrides", (class_1832)class_1834.field_22033, 5.0f, -3.0f, 64, 2, 10000.0f, false, 1.5f);
        this.ultimateItemTier = new ItemTierConfig(builder, "ultimate", "ultimate_fist", ToolsItemTier.ULTIMATE);
        this.chickenSuitArmorMaterial = new ArmorMaterialConfig(builder, "chicken_suit", "chicken_suit", 5, 15, 0.0f, 0.0f, new int[]{1, 2, 3, 1}, () -> ToolsArmorMaterials.CHICKEN_SUIT);
        this.moddedTiers = new HashMap<String, ModdedItemTierConfig>();
        this.moddedTiers.put("tin", new ModdedItemTierConfig(builder, "tin", "modded_tool_overrides", ToolsItemTier.TIN));
        this.moddedTiers.put("copper", new ModdedItemTierConfig(builder, "copper", "modded_tool_overrides", ToolsItemTier.COPPER));
        this.moddedTiers.put("silver", new ModdedItemTierConfig(builder, "silver", "modded_tool_overrides", ToolsItemTier.SILVER));
        this.moddedTiers.put("aluminum", new ModdedItemTierConfig(builder, "aluminum", "modded_tool_overrides", ToolsItemTier.ALUMINUM));
        this.moddedTiers.put("nickel", new ModdedItemTierConfig(builder, "nickel", "modded_tool_overrides", ToolsItemTier.NICKEL));
        this.moddedTiers.put("platinum", new ModdedItemTierConfig(builder, "platinum", "modded_tool_overrides", ToolsItemTier.PLATINUM));
        this.moddedTiers.put("lead", new ModdedItemTierConfig(builder, "lead", "modded_tool_overrides", ToolsItemTier.LEAD));
        this.moddedTiers.put("bronze", new ModdedItemTierConfig(builder, "bronze", "modded_tool_overrides", ToolsItemTier.BRONZE));
        this.moddedTiers.put("electrum", new ModdedItemTierConfig(builder, "electrum", "modded_tool_overrides", ToolsItemTier.ELECTRUM));
        this.moddedTiers.put("invar", new ModdedItemTierConfig(builder, "invar", "modded_tool_overrides", ToolsItemTier.INVAR));
        this.moddedTiers.put("steel", new ModdedItemTierConfig(builder, "steel", "modded_tool_overrides", ToolsItemTier.STEEL));
        this.moddedTiers.put("ruby", new ModdedItemTierConfig(builder, "ruby", "modded_tool_overrides", ToolsItemTier.RUBY));
        this.moddedTiers.put("amethyst", new ModdedItemTierConfig(builder, "amethyst", "modded_tool_overrides", ToolsItemTier.AMETHYST));
        this.moddedTiers.put("sapphire", new ModdedItemTierConfig(builder, "sapphire", "modded_tool_overrides", ToolsItemTier.SAPPHIRE));
        this.moddedTiers.put("topaz", new ModdedItemTierConfig(builder, "topaz", "modded_tool_overrides", ToolsItemTier.TOPAZ));
        this.moddedTiers.put("emerald", new ModdedItemTierConfig(builder, "emerald", "modded_tool_overrides", ToolsItemTier.EMERALD));
        this.moddedTiers.put("peridot", new ModdedItemTierConfig(builder, "peridot", "modded_tool_overrides", ToolsItemTier.PERIDOT));
        this.moddedArmors = new HashMap<String, ArmorMaterialConfig>();
        this.moddedArmors.put("tin", new ArmorMaterialConfig(builder, "tin", "modded_armor_overrides", 8, 14, 0.0f, 0.0f, new int[]{1, 3, 5, 2}, () -> ToolsArmorMaterials.TIN));
        this.moddedArmors.put("copper", new ArmorMaterialConfig(builder, "copper", "modded_armor_overrides", 11, 14, 0.0f, 0.0f, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.COPPER));
        this.moddedArmors.put("silver", new ArmorMaterialConfig(builder, "silver", "modded_armor_overrides", 27, 14, 0.0f, 0.0f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.SILVER));
        this.moddedArmors.put("aluminum", new ArmorMaterialConfig(builder, "aluminum", "modded_armor_overrides", 13, 10, 0.0f, 0.0f, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.ALUMINUM));
        this.moddedArmors.put("nickel", new ArmorMaterialConfig(builder, "nickel", "modded_armor_overrides", 13, 10, 0.0f, 0.0f, new int[]{2, 3, 4, 2}, () -> ToolsArmorMaterials.NICKEL));
        this.moddedArmors.put("platinum", new ArmorMaterialConfig(builder, "platinum", "modded_armor_overrides", 36, 18, 3.0f, 0.2f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.PLATINUM));
        this.moddedArmors.put("lead", new ArmorMaterialConfig(builder, "lead", "modded_armor_overrides", 13, 4, 0.0f, 0.0f, new int[]{2, 3, 4, 2}, () -> ToolsArmorMaterials.LEAD));
        this.moddedArmors.put("bronze", new ArmorMaterialConfig(builder, "bronze", "modded_armor_overrides", 14, 13, 0.0f, 0.1f, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.BRONZE));
        this.moddedArmors.put("electrum", new ArmorMaterialConfig(builder, "electrum", "modded_armor_overrides", 13, 13, 0.0f, 0.0f, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.ELECTRUM));
        this.moddedArmors.put("invar", new ArmorMaterialConfig(builder, "invar", "modded_armor_overrides", 15, 11, 0.2f, 0.1f, new int[]{2, 5, 6, 2}, () -> ToolsArmorMaterials.INVAR));
        this.moddedArmors.put("steel", new ArmorMaterialConfig(builder, "steel", "modded_armor_overrides", 26, 10, 0.5f, 0.3f, new int[]{2, 6, 7, 2}, () -> ToolsArmorMaterials.STEEL));
        this.moddedArmors.put("ruby", new ArmorMaterialConfig(builder, "ruby", "modded_armor_overrides", 34, 10, 2.0f, 0.0f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.RUBY));
        this.moddedArmors.put("amethyst", new ArmorMaterialConfig(builder, "amethyst", "modded_armor_overrides", 31, 14, 1.0f, 0.0f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.AMETHYST));
        this.moddedArmors.put("sapphire", new ArmorMaterialConfig(builder, "sapphire", "modded_armor_overrides", 31, 14, 1.0f, 0.0f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.SAPPHIRE));
        this.moddedArmors.put("topaz", new ArmorMaterialConfig(builder, "topaz", "modded_armor_overrides", 30, 8, 1.0f, 0.0f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.TOPAZ));
        this.moddedArmors.put("emerald", new ArmorMaterialConfig(builder, "emerald", "modded_armor_overrides", 32, 14, 2.0f, 0.0f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.EMERALD));
        this.moddedArmors.put("peridot", new ArmorMaterialConfig(builder, "peridot", "modded_armor_overrides", 30, 8, 1.0f, 0.0f, new int[]{3, 6, 8, 3}, () -> ToolsArmorMaterials.PERIDOT));
        builder.setup();
    }
}

